/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.command;

import java.sql.Connection;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.query.CreateQuery;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class CreateCommand<RESULT>
implements Command<RESULT> {
    protected final CreateQuery<RESULT> query;

    public CreateCommand(CreateQuery<RESULT> query) {
        this.query = query;
    }

    @Override
    public RESULT execute() {
        Connection connection = JdbcUtil.getConnection(this.query.getConfig().getDataSource());
        try {
            RESULT RESULT = this.query.create(connection);
            return RESULT;
        }
        catch (SQLException e) {
            throw new JdbcException((MessageResource)Message.DOMA2008, (Throwable)e, e);
        }
        finally {
            JdbcUtil.close(connection, this.query.getConfig().getJdbcLogger());
        }
    }
}

