/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.message;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractMessageResourceBundle<M extends Enum<M>>
extends ResourceBundle {
    protected final Class<M> messageCodeClass;

    protected AbstractMessageResourceBundle(Class<M> messageCodeClass) {
        if (messageCodeClass == null) {
            throw new DomaNullPointerException("messageCodeClass");
        }
        this.messageCodeClass = messageCodeClass;
    }

    @Override
    public Enumeration<String> getKeys() {
        LinkedList<String> keys = new LinkedList<String>();
        for (Enum messageCode : EnumSet.allOf(this.messageCodeClass)) {
            keys.add(((MessageResource)((Object)messageCode)).getCode());
        }
        return Collections.enumeration(keys);
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new DomaNullPointerException("key");
        }
        M messageCode = Enum.valueOf(this.messageCodeClass, key);
        return ((MessageResource)messageCode).getMessagePattern();
    }
}

