/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Transient;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.util.AssertionUtil;

public class EntityPropertyNameCollector {
    private final Context ctx;

    public EntityPropertyNameCollector(Context ctx) {
        AssertionUtil.assertNotNull(ctx);
        this.ctx = ctx;
    }

    public Set<String> collect(TypeMirror entityType) {
        HashSet<String> names = new HashSet<String>();
        this.collectNames(entityType, names);
        return names;
    }

    private void collectNames(TypeMirror type, Set<String> names) {
        TypeElement t = this.ctx.getMoreTypes().toTypeElement(type);
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            for (VariableElement field : ElementFilter.fieldsIn(t.getEnclosedElements())) {
                if (!this.isPersistent(field)) continue;
                names.add(field.getSimpleName().toString());
            }
            t = this.ctx.getMoreTypes().toTypeElement(t.getSuperclass());
        }
    }

    private boolean isPersistent(VariableElement field) {
        return field.getAnnotation(Transient.class) == null && !field.getModifiers().contains((Object)Modifier.STATIC);
    }
}

