/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class TableGeneratorAnnot
extends AbstractAnnot {
    private static final String CATALOG = "catalog";
    private static final String SCHEMA = "schema";
    private static final String TABLE = "table";
    private static final String PK_COLUMN_NAME = "pkColumnName";
    private static final String VALUE_COLUMN_NAME = "valueColumnName";
    private static final String PK_COLUMN_VALUE = "pkColumnValue";
    private static final String INITIAL_VALUE = "initialValue";
    private static final String ALLOCATION_SIZE = "allocationSize";
    private static final String IMPLEMENTER = "implementer";
    private final AnnotationValue catalog;
    private final AnnotationValue schema;
    private final AnnotationValue table;
    private final AnnotationValue pkColumnName;
    private final AnnotationValue valueColumnName;
    private final AnnotationValue pkColumnValue;
    private final AnnotationValue initialValue;
    private final AnnotationValue allocationSize;
    private final AnnotationValue implementer;

    TableGeneratorAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.catalog = AssertionUtil.assertNonNullValue(values, CATALOG);
        this.schema = AssertionUtil.assertNonNullValue(values, SCHEMA);
        this.table = AssertionUtil.assertNonNullValue(values, TABLE);
        this.pkColumnName = AssertionUtil.assertNonNullValue(values, PK_COLUMN_NAME);
        this.valueColumnName = AssertionUtil.assertNonNullValue(values, VALUE_COLUMN_NAME);
        this.pkColumnValue = AssertionUtil.assertNonNullValue(values, PK_COLUMN_VALUE);
        this.initialValue = AssertionUtil.assertNonNullValue(values, INITIAL_VALUE);
        this.allocationSize = AssertionUtil.assertNonNullValue(values, ALLOCATION_SIZE);
        this.implementer = AssertionUtil.assertNonNullValue(values, IMPLEMENTER);
    }

    public AnnotationValue getCatalog() {
        return this.catalog;
    }

    public AnnotationValue getSchema() {
        return this.schema;
    }

    public AnnotationValue getTable() {
        return this.table;
    }

    public AnnotationValue getPkColumnName() {
        return this.pkColumnName;
    }

    public AnnotationValue getValueColumnName() {
        return this.valueColumnName;
    }

    public AnnotationValue getPkColumnValue() {
        return this.pkColumnValue;
    }

    public AnnotationValue getInitialValue() {
        return this.initialValue;
    }

    public AnnotationValue getAllocationSize() {
        return this.allocationSize;
    }

    public AnnotationValue getImplementer() {
        return this.implementer;
    }

    public String getCatalogValue() {
        String value = AnnotationValueUtil.toString(this.catalog);
        if (value == null) {
            throw new AptIllegalStateException(CATALOG);
        }
        return value;
    }

    public String getSchemaValue() {
        String value = AnnotationValueUtil.toString(this.schema);
        if (value == null) {
            throw new AptIllegalStateException(SCHEMA);
        }
        return value;
    }

    public String getTableValue() {
        String value = AnnotationValueUtil.toString(this.table);
        if (value == null) {
            throw new AptIllegalStateException(TABLE);
        }
        return value;
    }

    public String getPkColumnNameValue() {
        String value = AnnotationValueUtil.toString(this.pkColumnName);
        if (value == null) {
            throw new AptIllegalStateException(PK_COLUMN_NAME);
        }
        return value;
    }

    public String getValueColumnNameValue() {
        String value = AnnotationValueUtil.toString(this.valueColumnName);
        if (value == null) {
            throw new AptIllegalStateException(VALUE_COLUMN_NAME);
        }
        return value;
    }

    public String getPkColumnValueValue() {
        String value = AnnotationValueUtil.toString(this.pkColumnValue);
        if (value == null) {
            throw new AptIllegalStateException(PK_COLUMN_VALUE);
        }
        return value;
    }

    public Long getInitialValueValue() {
        Long value = AnnotationValueUtil.toLong(this.initialValue);
        if (value == null) {
            throw new AptIllegalStateException(INITIAL_VALUE);
        }
        return value;
    }

    public Long getAllocationSizeValue() {
        Long value = AnnotationValueUtil.toLong(this.allocationSize);
        if (value == null) {
            throw new AptIllegalStateException(ALLOCATION_SIZE);
        }
        return value;
    }

    public TypeMirror getImplementerValue() {
        TypeMirror value = AnnotationValueUtil.toType(this.implementer);
        if (value == null) {
            throw new AptIllegalStateException(IMPLEMENTER);
        }
        return value;
    }
}

