/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.modeljs.v2.temp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.vecmath.Vector3d;
import jp.kitec.modeljs.v2.FaceA;
import jp.kitec.modeljs.v2.LineA;
import jp.kitec.modeljs.v2.ShapeA;
import jp.kitec.modeljs.v2.temp.FaceB;
import jp.kitec.modeljs.v2.temp.LineB;
import jp.kitec.modeljs.v2.temp.ShapeB;

public class ShapeUtil {
    public static ShapeB convert(ShapeA shape) {
        ShapeB s = new ShapeB();
        s.name = shape.name;
        s.type = shape.type;
        s.uuid = shape.uuid;
        ArrayList<Integer> keys = new ArrayList<Integer>();
        keys.addAll(shape.vertices.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            Vector3d v = shape.vertices.get(key);
            s.vertices.add(new Vector3d(v));
        }
        HashMap<FaceA, FaceB> faceMap = new HashMap<FaceA, FaceB>();
        for (FaceA face : shape.faces.values()) {
            FaceB f = new FaceB();
            for (Integer key : face.vertices) {
                f.vertices.add(shape.vertices.get(key));
            }
            s.faces.add(f);
            faceMap.put(face, f);
        }
        for (LineA line : shape.lines) {
            LineB l = new LineB();
            l.v1 = shape.vertices.get(line.v1);
            l.v2 = shape.vertices.get(line.v2);
            l.f1 = (FaceB)faceMap.get(shape.faces.get(line.f1));
            l.f2 = (FaceB)faceMap.get(shape.faces.get(line.f2));
            s.lines.add(l);
        }
        return s;
    }

    public static ShapeA toA(ShapeB shape) {
        ShapeA s = new ShapeA();
        s.name = shape.name;
        s.type = shape.type;
        s.uuid = shape.uuid;
        HashSet<Vector3d> used = new HashSet<Vector3d>();
        for (FaceB face : shape.faces) {
            used.addAll(face.vertices);
        }
        ArrayList<Vector3d> delete = new ArrayList<Vector3d>();
        for (Vector3d v : shape.vertices) {
            if (used.contains(v)) continue;
            delete.add(v);
        }
        shape.vertices.removeAll(delete);
        s.vertices = new HashMap<Integer, Vector3d>();
        s.faces = new HashMap<Integer, FaceA>();
        int i = 0;
        while (i < shape.vertices.size()) {
            Vector3d v = shape.vertices.get(i);
            s.vertices.put(i, v);
            ++i;
        }
        i = 0;
        while (i < shape.faces.size()) {
            FaceB face = shape.faces.get(i);
            FaceA f = new FaceA();
            f.vertices = new ArrayList<Integer>();
            for (Vector3d v : face.vertices) {
                f.vertices.add(shape.vertices.indexOf(v));
            }
            s.faces.put(i, f);
            ++i;
        }
        s.lines = new ArrayList<LineA>();
        i = 0;
        while (i < shape.lines.size()) {
            LineB line = shape.lines.get(i);
            LineA l = new LineA();
            l.v1 = shape.vertices.indexOf(line.v1);
            l.v2 = shape.vertices.indexOf(line.v2);
            s.lines.add(l);
            ++i;
        }
        return s;
    }
}

