/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.modeljs.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.kitec.modeljs.GeometryData;
import jp.kitec.modeljs.processor.Clipping;
import jp.kitec.modeljs.processor.Processor;
import jp.kitec.modeljs.util.CGeometry;
import jp.kitec.modeljs.util.Face;
import jp.kitec.modeljs.util.GeomUtil;

public class ClipProcessor
extends Processor<Clipping> {
    @Override
    public GeometryData process(GeometryData gd, Clipping deform) {
        if (gd.index.array.length == 0) {
            return this.processLine(gd, deform);
        }
        CGeometry cg = GeomUtil.toCGeom(gd);
        HashMap<Vector3d, Double> paramMap = new HashMap<Vector3d, Double>();
        for (Vector3d v : cg.vertices) {
            double dot = deform.n.dot(v);
            paramMap.put(v, dot);
        }
        ArrayList<Face> deleteList = new ArrayList<Face>();
        ArrayList<Face> addedFaceList = new ArrayList<Face>();
        ArrayList<Vector3d> addedVerticesList = new ArrayList<Vector3d>();
        ArrayList<Vector3d> addedSectionVerticesList = new ArrayList<Vector3d>();
        for (Face f : cg.faces) {
            ArrayList<Double> paramList = new ArrayList<Double>();
            ArrayList<Boolean> outFlagList = new ArrayList<Boolean>();
            boolean and = true;
            boolean or = false;
            for (Vector3d v : f.vertices) {
                double param = (Double)paramMap.get(v);
                boolean outFlag = deform.max < param;
                or |= outFlag;
                and &= outFlag;
                paramList.add(param);
                outFlagList.add(outFlag);
            }
            if (and) {
                deleteList.add(f);
                continue;
            }
            if (!or) continue;
            deleteList.add(f);
            ArrayList<Vector3d> vlist = new ArrayList<Vector3d>();
            int i = 0;
            while (i < f.vertices.size()) {
                Vector3d v = f.vertices.get(i);
                double param = (Double)paramList.get(i);
                int nextIndex = i == f.vertices.size() - 1 ? 0 : i + 1;
                int prevIndex = i == 0 ? f.vertices.size() - 1 : i - 1;
                boolean outFlag = (Boolean)outFlagList.get(i);
                if (!outFlag) {
                    vlist.add(v);
                } else {
                    Vector3d newPoint;
                    Vector3d t;
                    Vector3d diff;
                    double ratio;
                    Vector3d vb;
                    Vector3d va;
                    if (!((Boolean)outFlagList.get(prevIndex)).booleanValue()) {
                        double paramPrev = (Double)paramList.get(prevIndex);
                        va = f.vertices.get(prevIndex);
                        vb = v;
                        ratio = (deform.max - paramPrev) / (param - paramPrev);
                        diff = new Vector3d();
                        diff.sub((Tuple3d)vb, (Tuple3d)va);
                        diff.scale(ratio);
                        t = new Vector3d();
                        t.add((Tuple3d)va, (Tuple3d)diff);
                        newPoint = this.addPoint(addedVerticesList, t);
                        vlist.add(newPoint);
                        this.addPoint(addedSectionVerticesList, newPoint);
                    }
                    if (!((Boolean)outFlagList.get(nextIndex)).booleanValue()) {
                        double paramNext = (Double)paramList.get(nextIndex);
                        va = f.vertices.get(nextIndex);
                        vb = v;
                        ratio = (deform.max - paramNext) / (param - paramNext);
                        diff = new Vector3d();
                        diff.sub((Tuple3d)vb, (Tuple3d)va);
                        diff.scale(ratio);
                        t = new Vector3d();
                        t.add((Tuple3d)va, (Tuple3d)diff);
                        newPoint = this.addPoint(addedVerticesList, t);
                        vlist.add(newPoint);
                        this.addPoint(addedSectionVerticesList, newPoint);
                    }
                }
                ++i;
            }
            int vsize = vlist.size();
            if (vsize == 3) {
                Face newFace = new Face();
                newFace.vertices.addAll(vlist);
                addedFaceList.add(newFace);
                continue;
            }
            if (vsize <= 3) continue;
            int i2 = 0;
            while (i2 < vsize - 2) {
                Face newFace = new Face();
                newFace.vertices.add((Vector3d)vlist.get(0));
                newFace.vertices.add((Vector3d)vlist.get(i2 + 1));
                newFace.vertices.add((Vector3d)vlist.get(i2 + 2));
                addedFaceList.add(newFace);
                ++i2;
            }
        }
        cg.faces.removeAll(deleteList);
        for (Vector3d v : paramMap.keySet()) {
            if (!((Double)paramMap.get(v) > deform.max)) continue;
            cg.vertices.remove(v);
        }
        cg.faces.addAll(addedFaceList);
        cg.vertices.addAll(addedVerticesList);
        GeometryData d = GeomUtil.toData(cg);
        return d;
    }

    private GeometryData processLine(GeometryData gd, Clipping deform) {
        CGeometry cg = GeomUtil.toCGeom(gd);
        HashMap<Vector3d, Double> paramMap = new HashMap<Vector3d, Double>();
        for (Vector3d v : cg.vertices) {
            double dot = deform.n.dot(v);
            paramMap.put(v, dot);
        }
        ArrayList<Vector3d> newList = new ArrayList<Vector3d>();
        int i = 0;
        while (i < cg.vertices.size() - 1) {
            Vector3d p = cg.vertices.get(i);
            Vector3d n = cg.vertices.get(i + 1);
            double param1 = (Double)paramMap.get(p);
            double param2 = (Double)paramMap.get(n);
            if (param1 <= deform.max) {
                newList.add(p);
            }
            if (param1 <= deform.max && deform.max < param2 || param2 <= deform.max && deform.max < param1) {
                double ratio = (deform.max - param1) / (param2 - param1);
                Vector3d diff = new Vector3d();
                diff.sub((Tuple3d)n, (Tuple3d)p);
                diff.scale(ratio);
                Vector3d t = new Vector3d();
                t.add((Tuple3d)p, (Tuple3d)diff);
                this.addPoint(newList, t);
            }
            if (i == cg.vertices.size() - 2 && param2 <= deform.max) {
                newList.add(n);
            }
            ++i;
        }
        cg.vertices.clear();
        cg.vertices.addAll(newList);
        GeometryData d = GeomUtil.toData(cg);
        return d;
    }

    private Vector3d addPoint(List<Vector3d> list, Vector3d v) {
        for (Vector3d o : list) {
            if (!o.epsilonEquals((Tuple3d)v, 1.0E-6)) continue;
            return o;
        }
        list.add(v);
        return v;
    }
}

