/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.model.converter;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.kitec.model.converter.ToolTesseTryangle;
import jp.kitec.modeljs.Geometry;
import jp.kitec.modeljs.GeometryData;
import jp.kitec.modeljs.Image;
import jp.kitec.modeljs.Material;
import jp.kitec.modeljs.Mesh;
import jp.kitec.modeljs.Object3D;
import jp.kitec.modeljs.SceneData;
import jp.kitec.modeljs.Texture;
import jp.kitec.modeljs.types.SideType;
import model.primitive.LsShape;
import model.primitive.LsSurface;
import model.shape.primitive.SMatrix4d;
import model.shape.primitive.SVector3d;
import model.util.PrimitiveGenerator;
import org.apache.commons.lang3.ArrayUtils;

public class ThreeJsGenerator
implements PrimitiveGenerator {
    public static final int[] REPEAT_WRAPPING = new int[]{1000, 1000};
    public double scale = 1.0;
    protected double EPS = 0.001f;
    protected SceneData sceneData;
    protected Object3D rootObject;
    protected Map<Object, Image> imageCache = new HashMap<Object, Image>();

    public ThreeJsGenerator(SceneData sceneData, Object3D rootObject) {
        this.sceneData = sceneData;
        this.rootObject = rootObject;
    }

    public void addSweep(double[][] points, double[] dir, boolean drawTop, boolean drawBot, boolean drawAllEdge, boolean addAllSide, boolean[] drawEdge, boolean[] addSide, boolean[] drawSideEdge, Color color, Color edgeColor, int object_id, int group_object, int group_color, SMatrix4d m) {
        int pointsNum = points.length;
        int length_1 = pointsNum - 1;
        Object _points = points;
        double[] _dir = dir;
        if (m != null) {
            _points = new double[pointsNum][];
            int i = 0;
            while (i < pointsNum) {
                _points[i] = this.translate(m, points[i][0], points[i][1], points[i][2]);
                ++i;
            }
            double[] v0 = this.translate(m, 0.0, 0.0, 0.0);
            double[] v = this.translate(m, dir[0], dir[1], dir[2]);
            _dir = new double[]{(float)(v[0] - v0[0]), (float)(v[1] - v0[1]), (float)(v[2] - v0[2])};
        }
        Object[] reverse = this.createReverse((double[][])_points);
        Object[] ofs = this.createOffset((double[][])_points, _dir);
        Point3d[] allVs = (Point3d[])ArrayUtils.addAll((Object[])reverse, (Object[])ofs);
        int[] pids = new int[pointsNum];
        int[] rids = new int[pointsNum];
        int[] oids = new int[pointsNum];
        float[] vs = new float[pointsNum * 6];
        int l3 = pointsNum * 3;
        int i = 0;
        while (i < pointsNum) {
            int i3 = i * 3;
            int i3l3 = i3 + l3;
            pids[i] = length_1 - i;
            rids[i] = i;
            oids[i] = pointsNum + i;
            vs[i3] = (float)((Point3d)reverse[i]).x;
            vs[i3 + 1] = (float)((Point3d)reverse[i]).y;
            vs[i3 + 2] = (float)((Point3d)reverse[i]).z;
            vs[i3l3] = (float)((Point3d)ofs[i]).x;
            vs[i3l3 + 1] = (float)((Point3d)ofs[i]).y;
            vs[i3l3 + 2] = (float)((Point3d)ofs[i]).z;
            ++i;
        }
        int topFaceSize = this.countIndexNum(pointsNum);
        int fsize = 0;
        if (drawTop) {
            fsize += topFaceSize;
        }
        if (drawBot) {
            fsize += topFaceSize;
        }
        if (addAllSide || addSide == null) {
            fsize += 6 * pointsNum;
        } else {
            int k = 0;
            while (k < pointsNum) {
                if (addSide[k]) {
                    fsize += 6;
                }
                ++k;
            }
        }
        int[] faceIndices = new int[fsize];
        Vector3d normal = new Vector3d(_dir);
        normal.normalize();
        int seq = 0;
        if (drawTop) {
            Vector3d dirV = new Vector3d(-normal.x, -normal.y, -normal.z);
            seq = this.createSurface(faceIndices, rids, seq, allVs, dirV);
        }
        if (drawBot) {
            seq = this.createSurface(faceIndices, oids, seq, allVs, normal);
        }
        int k = 0;
        while (k < pointsNum) {
            if (addAllSide || addSide == null || addSide[k]) {
                int next = k == length_1 ? 0 : k + 1;
                seq = this.createConvexSurface(faceIndices, new int[]{pids[next], oids[next], oids[k], pids[k]}, seq);
            }
            ++k;
        }
        Geometry geom = this.createGeometry(vs, ArrayUtils.subarray((int[])faceIndices, (int)0, (int)seq));
        Material mat = this.createMaterial(color.getRGB(), (float)color.getAlpha() / 255.0f);
        this.addMesh(geom, mat, null);
    }

    protected double[] translate(SMatrix4d m, double x, double y, double z) {
        SVector3d v = new SVector3d();
        m.translate(v, x, y, z);
        return new double[]{v.x, v.y, v.z};
    }

    public void addSweep(double[][] points, double[] dir, boolean dispEdge, Color color, Color edgeColor, int gid1, int gid2, SMatrix4d m) {
    }

    public void addCylinder(double[] c, double r, double[] dir, boolean dispTop, boolean dispBot, boolean dispEdge, Color color, Color edgeColor, int object_id, int gid1, int gid2, SMatrix4d m) {
        this.addCylinder(c, r, dir, dispTop, dispBot, dispEdge, color, edgeColor, object_id, gid1, gid2, m, 12);
    }

    public void addCylinder(double[] c, double r, double[] dir, boolean dispTop, boolean dispBot, boolean dispEdge, Color color, Color edgeColor, int object_id, int gid1, int gid2, SMatrix4d m, int divide) {
    }

    public void addImagePlane(double[][] points, double[] u, double[] v, double[] o, Object obji, Object alphaobj, boolean isCacheable, double dpu, double dpv, int alpha, boolean dispEdge, Color edgeColor, int gid1, SMatrix4d m) {
        if (obji == null || !(obji instanceof BufferedImage)) {
            return;
        }
        BufferedImage bImage = (BufferedImage)obji;
        Object _points = points;
        double[] _u = u;
        double[] _o = o;
        int pointsNum = points.length;
        if (m != null) {
            _points = new double[pointsNum][];
            int i = 0;
            while (i < pointsNum) {
                _points[i] = this.translate(m, points[i][0], points[i][1], points[i][2]);
                ++i;
            }
            _o = this.translate(m, u[0], u[1], u[2]);
            _u = this.translate(m, o[0], o[1], o[2]);
        }
        Vector3d normal = this.calcNormal((double[][])_points);
        Vector3d ou = new Vector3d(_u[0] - _o[0], _u[1] - _o[1], _u[2] - _o[2]);
        ou.normalize();
        Vector3d ov = new Vector3d();
        ov.cross(ou, normal);
        ou.scale(dpu);
        ov.scale(dpv);
        float[] vs = new float[pointsNum * 3];
        float[][] uvs = new float[pointsNum][2];
        int[] ids = new int[pointsNum];
        int i = 0;
        while (i < pointsNum) {
            double[] _p = _points[i];
            vs[i * 3] = (float)_p[0];
            vs[i * 3 + 1] = (float)_p[1];
            vs[i * 3 + 2] = (float)_p[2];
            Vector3d op = new Vector3d(_p[0] - _o[0], _p[1] - _o[1], _p[2] - _o[2]);
            uvs[i][0] = (float)op.dot(ou);
            uvs[i][1] = (float)op.dot(ov);
            ids[i] = i;
            ++i;
        }
        int[] faceIndices = new int[this.countIndexNum(pointsNum)];
        this.createConvexSurface(faceIndices, ids, 0);
        float[] indexUvs = new float[faceIndices.length * 2];
        int i2 = 0;
        while (i2 < faceIndices.length) {
            float[] uv = uvs[faceIndices[i2]];
            indexUvs[i2 * 2] = uv[0];
            indexUvs[i2 * 2 + 1] = uv[1];
            ++i2;
        }
        Geometry geom = this.createGeometry(vs, faceIndices);
        geom.data.attributes.uv = new GeometryData.BufferFloatAttribute(2);
        geom.data.attributes.uv.array = indexUvs;
        Image image = this.getImage(bImage, isCacheable);
        Texture texture = this.createTexture(image);
        Material mat = this.createMaterial(null, (float)alpha / 255.0f);
        mat.map = texture.uuid;
        this.addMesh(geom, mat, -1);
        this.sceneData.images.add(image);
        this.sceneData.textures.add(texture);
    }

    public void addImagePlane_back(double[][] points, double[] u, double[] v, double[] o, Object obji, Object alphaobj, double dpu, double dpv, int alpha, boolean dispEdge, Color edgeColor, int gid1, SMatrix4d m) {
        if (obji == null) {
            return;
        }
        BufferedImage bImage = null;
        if (obji instanceof BufferedImage) {
            bImage = (BufferedImage)obji;
        }
        if (bImage == null) {
            return;
        }
        Object _points = points;
        double[] _u = u;
        double[] _o = o;
        int pointsNum = points.length;
        if (m != null) {
            _points = new double[pointsNum][];
            int i = 0;
            while (i < pointsNum) {
                _points[i] = this.translate(m, points[i][0], points[i][1], points[i][2]);
                ++i;
            }
            _o = this.translate(m, u[0], u[1], u[2]);
            _u = this.translate(m, o[0], o[1], o[2]);
        }
        Vector3d normal = this.calcNormal((double[][])_points);
        Vector3d ou = new Vector3d(_u[0] - _o[0], _u[1] - _o[1], _u[2] - _o[2]);
        ou.normalize();
        Vector3d ov = new Vector3d();
        ov.cross(ou, normal);
        ou.scale(1.0 / (double)bImage.getWidth());
        ov.scale(1.0 / (double)bImage.getHeight());
        float[] vs = new float[pointsNum * 3];
        float[][] uvs = new float[pointsNum][2];
        int[] ids = new int[pointsNum];
        int i = 0;
        while (i < pointsNum) {
            double[] p = _points[i];
            vs[i * 3] = (float)p[0];
            vs[i * 3 + 1] = (float)p[1];
            vs[i * 3 + 2] = (float)p[2];
            Vector3d op = new Vector3d(p[0] - _o[0], p[1] - _o[1], p[2] - _o[2]);
            uvs[i][0] = (float)op.dot(ou);
            uvs[i][1] = (float)op.dot(ov);
            ids[i] = i;
            ++i;
        }
        int[] faceIndices = new int[this.countIndexNum(pointsNum)];
        this.createConvexSurface(faceIndices, ids, 0);
        float[] indexUvs = new float[faceIndices.length * 2];
        int i2 = 0;
        while (i2 < faceIndices.length) {
            float[] uv = uvs[faceIndices[i2]];
            indexUvs[i2 * 2] = uv[0];
            indexUvs[i2 * 2 + 1] = uv[1];
            ++i2;
        }
        Geometry geom = this.createGeometry(vs, faceIndices);
        geom.data.attributes.uv = new GeometryData.BufferFloatAttribute(2);
        geom.data.attributes.uv.array = indexUvs;
        Image image = this.getImage(bImage, true);
        Texture texture = this.createTexture(image);
        Material mat = this.createMaterial(null, (float)alpha / 255.0f);
        mat.map = texture.uuid;
        this.addMesh(geom, mat, -1);
        this.sceneData.images.add(image);
        this.sceneData.textures.add(texture);
    }

    public void addSphere(double[] c, double r, Color color, int gid1, int gid2, SMatrix4d m) {
    }

    public void addPlane(double[][] points, boolean both, boolean dispEdge, Color color, Color edgeColor, int gid1, int gid2, SMatrix4d m) {
    }

    public void addCone(double[] c, double r, double[] dir, boolean dispBottom, boolean cutShape, double cutHeight, boolean dispCutSurface, boolean dispEdge, boolean drawBothSide, Color color, Color edgeColor, int object_id, int gid1, int gid2, SMatrix4d m) {
        this.addCone(c, r, dir, dispBottom, cutShape, cutHeight, dispCutSurface, dispEdge, drawBothSide, color, edgeColor, object_id, gid1, gid2, m, 12);
    }

    public void addCone(double[] c, double r, double[] dir, boolean dispBottom, boolean cutShape, double cutHeight, boolean dispCutSurface, boolean dispEdge, boolean drawBothSide, Color color, Color edgeColor, int object_id, int gid1, int gid2, SMatrix4d m, int divide) {
    }

    public void addTorus(double[] center, double[] normal, double radiusMajor, double radiusMinor, double radStart, double radExtent, double[] u, double[] v, boolean dispEdge, boolean drawStart, boolean drawEnd, Color color, Color edgeColor, int object_id, int gid1, int gid2, SMatrix4d m, int divide) {
    }

    public void addShape(LsShape shape) {
        if (shape == null) {
            return;
        }
        this.preProcessShape(shape);
        Color fill = shape.fillColor;
        if (fill == null) {
            fill = Color.white;
        }
        SVector3d w = new SVector3d();
        List allVectors = shape.getVertices();
        float[] vs = new float[allVectors.size() * 3];
        Point3d[] allVertices = new Point3d[allVectors.size()];
        int i = 0;
        while (i < allVectors.size()) {
            SVector3d v = (SVector3d)allVectors.get(i);
            if (shape.tempMatrix != null) {
                shape.tempMatrix.translate(w, v.x, v.y, v.z);
            } else {
                w.set(v);
            }
            allVertices[i] = new Point3d(w.x, w.y, w.z);
            vs[i * 3] = (float)w.x;
            vs[i * 3 + 1] = (float)w.y;
            vs[i * 3 + 2] = (float)w.z;
            ++i;
        }
        int faceslength = 0;
        for (LsSurface surface : shape.getSurfaces()) {
            faceslength += this.countIndexNum(surface.getVertices().size());
        }
        int[] faceIndices = new int[faceslength];
        int seq = 0;
        for (LsSurface surface : shape.getSurfaces()) {
            List vectors = surface.getVertices();
            List edges = surface.getEdges();
            int[] ids = new int[vectors.size()];
            int i2 = 0;
            while (i2 < edges.size()) {
                SVector3d v = (SVector3d)vectors.get(i2);
                ids[i2] = allVectors.indexOf(v);
                ++i2;
            }
            seq = this.createSurface(faceIndices, ids, seq, allVertices, null);
        }
        Geometry geom = this.createGeometry(vs, ArrayUtils.subarray((int[])faceIndices, (int)0, (int)seq));
        Material mat = this.createMaterial(fill.getRGB(), (float)fill.getAlpha() / 255.0f);
        if (shape.drawBothSide) {
            mat.side = SideType.DoubleSide;
        }
        this.addMesh(geom, mat, null);
    }

    private void preProcessShape(LsShape shape) {
        Vector3d w1 = new Vector3d();
        Vector3d w2 = new Vector3d();
        ArrayList<LsSurface> removeList = new ArrayList<LsSurface>();
        for (LsSurface f : shape.getSurfaces()) {
            List vertices = f.getVertices();
            SVector3d first = (SVector3d)vertices.get(0);
            w1.set(first.x, first.y, first.z);
            boolean zero = true;
            int i = 1;
            while (i < vertices.size()) {
                SVector3d o = (SVector3d)vertices.get(i);
                w2.set(o.x, o.y, o.z);
                if (!w1.epsilonEquals((Tuple3d)w2, 1.0E-7)) {
                    zero = false;
                    break;
                }
                ++i;
            }
            if (!zero) continue;
            removeList.add(f);
        }
        shape.getSurfaces().removeAll(removeList);
    }

    protected Point3d[] createReverse(double[][] a) {
        Point3d[] res = new Point3d[a.length];
        int i = 0;
        while (i < res.length) {
            double[] d = a[a.length - 1 - i];
            res[i] = new Point3d(d[0], d[1], d[2]);
            ++i;
        }
        return res;
    }

    protected boolean[] createReverse(boolean[] edge) {
        boolean[] res = new boolean[edge.length];
        int i = 0;
        while (i < edge.length) {
            res[edge.length - 1 - i] = edge[(edge.length + i - 1) % edge.length];
            ++i;
        }
        return res;
    }

    protected Point3d[] createOffset(double[][] points, double[] dir) {
        Point3d[] res = new Point3d[points.length];
        int i = 0;
        while (i < res.length) {
            double[] p = points[i];
            res[i] = new Point3d(p[0] + dir[0], p[1] + dir[1], p[2] + dir[2]);
            ++i;
        }
        return res;
    }

    protected int countIndexNum(int verticesNum) {
        return (verticesNum - 2) * 3;
    }

    protected int createSurface(int[] array, int[] ids, int seq, Point3d[] allVertices, Vector3d normal) {
        block7: {
            short[] indeces;
            Point3d firstV;
            int size;
            block6: {
                size = ids.length;
                if (size != 3) break block6;
                int i = 0;
                while (i < size) {
                    array[seq++] = ids[i];
                    ++i;
                }
                break block7;
            }
            if (size <= 3) break block7;
            int[] trimedIds = new int[ids.length];
            Point3d prevV = firstV = allVertices[ids[0]];
            trimedIds[0] = ids[0];
            int count = 1;
            int i = 1;
            while (i < ids.length) {
                Point3d v = allVertices[ids[i]];
                if (!prevV.epsilonEquals((Tuple3d)v, this.EPS)) {
                    prevV = v;
                    trimedIds[count++] = ids[i];
                }
                ++i;
            }
            if (prevV.epsilonEquals((Tuple3d)firstV, this.EPS)) {
                --count;
            }
            Point3d[] vertices = new Point3d[count];
            int i2 = 0;
            while (i2 < count) {
                vertices[i2] = allVertices[trimedIds[i2]];
                ++i2;
            }
            short[] sArray = indeces = new ToolTesseTryangle().culcTryangles(vertices, normal);
            int n = indeces.length;
            int n2 = 0;
            while (n2 < n) {
                short i3 = sArray[n2];
                array[seq++] = trimedIds[i3];
                ++n2;
            }
        }
        return seq;
    }

    protected int createConvexSurface(int[] array, int[] ids, int seq) {
        int size = ids.length;
        int i = 2;
        while (i < size) {
            array[seq++] = ids[0];
            array[seq++] = ids[i - 1];
            array[seq++] = ids[i];
            ++i;
        }
        return seq;
    }

    protected String toDataUrl(BufferedImage image) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(bos);
        try {
            ImageIO.write((RenderedImage)image, "png", os);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byteData = bos.toByteArray();
        String base64str = Base64.getEncoder().encodeToString(byteData);
        return "data:image/png;base64," + base64str;
    }

    protected Vector3d calcNormal(double[][] vertices) {
        int vNum = vertices.length;
        double[] p0 = vertices[0];
        double[] p1 = vertices[vNum - 1];
        Vector3d v10 = new Vector3d(p0[0] - p1[0], p0[1] - p1[1], p0[2] - p1[2]);
        Vector3d normal = new Vector3d();
        Vector3d zeroV = new Vector3d(0.0, 0.0, 0.0);
        int i = 1;
        while (i < vNum) {
            double[] p2 = vertices[i];
            Vector3d v02 = new Vector3d(p2[0] - p0[0], p2[1] - p0[1], p2[2] - p0[2]);
            normal.cross(v10, v02);
            if (!normal.epsilonEquals((Tuple3d)zeroV, this.EPS)) {
                normal.normalize();
                return normal;
            }
            p1 = p0;
            p0 = p2;
            v10 = v02;
            ++i;
        }
        return null;
    }

    protected Geometry createGeometry(float[] position, int[] index) {
        float[] scaledPosition;
        if (Double.compare(this.scale, 1.0) == 0) {
            scaledPosition = position;
        } else {
            scaledPosition = new float[position.length];
            int i = 0;
            while (i < position.length) {
                scaledPosition[i] = (float)((double)position[i] * this.scale);
                ++i;
            }
        }
        GeometryData data = new GeometryData();
        data.index.array = index;
        data.attributes.position.array = scaledPosition;
        Geometry g = new Geometry();
        g.uuid = this.createUuid();
        g.data = data;
        return g;
    }

    protected Material createMaterial(Integer color, float opacity) {
        Material m = new Material();
        m.uuid = this.createUuid();
        m.color = color == null ? null : Integer.valueOf(color & 0xFFFFFF);
        m.opacity = Float.valueOf(opacity);
        m.transparent = opacity < 1.0f;
        return m;
    }

    protected Mesh createMesh(Geometry geom, Material mat) {
        Mesh m = new Mesh();
        m.uuid = this.createUuid();
        m.geometry = geom.uuid;
        m.material = mat.uuid;
        return m;
    }

    protected Texture createTexture(Image image) {
        Texture t = new Texture();
        t.uuid = this.createUuid();
        t.image = image.uuid;
        t.wrap = REPEAT_WRAPPING;
        t.repeat = new float[]{1.0f, 1.0f};
        return t;
    }

    protected Image createImage(String url) {
        Image i = new Image();
        i.uuid = this.createUuid();
        i.url = url;
        return i;
    }

    protected Image getImage(BufferedImage bimg, boolean isCacheable) {
        if (this.imageCache.containsKey(bimg)) {
            return this.imageCache.get(bimg);
        }
        String dataUrl = this.toDataUrl(bimg);
        Image img = this.createImage(dataUrl);
        if (isCacheable) {
            this.imageCache.put(bimg, img);
        }
        return img;
    }

    protected void addMesh(Geometry geom, Material mat, Integer renderOrder) {
        Mesh mesh = this.createMesh(geom, mat);
        mesh.renderOrder = renderOrder;
        this.sceneData.geometries.add(geom);
        this.sceneData.materials.add(mat);
        this.rootObject.addChild((Object3D)mesh);
    }

    protected String createUuid() {
        return UUID.randomUUID().toString();
    }
}

