/*
 * Decompiled with CFR 0.152.
 */
package com.kt.db;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public class KResultSet
implements ResultSet {
    private int maxRows = 0;
    private Vector listeners = new Vector();
    private Object[] param_obj_array = null;
    private int[] param_type_array = null;
    private ArrayList rows = null;
    private int index = 0;
    private boolean last_null = false;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int fetchDirection = 1002;
    private int fetchSize = 0;
    private ResultSetMetaData rs_meta = null;
    private Hashtable columnName = null;
    private Hashtable columnFullName = null;

    public void buildResultSet(ResultSet resultSet) throws SQLException {
        Object object;
        Object object2;
        int n;
        this.resultSetType = resultSet.getType();
        this.resultSetConcurrency = resultSet.getConcurrency();
        this.rs_meta = resultSet.getMetaData();
        int n2 = this.rs_meta.getColumnCount();
        this.columnName = new Hashtable();
        this.columnFullName = new Hashtable();
        for (n = 1; n <= n2; ++n) {
            object2 = this.rs_meta.getColumnName(n);
            String string = this.rs_meta.getTableName(n) + "." + (String)object2;
            object = new Integer(n - 1);
            this.columnName.put(object2, object);
            this.columnFullName.put(string, object);
        }
        n = 0;
        this.rows = new ArrayList();
        while (resultSet.next()) {
            object2 = new ArrayList(n2);
            for (int i = 1; i <= n2; ++i) {
                object = resultSet.getObject(i);
                if (resultSet.wasNull()) {
                    object = null;
                }
                ((ArrayList)object2).add(object);
            }
            this.rows.add(object2);
            if (this.maxRows == 0 || ++n < this.maxRows) continue;
            break;
        }
        resultSet.close();
    }

    public void clearParameters() throws SQLException {
        if (this.param_obj_array != null && this.param_type_array != null) {
            int n;
            for (n = 0; n < this.param_obj_array.length; ++n) {
                this.param_obj_array[n] = null;
            }
            for (n = 0; n < this.param_type_array.length; ++n) {
                this.param_type_array[n] = 0;
            }
        } else {
            throw new SQLException("mysql error : clearParameters(), no parameter.");
        }
    }

    public boolean next() throws SQLException {
        int n = this.rows.size();
        if (this.index + 1 <= n) {
            ++this.index;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        this.rows = null;
    }

    public boolean wasNull() throws SQLException {
        return this.last_null;
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        return object != null ? object.toString() : null;
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Boolean.valueOf(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public byte getByte(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Byte.valueOf(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public short getShort(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Short.valueOf(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getInt(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Long.valueOf(string);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return (BigDecimal)this.getObject(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.getObject(n);
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getObject(n);
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getObject(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getObject(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.getObject(n);
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.getObject(n);
        return null;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs_meta;
    }

    public Object getObject(int n) throws SQLException {
        try {
            ArrayList arrayList = (ArrayList)this.rows.get(this.index - 1);
            Object e = arrayList.get(n - 1);
            this.last_null = e == null;
            return e;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        try {
            Integer n = (Integer)this.columnName.get(string);
            if (n == null) {
                n = (Integer)this.columnFullName.get(string);
            }
            if (n != null) {
                return n + 1;
            }
            throw new SQLException("Invalid column name : " + string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return null;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 10);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        int n = this.rows.size();
        return n > 0 && this.index == 0;
    }

    public boolean isAfterLast() throws SQLException {
        int n = this.rows.size();
        return n > 0 && this.index == n + 1;
    }

    public boolean isFirst() throws SQLException {
        int n = this.rows.size();
        return n > 0 && this.index == 1;
    }

    public boolean isLast() throws SQLException {
        int n = this.rows.size();
        return n > 0 && this.index == n;
    }

    public void beforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n = this.rows.size();
        if (n > 0) {
            this.index = 0;
            this.notifyCursorMoved();
        }
    }

    public void afterLast() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n = this.rows.size();
        if (n > 0) {
            this.index = n + 1;
            this.notifyCursorMoved();
        }
    }

    public boolean first() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n = this.rows.size();
        if (n > 0) {
            this.index = 1;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean last() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n = this.rows.size();
        if (n > 0) {
            this.index = n;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public int getRow() throws SQLException {
        return this.index;
    }

    public boolean absolute(int n) throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        if (n == 0) {
            return false;
        }
        int n2 = this.rows.size();
        if (n < 0) {
            n = n2 + 1 + n;
        }
        this.index = n;
        if (this.index >= 1 && this.index <= n2) {
            this.notifyCursorMoved();
            return true;
        }
        if (this.index <= 0) {
            this.beforeFirst();
        } else {
            this.afterLast();
        }
        return false;
    }

    public boolean relative(int n) throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n2 = this.rows.size();
        this.index += n;
        if (this.index >= 1 && this.index <= n2) {
            this.notifyCursorMoved();
            return true;
        }
        if (this.index <= 0) {
            this.beforeFirst();
        } else {
            this.afterLast();
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        if (this.index - 1 >= 1) {
            --this.index;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return this.resultSetType;
    }

    public int getConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("mysql does not support rowUpdated().");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("mysql does not support rowInserted().");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("mysql does not support rowDeleted().");
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException("mysql does not support updateNull(int).");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("mysql does not support updateBoolean(int, boolean).");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("mysql does not support updateByte(int, byte).");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("mysql does not support updateShort(int, short).");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateInt(int, int).");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("mysql does not support updateLong(int, long).");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("mysql does not support updateFloat(int, float).");
    }

    public void updateDouble(int n, double d2) throws SQLException {
        throw new SQLException("mysql does not support updateDouble(int, double).");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("mysql does not support updateBigDecimal(int, BigDecimal).");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("mysql does not support updateString(int, String).");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("mysql does not support updateBytes(int, byte[]).");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("mysql does not support updateDate(int, Date).");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("mysql does not support updateTime(int, Time).");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("mysql does not support updateTimestamp(int, Timestamp).");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateAsciiStream(int, InputStream, int).");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateBinaryStream(int, InputStream, int).");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateCharacterStream(int, Reader, int).");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateObject(int, Object, int).");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("mysql does not support updateObject(int, Object).");
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException("mysql does not support updateNull(String).");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("mysql does not support updateBoolean(String, boolean).");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("mysql does not support updateByte(String, byte).");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("mysql does not support updateShort(String, short).");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("mysql does not support updateInt(String, int).");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("mysql does not support updateLong(String, long).");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("mysql does not support updateFloat(String, float).");
    }

    public void updateDouble(String string, double d2) throws SQLException {
        throw new SQLException("mysql does not support updateDouble(String, double).");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("mysql does not support updateBigDecimal(String, BigDecimal).");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("mysql does not support updateString(String, String).");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("mysql does not support updateBytes(String, byte[]).");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("mysql does not support updateDate(String, Date).");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("mysql does not support updateTime(String, Time).");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("mysql does not support updateTimestamp(String, Timestamp).");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("mysql does not support updateAsciiStream(String, InputStream, int).");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("mysql does not support updateBinaryStream(String, InputStream, int).");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("mysql does not support updateCharacterStream(String, Reader, int).");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("mysql does not support updateObject(String, Object, int).");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("mysql does not support updateObject(String, Object).");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("mysql does not support updateRow().");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("mysql does not support updateRow().");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("mysql does not support deleteRow().");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("mysql does not support refreshRow().");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("mysql does not support cancelRowUpdates().");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("mysql does not support moveToInsertRow().");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("mysql does not support moveToCurrentRow().");
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("mysql does not support getObject(int, Map).");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("mysql does not support getRef(int).");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("mysql does not support getBlob(int).");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("mysql does not support getClob(int).");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("mysql does not support getArray(int).");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("mysql does not support getObject(String, Map).");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("mysql does not support getRef(String).");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("mysql does not support getBlob(String).");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("mysql does not support getClob(String).");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("mysql does not support getArray(String).");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("mysql does not support getURL(int).");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("mysql does not support getURL(String).");
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("mysql does not support updateRef(int, Ref).");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("mysql does not support updateRef(String, Ref).");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("mysql does not support updateBlob(int, Blob).");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("mysql does not support updateBlob(String, Blob).");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("mysql does not support updateClob(int, Blob).");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("mysql does not support updateClob(String, Blob).");
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("mysql does not support updateArray(int, Array).");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException("mysql does not support updateArray(String, Array).");
    }

    private void notifyCursorMoved() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).cursorMoved(rowSetEvent);
            }
        }
    }
}

