/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.util.Hashtable;
import option.io.pdfcommon.document.PdfDocument;
import option.io.pdfcommon.font.CIDSystemInfo;
import option.io.pdfcommon.font.CharProc;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfName;

public class Encoding
implements DefinedName {
    public static final PdfName NAME_83PV_RKSJ_H = new PdfName("83pv-RKSJ-H");
    public static final PdfName NAME_90MS_RKSJ_H = new PdfName("90ms-RKSJ-H");
    public static final PdfName NAME_90MS_RKSJ_V = new PdfName("90ms-RKSJ-V");
    public static final PdfName NAME_90MSP_RKSJ_H = new PdfName("90msp-RKSJ-H");
    public static final PdfName NAME_90MSP_RKSJ_V = new PdfName("90msp-RKSJ-V");
    public static final PdfName NAME_90PV_RKSJ_H = new PdfName("90pv-RKSJ-H");
    public static final PdfName NAME_ADD_RKSJ_H = new PdfName("Add-RKSJ-H");
    public static final PdfName NAME_ADD_RKSJ_V = new PdfName("Add-RKSJ-V");
    public static final PdfName NAME_EUC_H = new PdfName("EUC-H");
    public static final PdfName NAME_EUC_V = new PdfName("EUC-V");
    public static final PdfName NAME_EXT_RKSJ_H = new PdfName("Ext-RKSJ-H");
    public static final PdfName NAME_EXT_RKSJ_V = new PdfName("Ext-RKSJ-V");
    public static final PdfName NAME_H = new PdfName("H");
    public static final PdfName NAME_V = new PdfName("V");
    public static final PdfName NAME_IDENTITY_H = new PdfName("Identity-H");
    public static final PdfName NAME_IDENTITY_V = new PdfName("Identity-V");
    public static final PdfName NAME_UNIJIS_UCS2_H = new PdfName("UniJIS-UCS2-H");
    public static final PdfName NAME_UNIJIS_UCS2_V = new PdfName("UniJIS-UCS2-V");
    public static final PdfName NAME_UNIJIS_UCS2_HW_H = new PdfName("UniJIS-UCS2-HW-H");
    public static final PdfName NAME_UNIJIS_UCS2_HW_V = new PdfName("UniJIS-UCS2-HW-V");
    public static final CIDSystemInfo CIDINFO_0 = new CIDSystemInfo("Abode", "Identity", 0);
    public static final CIDSystemInfo CIDINFO_1 = new CIDSystemInfo("Abode", "Japan1", 1);
    public static final CIDSystemInfo CIDINFO_2 = new CIDSystemInfo("Abode", "Japan1", 2);
    public static final int ENCODING_NAME_TYPE = 1;
    public static final int ENCODING_DICTIONARY_TYPE = 2;
    protected int encoingDataType = 1;
    protected int encoding = 0;
    protected String encodingStr = null;
    protected CIDSystemInfo mCIDSystemInfo = null;
    protected PdfName encodingPdfName = null;
    protected PdfDictionary encodingDict;
    protected static final PdfName DIFFERENCES = new PdfName("Differences");
    protected static final PdfName ENCODING = new PdfName("Encoding");
    public static final String DEFAULT_ENCODING_STR = "MS932";
    protected CharProc[] charProcList = new CharProc[256];
    protected PdfDictionary charProcs = new PdfDictionary();
    protected int firstChar = this.charProcList.length - 1;
    protected int lastChar = 0;
    protected PdfDocument document;
    protected PdfArray widths = new PdfArray();
    protected PdfArray differences = new PdfArray();
    protected static Hashtable enStr2PdfName = new Hashtable<String, PdfName>();
    protected static Hashtable enStr2CIDInfo;

    public Encoding(PdfDocument pdfDocument, int n) {
        this.document = pdfDocument;
        if (this.encoingDataType > 2 || this.encoingDataType <= 0) {
            this.encoingDataType = 1;
        }
        this.encoingDataType = n;
        this.init();
    }

    public Encoding(PdfDocument pdfDocument) {
        this.document = pdfDocument;
        this.encoingDataType = 1;
        this.init();
    }

    public Encoding(String string) {
        this.encoingDataType = 1;
        if (enStr2PdfName.get(string) == null) {
            string = DEFAULT_ENCODING_STR;
        }
        this.encodingStr = string;
        this.encodingPdfName = (PdfName)enStr2PdfName.get(string);
        this.mCIDSystemInfo = (CIDSystemInfo)enStr2CIDInfo.get(string);
        this.init();
    }

    public Encoding(PdfName pdfName) {
        this.encoingDataType = 1;
        this.encodingPdfName = pdfName;
        this.init();
    }

    public Encoding(PdfDocument pdfDocument, PdfName pdfName) {
        this.document = pdfDocument;
        this.encoingDataType = 1;
        this.encodingPdfName = pdfName;
        this.init();
    }

    public void setDifferences(PdfArray pdfArray) {
        if (this.encoingDataType == 2) {
            this.encodingDict.put(DIFFERENCES, pdfArray);
        }
    }

    public void setCharProc(CharProc charProc) {
        this.document.getBody().add(charProc);
        this.differences.addElement(charProc.getName());
        this.charProcs.put(charProc.getName(), charProc.getReference());
    }

    public void setCharProc(CharProc charProc, char c) {
        this.document.getBody().add(charProc);
        c = (c + "").getBytes()[0];
        this.charProcList[c] = charProc;
        if (c < this.firstChar) {
            this.firstChar = c;
        }
        if (c > this.lastChar) {
            this.lastChar = c;
        }
    }

    public PdfDictionary getCharProcs() {
        return this.charProcs;
    }

    public PdfArray getWidths() {
        return this.widths;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public void init() {
        if (this.encodingPdfName == null) {
            this.encodingStr = DEFAULT_ENCODING_STR;
            this.encodingPdfName = (PdfName)enStr2PdfName.get(this.encodingStr);
            this.mCIDSystemInfo = (CIDSystemInfo)enStr2CIDInfo.get(this.encodingStr);
        }
        switch (this.encoingDataType) {
            case 1: {
                return;
            }
            case 2: {
                this.encodingDict = new PdfDictionary();
                this.encodingDict.put(TYPE, ENCODING);
                this.differences.removeAllElements();
                this.widths.removeAllElements();
                boolean bl = false;
                for (int i = this.firstChar; i <= this.lastChar; ++i) {
                    if (this.charProcList[i] != null) {
                        CharProc charProc = this.charProcList[i];
                        this.widths.addElement(new Integer(1000));
                        if (!bl) {
                            this.differences.addElement(new Integer(i));
                            bl = true;
                        }
                        this.differences.addElement(charProc.getName());
                        this.charProcs.put(charProc.getName(), charProc.getReference());
                        continue;
                    }
                    this.widths.addElement(new Integer(0));
                    bl = false;
                }
                break;
            }
        }
    }

    public final String toString() {
        String string;
        switch (this.encoingDataType) {
            case 1: {
                string = this.encodingPdfName.toString();
                break;
            }
            case 2: {
                string = this.encodingDict.toString();
                break;
            }
            default: {
                string = this.encodingPdfName.toString();
            }
        }
        return string;
    }

    public int getEncoingDataType() {
        return this.encoingDataType;
    }

    public void setEncoingType(int n) {
        if (n > 2 || n <= 0) {
            n = 1;
        }
        this.encoingDataType = n;
    }

    public PdfDictionary getEncodingDict() {
        if (this.encoingDataType == 2) {
            this.encodingDict.put(DIFFERENCES, this.differences);
        }
        return this.encodingDict;
    }

    public PdfName getEncodingPdfName() {
        return this.encodingPdfName;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public String getEncodingStr() {
        return this.encodingStr;
    }

    public CIDSystemInfo getMCIDSystemInfo() {
        return this.mCIDSystemInfo;
    }

    public void setEncoding(int n) {
        this.encoding = n;
    }

    public void setEncodingStr(String string) {
        this.encodingStr = string;
    }

    public void setMCIDSystemInfo(CIDSystemInfo cIDSystemInfo) {
        this.mCIDSystemInfo = cIDSystemInfo;
    }

    static {
        enStr2PdfName.put(new String(DEFAULT_ENCODING_STR), NAME_90MS_RKSJ_H);
        enStr2PdfName.put(new String("EUC_JP"), NAME_EUC_H);
        enStr2PdfName.put(new String("SJIS"), NAME_ADD_RKSJ_H);
        enStr2PdfName.put(new String("UnicodeBigUnmarked"), NAME_IDENTITY_H);
        enStr2CIDInfo = new Hashtable<String, CIDSystemInfo>();
        enStr2CIDInfo.put(new String(DEFAULT_ENCODING_STR), CIDINFO_2);
        enStr2CIDInfo.put(new String("EUC_JP"), CIDINFO_1);
        enStr2CIDInfo.put(new String("SJIS"), CIDINFO_1);
        enStr2CIDInfo.put(new String("UnicodeBigUnmarked"), CIDINFO_0);
    }
}

