/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.plane;

import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.ToolJudge2D;
import jp.kitec.math.geom.datapassing.ToolFigure2D;
import jp.kitec.math.geom.datapassing.ToolFigure2DArc;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2DCollection;

public class ToolPlane2D
extends ToolGeom2D {
    public static final int ERROR = -1;
    public static final int FAIL = 0;
    public static final int CW = 1;
    public static final int CCW = 2;
    public static final int INSIDE = 3;
    public static final int OUTSIDE = 4;
    public static final int ONFIGURE = 5;

    public static double findArea(ToolPolyline2D toolPolyline2D, boolean bl) {
        ToolFigure2D toolFigure2D = (ToolFigure2D)toolPolyline2D.firstElement();
        ToolFigure2D toolFigure2D2 = (ToolFigure2D)toolPolyline2D.lastElement();
        if (toolFigure2D.getX1() != toolFigure2D2.getX2() || toolFigure2D.getY1() != toolFigure2D2.getY2()) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = 0.0;
        ToolFigure2D toolFigure2D3 = toolFigure2D;
        while (toolFigure2D3 != null) {
            d2 += toolFigure2D3.getX1() * toolFigure2D3.getY2() - toolFigure2D3.getX2() * toolFigure2D3.getY1();
            if (toolFigure2D3.getType() == 2 || toolFigure2D3.getType() == 3) {
                ToolFigure2DArc toolFigure2DArc = (ToolFigure2DArc)toolFigure2D3;
                double d3 = ToolGeomFigure2D.findAreaOfSegment(toolFigure2DArc);
                d = toolFigure2DArc.isCw() ? (d += bl ? d3 : -d3) : (d += !bl ? d3 : -d3);
            }
            toolFigure2D3 = ToolGeomFigure2D.getNext(toolFigure2D3);
        }
        d2 = Math.abs(d2 / 2.0);
        return d2 + d;
    }

    public static int getDirection(ToolPolyline2D toolPolyline2D) {
        double d = 0.0;
        boolean bl = true;
        ToolFigure2D toolFigure2D = (ToolFigure2D)toolPolyline2D.lastElement();
        ToolFigure2D toolFigure2D2 = (ToolFigure2D)toolPolyline2D.firstElement();
        while (toolFigure2D2 != null) {
            block8: {
                double d2;
                block7: {
                    block6: {
                        if (toolFigure2D2.getType() != 2 && toolFigure2D2.getType() != 3) break block6;
                        d2 = ToolGeomFigure2D.getAngleOfArc((ToolFigure2DArc)toolFigure2D2);
                        d += d2;
                        break block7;
                    }
                    if (ToolGeom2D.equalPoints(toolFigure2D2.getX1(), toolFigure2D2.getY1(), toolFigure2D2.getX2(), toolFigure2D2.getY2())) break block8;
                }
                d2 = ToolGeomFigure2D.getAngleTwoTangentsOfFiguresAtJoint(toolFigure2D, toolFigure2D2);
                if (ToolPlane2D.compare(Math.abs(d2), Math.PI, 1.0E-8) == 0) {
                    return -1;
                }
                d += d2;
                toolFigure2D = toolFigure2D2;
            }
            toolFigure2D2 = ToolGeomFigure2D.getNext(toolFigure2D2);
        }
        while (6.303185307179586 < Math.abs(d)) {
            d += d > 0.0 ? Math.PI * -2 : Math.PI * 2;
        }
        int n = ToolPlane2D.compare(d, Math.PI * 2, 0.01) == 0 ? 2 : (ToolPlane2D.compare(d, Math.PI * -2, 0.01) == 0 ? 1 : 0);
        return n;
    }

    public static int determinatePoint(ToolPolyline2DCollection toolPolyline2DCollection, double d, double d2) {
        ToolPolyline2D toolPolyline2D;
        int n = 4;
        for (int i = 0; i < toolPolyline2DCollection.size() && (n = ToolPlane2D.determinatePoint(toolPolyline2D = toolPolyline2DCollection.get(i), d, d2)) != 3 && n != 5; ++i) {
        }
        return n;
    }

    public static int determinatePoint(ToolPolyline2D toolPolyline2D, double d, double d2) {
        ToolFigure2D toolFigure2D = (ToolFigure2D)toolPolyline2D.firstElement();
        double d3 = 0.0;
        double d4 = 0.0;
        if (ToolJudge2D.equalPoints(d, d2, toolFigure2D.getX1(), toolFigure2D.getY1())) {
            return 5;
        }
        double d5 = Math.atan2(toolFigure2D.getY1() - d2, toolFigure2D.getX1() - d);
        while (toolFigure2D != null) {
            double d6;
            d4 = Math.atan2(toolFigure2D.getY2() - d2, toolFigure2D.getX2() - d);
            if (ToolJudge2D.equalPoints(d, d2, toolFigure2D.getX2(), toolFigure2D.getY2())) {
                return 5;
            }
            if (toolFigure2D.getType() == 1) {
                d6 = d4 - d5;
                if (d6 < -Math.PI) {
                    d6 += Math.PI * 2;
                } else if (d6 > Math.PI) {
                    d6 -= Math.PI * 2;
                }
                if (Math.abs(Math.abs(d6) - Math.PI) <= 1.0E-8) {
                    return 5;
                }
            } else if (toolFigure2D.getType() == 2 || toolFigure2D.getType() == 3) {
                ToolFigure2DArc toolFigure2DArc = (ToolFigure2DArc)toolFigure2D;
                double d7 = ToolPlane2D.getDistance(toolFigure2DArc.getCX(), toolFigure2DArc.getCY(), d, d2);
                if (d7 < toolFigure2DArc.getRadius()) {
                    d6 = toolFigure2DArc.isCw() && d5 < d4 ? d4 - d5 - Math.PI * 2 : (!toolFigure2DArc.isCw() && d5 > d4 ? Math.PI * 2 - d5 + d4 : d4 - d5);
                } else {
                    d6 = d4 - d5;
                    if (d6 < -Math.PI) {
                        d6 += Math.PI * 2;
                    } else if (d6 > Math.PI) {
                        d6 -= Math.PI * 2;
                    }
                }
            } else {
                return 0;
            }
            d3 += d6;
            toolFigure2D = ToolGeomFigure2D.getNext(toolFigure2D);
            d5 = d4;
        }
        if (Math.abs(d3) > 5.654866776461628) {
            return 3;
        }
        if (Math.abs(d3) <= 0.01) {
            return 4;
        }
        return 0;
    }

    public static int determinatePoint(double[] dArray, double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        double[] dArray2 = new double[2];
        if (ToolJudge2D.equalPoints(d, d2, dArray[0], dArray[1])) {
            return 5;
        }
        double d6 = dArray[dArray.length - 2];
        double d7 = dArray[dArray.length - 1];
        double d8 = Math.atan2(d7 - d2, d6 - d);
        int n = 0;
        while (n + 1 < dArray.length) {
            d5 = Math.atan2(dArray[n + 1] - d2, dArray[n] - d);
            ToolPlane2D.getPerpendicularPoint(dArray2, d, d2, d6, d7, dArray[n], dArray[n + 1]);
            double d9 = ToolPlane2D.getDistance(d, d2, dArray2[0], dArray2[1]);
            if (d9 <= d3 && ToolPlane2D.checkPointOnLinearWithoutDistance(dArray2[0], dArray2[1], d6, d7, dArray[n], dArray[n + 1])) {
                return 5;
            }
            if (ToolJudge2D.equalPoints(d, d2, dArray[n], dArray[n + 1])) {
                return 5;
            }
            double d10 = d5 - d8;
            if (d10 < -Math.PI) {
                d10 += Math.PI * 2;
            } else if (d10 > Math.PI) {
                d10 -= Math.PI * 2;
            }
            if (Math.abs(Math.abs(d10) - Math.PI) <= 1.0E-8) {
                return 5;
            }
            d4 += d10;
            d6 = dArray[n];
            d7 = dArray[n + 1];
            n += 2;
            d8 = d5;
        }
        if (Math.abs(d4) > 5.654866776461628) {
            return 3;
        }
        if (Math.abs(d4) <= 0.01) {
            return 4;
        }
        return 0;
    }

    public static void getGravityPoint(double[] dArray, ToolPolyline2D toolPolyline2D) {
        double d = 0.0;
        double d2 = 0.0;
        ToolFigure2D toolFigure2D = (ToolFigure2D)toolPolyline2D.firstElement();
        while (toolFigure2D != null) {
            d += toolFigure2D.getX2();
            d2 += toolFigure2D.getY2();
            toolFigure2D = ToolGeomFigure2D.getNext(toolFigure2D);
        }
        dArray[0] = d / (double)toolPolyline2D.size();
        dArray[1] = d2 / (double)toolPolyline2D.size();
    }

    public static double getMinimumDistance(ToolPolyline2D toolPolyline2D, double d, double d2) {
        ToolFigure2D toolFigure2D = (ToolFigure2D)toolPolyline2D.firstElement();
        double[] dArray = new double[2];
        double d3 = Double.MAX_VALUE;
        toolFigure2D = (ToolFigure2D)toolPolyline2D.firstElement();
        while (toolFigure2D != null) {
            double d4 = ToolGeomFigure2D.getMinimumDistance(d, d2, toolFigure2D);
            if (d4 < d3) {
                d3 = d4;
            }
            toolFigure2D = ToolGeomFigure2D.getNext(toolFigure2D);
        }
        return d3;
    }

    public static double getMinimumDistance(ToolFigure2D[] toolFigure2DArray, ToolPolyline2D toolPolyline2D, double d, double d2) {
        ToolFigure2D toolFigure2D = (ToolFigure2D)toolPolyline2D.firstElement();
        double[] dArray = new double[2];
        double d3 = Double.MAX_VALUE;
        toolFigure2D = (ToolFigure2D)toolPolyline2D.firstElement();
        while (toolFigure2D != null) {
            double d4 = ToolGeomFigure2D.getMinimumDistance(d, d2, toolFigure2D);
            if (d4 < d3) {
                toolFigure2DArray[0] = toolFigure2D;
                d3 = d4;
            }
            toolFigure2D = ToolGeomFigure2D.getNext(toolFigure2D);
        }
        return d3;
    }

    public static boolean getFitRectangle(double[] dArray, ToolPolyline2D toolPolyline2D) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = 0;
        ToolFigure2D toolFigure2D = (ToolFigure2D)toolPolyline2D.firstElement();
        while (toolFigure2D != null) {
            if (ToolGeomFigure2D.getFitRectangle(dArray, toolFigure2D)) {
                if (n == 0) {
                    d = dArray[0];
                    d2 = dArray[1];
                    d3 = dArray[2];
                    d4 = dArray[3];
                } else {
                    if (dArray[0] < d) {
                        d = dArray[0];
                    }
                    if (dArray[1] < d2) {
                        d2 = dArray[1];
                    }
                    if (d3 < dArray[2]) {
                        d3 = dArray[2];
                    }
                    if (d4 < dArray[3]) {
                        d4 = dArray[3];
                    }
                }
                ++n2;
            }
            toolFigure2D = ToolGeomFigure2D.getNext(toolFigure2D);
            ++n;
        }
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        dArray[3] = d4;
        return n2 != 0;
    }
}

