/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;
import jp.kitec.kwt.KFont;
import jp.kitec.richui.AScrollBar;
import jp.kitec.richui.AScrollPanel;

class CaptPanel
extends JPanel {
    private KFont mFont;
    AScrollBar mAScrollBar;
    AScrollPanel mAScrollPanel;
    private float mInterval = 0.0f;
    private float mIntervalBase = 0.0f;
    private String mAddStr = "";
    protected boolean mInit = false;
    private Graphics mOffg;
    private Image mOffImg;
    private Dimension mOldD;

    public CaptPanel(AScrollBar aScrollBar, AScrollPanel aScrollPanel, KFont kFont) {
        this(aScrollBar, aScrollPanel, kFont, null, 0);
    }

    public CaptPanel(AScrollBar aScrollBar, AScrollPanel aScrollPanel, KFont kFont, Object object, int n) {
        this.setOpaque(false);
        this.mAScrollBar = aScrollBar;
        this.mAScrollPanel = aScrollPanel;
        this.mFont = kFont;
        this.mOldD = new Dimension();
    }

    public void setInterval(float f, float f2, String string) {
        this.mInterval = f;
        this.mIntervalBase = f2;
        if (string != null) {
            this.mAddStr = string;
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mInterval == 0.0f || !this.mInit) {
            return;
        }
        if (this.mOffImg == null || this.getWidth() != this.mOldD.width || this.getHeight() != this.mOldD.height) {
            if (this.mOffg != null) {
                this.mOffg.dispose();
            }
            if (this.mOffImg != null) {
                this.mOffImg.flush();
            }
            this.mOffImg = this.createImage(this.getWidth(), this.getHeight());
            this.mOffg = this.mOffImg.getGraphics();
        }
        this.mOffg.setFont(this.mFont.getFontObject());
        this.mOffg.setColor(this.mAScrollBar.mCapBackgroundColor);
        this.mOffg.fillRect(0, 0, this.getWidth(), this.getHeight());
        float f = this.mAScrollBar.mValueMin;
        float f2 = this.mAScrollBar.mValueMax;
        Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
        this.mOffg.setColor(this.getForeground());
        if (f != this.mIntervalBase) {
            this.drawText(this.mOffg, f, dimension);
        }
        this.drawText(this.mOffg, f2, dimension);
        for (float f3 = this.mIntervalBase; f3 < f2; f3 += this.mInterval) {
            this.drawText(this.mOffg, f3, dimension);
        }
        graphics.drawImage(this.mOffImg, 0, 0, null);
        graphics.dispose();
    }

    private void drawText(Graphics graphics, float f, Dimension dimension) {
        String string;
        int n;
        int n2 = this.mAScrollPanel.valToDev(f);
        int n3 = n2 - (n = this.mFont.stringWidth(string = Integer.toString((int)f) + this.mAddStr)) / 2;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 + n > dimension.width) {
            n3 = dimension.width - n;
        }
        graphics.setColor(Color.black);
        graphics.drawString(string, n3, dimension.height - 1);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 12;
        return dimension;
    }
}

