/*
 * Decompiled with CFR 0.152.
 */
package option.pdf;

import com.kt.io.AbstFile;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import option.pdf.PdfCommandGraphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfCommand {
    public static final int A1 = 0;
    public static final int A2 = 1;
    public static final int A3 = 2;
    public static final int A4 = 3;
    public static final int A5 = 4;
    public static final int A6 = 5;
    public static final int A7 = 6;
    public static final int A8 = 7;
    public static final int A9 = 8;
    public static final int A10 = 9;
    public static final int B1 = 10;
    public static final int B2 = 11;
    public static final int B3 = 12;
    public static final int B4 = 13;
    public static final int B5 = 14;
    public static final int B6 = 15;
    public static final int B7 = 16;
    public static final int B8 = 17;
    public static final int B9 = 18;
    public static final int B10 = 19;
    private static final String[] dA = new String[]{"A1", "A2", "A3", "A4", "A5", "A6", "B1", "B2", "B3", "B4", "B5", "B6"};
    private static final float[][] dB = new float[][]{{594.0f, 841.0f}, {420.0f, 594.0f}, {297.0f, 420.0f}, {210.0f, 297.0f}, {148.0f, 210.0f}, {105.0f, 148.0f}, {74.0f, 105.0f}, {52.0f, 74.0f}, {37.0f, 52.0f}, {26.0f, 37.0f}, {728.0f, 1030.0f}, {515.0f, 728.0f}, {364.0f, 515.0f}, {257.0f, 364.0f}, {182.0f, 257.0f}, {128.0f, 182.0f}, {91.0f, 128.0f}, {64.0f, 91.0f}, {45.0f, 64.0f}, {32.0f, 45.0f}};
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final int TOP_TO_BOTTOM = 0;
    public static final int BOTTOM_TO_TOP = 1;
    private String aW;
    private PdfCommandGraphics mPdfGraphics;
    private Hashtable dC;
    private AbstFile dD;
    private String aX;
    private int dE;
    private boolean dF;
    private boolean dG;
    private boolean dH;
    private int dI;
    private int dJ;
    private float dK;
    private int dL;
    private float dM;
    private float dN;
    private float dO;
    private float dP;
    private float[] dQ;
    private float[] dR;
    private float[] dS;
    private float[] dT;
    private int dU;
    private int dV;
    private int dW;
    private float dX;
    private float dY;
    private Vector dZ;
    private int ea = 0;
    int count = 0;

    public PdfCommand(String string) {
        this(string, "MS932");
    }

    public PdfCommand(String string, String string2) {
        this.aW = string2;
        this.mPdfGraphics = new PdfCommandGraphics(this);
        this.k();
        this.f(string);
        this.setPageInfomation(3, 0, 72.0f);
        this.createViewport(8);
        this.count = 0;
    }

    private void k() {
        if (this.dF) {
            throw new InternalError("PDF is alread opened");
        }
        this.dD = new AbstFile();
        this.dD.openNewFileToBuffer("", this.aW);
        this.dD.writeStringToBufferln("pdfstart");
        this.dC = new Hashtable();
        this.dE = 0;
        this.dL = 0;
        this.aX = null;
        this.dG = false;
        this.dH = false;
        this.dF = true;
        this.dZ = new Vector();
    }

    private void l() {
        if (!this.dF) {
            return;
        }
        this.dD.writeStringToBufferln("pdfend");
        this.dD.closeNewFileToBuffer();
        this.dF = false;
    }

    public void setPageInfo(int n, int n2) {
        this.setPageInfo(n, n2, 72.0f);
    }

    public void setPageInfo(int n, int n2, float f) {
        this.setPageInfomation(n, n2, f);
        this.setUserCoordinate(0.0f, 0.0f, this.dX, this.dY);
    }

    protected void setPageInfomation(int n, int n2, float f) {
        if (n < 0 || n >= dA.length) {
            throw new IllegalArgumentException("illegal page size");
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("illegal page direciton");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("illegal dpi");
        }
        this.dI = n;
        this.dJ = n2;
        this.dK = f;
        float[] fArray = dB[this.dI];
        if (this.dJ == 0) {
            this.setPageDimension(fArray[0], fArray[1]);
        } else {
            this.setPageDimension(fArray[1], fArray[0]);
        }
    }

    public void end() {
        this.endPage();
        this.m();
        this.l();
    }

    private void f(String string) {
        if (string == null) {
            throw new IllegalArgumentException("file name is null");
        }
        if (!this.dF) {
            throw new InternalError("PDF is not opend");
        }
        if (this.dG) {
            throw new InternalError("file is already opend");
        }
        this.aX = string;
        this.dD.writeStringToBufferln(new String("filestart," + this.aX));
        this.dE = 0;
        this.dG = true;
    }

    private void m() {
        if (!this.dG) {
            return;
        }
        this.dD.writeStringToBufferln(new String("fileend," + this.aX));
        this.dG = false;
    }

    private void c(String string, int n) {
        if (!this.dG) {
            throw new InternalError("file is not opend");
        }
        if (this.dH) {
            throw new InternalError("page is already opend");
        }
        StringBuffer stringBuffer = new StringBuffer("pagestart,");
        stringBuffer.append(this.dE);
        this.dD.writeStringToBufferln(stringBuffer.toString());
        stringBuffer = new StringBuffer("pagesize,");
        stringBuffer.append(string);
        stringBuffer.append(",");
        stringBuffer.append(n);
        if (this.dK != 72.0f) {
            stringBuffer.append(",");
            stringBuffer.append(this.dK);
        }
        this.dD.writeStringToBufferln(stringBuffer.toString());
        this.n();
        this.dH = true;
    }

    protected void endPage() {
        if (!this.dH) {
            return;
        }
        this.dD.writeStringToBufferln(new String("pageend," + this.dE++));
        this.dH = false;
        this.resetViewport();
        this.setUserCoordinate(0.0f, 0.0f, this.dX, this.dY);
    }

    public void setFormat(String string) {
        if (this.dZ.size() > 0) {
            this.dZ.removeAllElements();
        }
        this.addFormat(string);
    }

    public void addFormat(String string) {
        if (string != null && string.length() > 0) {
            this.dZ.addElement(string);
        }
    }

    private void n() {
        for (int i = 0; i < this.dZ.size(); ++i) {
            String string = (String)this.dZ.elementAt(i);
            this.dD.writeStringToBufferln("format," + string);
        }
    }

    public Graphics getGraphics() {
        if (!this.dH) {
            this.c(dA[this.dI], this.dJ);
        }
        return this.mPdfGraphics;
    }

    public Map<String, Object> getData() {
        this.dC.put("DATA", this.dD.getData());
        this.dC.put("ENCODING", this.aW);
        return this.dC;
    }

    public String getImageName() {
        return String.valueOf(this.dL);
    }

    public Dimension getPageDimension() {
        return new Dimension((int)this.dX, (int)this.dY);
    }

    public void createViewport(int n) {
        this.dU = n;
        this.dQ = new float[this.dU];
        this.dR = new float[this.dU];
        this.dS = new float[this.dU];
        this.dT = new float[this.dU];
        this.resetViewport();
    }

    public void resetViewport() {
        this.dW = 0;
        this.dQ[0] = 0.0f;
        this.dR[0] = 0.0f;
        this.dS[0] = 1.0f;
        this.dT[0] = 1.0f;
        this.dV = 1;
    }

    public void setViewport(float f, float f2, float f3, float f4) {
        this.dQ[this.dV] = f;
        this.dR[this.dV] = f2;
        this.dS[this.dV] = f3;
        this.dT[this.dV] = f4;
        this.dW = this.dV++;
    }

    public void setUserCoordinate(float f, float f2, float f3, float f4) {
        this.dM = f;
        this.dN = f2;
        this.dO = f3;
        this.dP = f4;
    }

    public void setUserCoordinateDirectionY(int n) {
        this.ea = n;
    }

    public int getUserCoordinateDirectionY() {
        return this.ea;
    }

    protected void setPageDimension(float f, float f2) {
        this.dX = f;
        this.dY = f2;
    }

    protected float userWidthToPageWidth(float f) {
        float f2 = this.dS[this.dW] - this.dQ[this.dW];
        return Math.abs(f2 * this.dX * f / (this.dO - this.dM));
    }

    protected float userHeightToPageHeight(float f) {
        float f2 = this.dT[this.dW] - this.dR[this.dW];
        return Math.abs(f2 * this.dY * f / (this.dP - this.dN));
    }

    protected float userXToPageX(float f) {
        return this.viewXToPageX(this.userXToViewX(f));
    }

    protected float userYToPageY(float f) {
        return this.viewYToPageY(this.userYToViewY(f));
    }

    protected float userXToViewX(float f) {
        float f2 = (f - this.dM) / (this.dO - this.dM);
        return this.dQ[this.dW] + f2 * (this.dS[this.dW] - this.dQ[this.dW]);
    }

    protected float userYToViewY(float f) {
        if (this.getUserCoordinateDirectionY() == 0) {
            f = this.dP - f;
        }
        float f2 = (f - this.dN) / (this.dP - this.dN);
        return this.dR[this.dW] + f2 * (this.dT[this.dW] - this.dR[this.dW]);
    }

    protected float viewXToPageX(float f) {
        return this.dX * f;
    }

    protected float viewYToPageY(float f) {
        return this.dY * f;
    }

    protected void draw(String string) {
        if (!this.canWrite()) {
            throw new InternalError("graphics is not ready");
        }
        this.dD.writeStringToBufferln(string);
        ++this.count;
    }

    protected void draw(int[] nArray) {
        if (!this.canWrite()) {
            throw new InternalError("graphics is not ready");
        }
        this.dC.put(new String("im" + this.dL++), nArray);
    }

    protected void draw(byte[] byArray) {
        if (!this.canWrite()) {
            throw new InternalError("graphics is not ready");
        }
        this.dC.put(new String("im" + this.dL++), byArray);
    }

    protected boolean canWrite() {
        if (!this.dF || !this.dG) {
            return false;
        }
        return this.dH;
    }
}

