/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.border.Border;

public class SubFlatBorder
implements Border {
    public static final Color DEF_DISABLED_COLOR = new Color(128, 128, 128);
    private Insets mInsets;
    private FontMetrics mFm;
    private Color mFontColor;
    private Color bP;
    private Color bQ;
    private String mTitle;
    private Font mFont;
    private int cn;

    public SubFlatBorder(String string) {
        this(string, 14);
    }

    public SubFlatBorder(String string, int n) {
        this.mTitle = string;
        Font font = new Font("\uff2d\uff33\u3000\uff30\u30b4\u30b7\u30c3\u30af", 1, n);
        this.setFont(font);
        this.setInsets(25, 3, 5, 0);
        this.setFontColor(new Color(64, 64, 64));
        this.setTitleColor(new Color(64, 64, 64), new Color(12763067));
        this.cn = 5;
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.mFm = null;
    }

    public void setFontColor(Color color) {
        this.mFontColor = color;
    }

    public void setTitleColor(Color color, Color color2) {
        this.bP = color;
        this.bQ = color2;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(n, n2 + this.cn, n3, n4);
    }

    public Insets getBorderInsets(Component component) {
        return this.mInsets;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(n3, n4);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        if (this.mFm == null) {
            this.mFm = graphics.getFontMetrics(this.mFont);
        }
        int n5 = (int)((double)this.mFont.getSize() * 1.25);
        int n6 = dimension.width - 0;
        graphics2D.setColor(this.bP);
        graphics2D.fillRect(0, 0, this.cn, n5);
        graphics2D.setColor(this.bQ);
        graphics2D.drawLine(0, n5, n6 - 20, n5);
        graphics2D.setFont(this.mFont);
        graphics2D.setColor(this.mFontColor);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawString(this.mTitle, (float)((double)this.mFont.getSize() * 0.9), (float)n2 + (float)n5 * 0.8f);
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

