/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import option.gui.RoundLinePanel;

public class RoundLinePanel2
extends RoundLinePanel {
    protected Color mShadowColor;
    protected Insets mShadowInsets;
    protected boolean mIsShadowGradient;

    public RoundLinePanel2() {
        this.setInsets(7, 12, 7, 12);
        this.setLineWidth(0);
        this.setRadius(8);
        this.setLineColor(Color.gray);
        this.setShadowColor(new Color(70, 70, 70, 128));
        this.setShadowGradient(true);
        this.setFillPanel(true);
        this.setDrawLine(true);
    }

    public void setShadowColor(Color color) {
        this.mShadowColor = color;
    }

    public void setShadowidth(int n, int n2, int n3, int n4) {
        this.mShadowInsets = new Insets(n, n2, n3, n4);
    }

    public void setShadowGradient(boolean bl) {
        this.mIsShadowGradient = bl;
    }

    public Insets getInsets() {
        return new Insets(this.mInsets.top + this.mShadowInsets.top, this.mInsets.left + this.mShadowInsets.left, this.mInsets.bottom + this.mShadowInsets.bottom, this.mInsets.right + this.mShadowInsets.right);
    }

    public void paintComponent(Graphics graphics) {
        if (!this.isOpaque()) {
            return;
        }
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.a(this.mShadowInsets);
        if (n > 0) {
            if (this.mIsShadowGradient) {
                Color color2 = new Color(this.mShadowColor.getRed(), this.mShadowColor.getGreen(), this.mShadowColor.getBlue(), this.mShadowColor.getAlpha() / n);
                graphics2D.setColor(color2);
                for (int i = 0; i < n + 1; ++i) {
                    graphics2D.fillRoundRect(i, i, dimension.width - i * 2, dimension.height - i * 2, this.mRadius + n - i, this.mRadius + n - i);
                }
            } else {
                graphics2D.setColor(this.mShadowColor);
                graphics2D.fillRoundRect(0, 0, dimension.width, dimension.height, this.mRadius + n, this.mRadius + n);
            }
        }
        if (this.mFillPanel) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRoundRect(this.mShadowInsets.left, this.mShadowInsets.top, dimension.width - this.mShadowInsets.left - this.mShadowInsets.right - 1, dimension.height - this.mShadowInsets.top - this.mShadowInsets.bottom - 1, this.mRadius, this.mRadius);
        }
        if (this.mDrawLine) {
            graphics2D.setColor(this.mLineColor);
            graphics2D.setStroke(new BasicStroke(this.mLineWidth));
            graphics2D.drawRoundRect(this.mShadowInsets.left, this.mShadowInsets.top, dimension.width - this.mShadowInsets.left - this.mShadowInsets.right - 1, dimension.height - this.mShadowInsets.left - this.mShadowInsets.right - 1, this.mRadius, this.mRadius);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    private int a(Insets insets) {
        int n = 0;
        n = Math.max(n, insets.top);
        n = Math.max(n, insets.left);
        n = Math.max(n, insets.bottom);
        n = Math.max(n, insets.right);
        return n;
    }
}

