/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import gui.basic.LabelComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPanel;
import option.gad.client.util.SwingUtil;

class IconPanel
extends JPanel {
    protected static final Font FONT = new Font("monospaced", 1, 24);

    IconPanel() {
    }

    public Dimension getPreferredSize() {
        return new Dimension(32, 32);
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics, this.getIconBackgroundColor());
        this.paintSymbol(graphics, this.getSymbol(), this.getSymbolColor());
    }

    protected Color getIconBackgroundColor() {
        return Color.BLUE;
    }

    protected String getSymbol() {
        return "\uff01";
    }

    protected Color getSymbolColor() {
        return Color.WHITE;
    }

    protected void paintBackground(Graphics graphics, Color color) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, 32, 32);
        graphics.setColor(color);
        graphics.fillRect(4, 4, 24, 24);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(0, 0, 31, 31);
        graphics.drawRect(4, 4, 23, 23);
    }

    protected void paintSymbol(Graphics graphics, String string, Color color) {
        graphics.setColor(color);
        graphics.setFont(FONT);
        int n = (this.getSize().width - graphics.getFontMetrics().stringWidth(string)) / 2;
        graphics.drawString(string, n, 24);
    }

    public void setFont(Font font) {
        super.setFont(font);
        for (Component component : SwingUtil.collectComponents(this)) {
            if (!(component instanceof LabelComponent)) continue;
            component.setFont(font);
        }
    }
}

