/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.service.step;

import java.util.HashMap;
import java.util.Map;
import option.gad.client.util.NetHomeUtil;
import option.gad.core.inject.GdInstanceFactory;
import option.gad.toex.client.doc.GdToexLayer;
import option.gad.toex.client.gui.step.GdNavigationBar;
import option.gad.toex.client.gui.step.GdStepComponentManager;
import option.gad.toex.client.service.step.GdChangeStepException;
import option.gad.toex.client.service.step.GdStep;
import option.gad.toex.client.service.step.GdStepLogic;
import option.gad.toex.client.service.step.GdStepState;
import option.gad.toex.client.service.step.GdTransitionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GdStepManager {
    protected Log mLog = LogFactory.getLog(GdStepManager.class);
    protected Map<GdStepState, GdStep> mStepMap = new HashMap<GdStepState, GdStep>();
    protected GdStepState mState = null;

    protected GdStepManager() {
        this.load();
    }

    protected abstract GdStep[] configSteps();

    protected abstract GdNavigationBar configNavigationBar();

    protected void load() {
        for (GdStep gdStep : this.getSteps()) {
            this.mStepMap.put(gdStep.state, gdStep);
        }
        this.setState(this.getSteps()[0].state);
    }

    public void setState(GdStepState gdStepState) {
        this.mState = gdStepState;
    }

    public GdStepState getState() {
        return this.mState;
    }

    public GdStepLogic getLogic() {
        return this.getLogic(this.mState);
    }

    public GdStepLogic getLogic(GdStepState gdStepState) {
        return this.mStepMap.get((Object)gdStepState).logic;
    }

    public boolean canTransit(GdStepState gdStepState) {
        if (!this.mStepMap.get((Object)gdStepState).transition.booleanValue()) {
            return false;
        }
        return !this.mStepMap.get((Object)this.mState).logic.canTransit(gdStepState);
    }

    public void setTransition(GdStepState gdStepState, Boolean bl) {
        GdNavigationBar gdNavigationBar = this.configNavigationBar();
        if (gdNavigationBar == null) {
            return;
        }
        gdNavigationBar.setState(gdStepState, false, bl);
        this.mStepMap.get((Object)gdStepState).transition = bl;
    }

    public void setTransitions(Map<GdStepState, Boolean> map) {
        for (GdStepState gdStepState : map.keySet()) {
            this.setTransition(gdStepState, map.get(gdStepState));
        }
    }

    public void goNext() {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        this.toStep(gdToexLayer.getStepState().next());
    }

    public void goPrev() {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        this.toStep(gdToexLayer.getStepState().prev());
    }

    public void toPrev() {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        this.toStep(gdToexLayer.getStepState().prev());
    }

    public void toNext() {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        this.toStep(gdToexLayer.getStepState().next());
    }

    public void toStep(GdStepState gdStepState) {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        GdStepState gdStepState2 = gdToexLayer.getStepState();
        this.toStep(gdStepState2, gdStepState);
    }

    public void toStep(GdStepState gdStepState, GdStepState gdStepState2) {
        if (gdStepState == gdStepState2) {
            return;
        }
        this.moveStep(gdStepState, gdStepState2);
    }

    protected void moveStep(GdStepState gdStepState, GdStepState gdStepState2) throws GdTransitionException {
        GdStepLogic gdStepLogic;
        block13: {
            if (gdStepState == gdStepState2) {
                return;
            }
            GdStepState gdStepState3 = gdStepState;
            gdStepLogic = this.getLogic();
            try {
                if (gdStepState2.getNum() < gdStepState.getNum()) {
                    while (gdStepState3 != gdStepState2) {
                        GdStepState gdStepState4;
                        block12: {
                            gdStepState4 = gdStepState3.prev();
                            if (gdStepState4 == null) {
                                return;
                            }
                            try {
                                gdStepLogic.beforePrev(gdStepState, gdStepState2);
                                gdStepState3 = gdStepState4;
                                gdStepLogic.toPrev();
                                gdStepLogic.afterPrev(gdStepState, gdStepState2);
                            }
                            catch (GdChangeStepException gdChangeStepException) {
                                GdStepState gdStepState5 = gdChangeStepException.getStepState();
                                if (gdStepState5 == null) break block12;
                                gdStepState2 = gdStepState4 = gdStepState5;
                            }
                        }
                        this.setState(gdStepState4);
                        gdStepLogic = this.getLogic();
                        gdStepLogic.init();
                    }
                    break block13;
                }
                while (gdStepState3 != gdStepState2) {
                    GdStepState gdStepState6;
                    block14: {
                        gdStepState6 = gdStepState3.next();
                        if (gdStepState6 == null) {
                            return;
                        }
                        try {
                            gdStepLogic.beforeNext(gdStepState, gdStepState2);
                            gdStepState3 = gdStepState6;
                            gdStepLogic.toNext();
                            gdStepLogic.afterNext(gdStepState, gdStepState2);
                        }
                        catch (GdChangeStepException gdChangeStepException) {
                            GdStepState gdStepState7 = gdChangeStepException.getStepState();
                            if (gdStepState7 == null) break block14;
                            gdStepState2 = gdStepState6 = gdStepState7;
                        }
                    }
                    this.setState(gdStepState6);
                    gdStepLogic = this.getLogic();
                    gdStepLogic.init();
                }
            }
            catch (GdTransitionException gdTransitionException) {
                gdStepState2 = gdStepState3;
                this.setState(gdStepState3);
            }
        }
        this.stepMoved(gdStepState, gdStepState2);
        gdStepLogic.boot();
    }

    protected void stepMoved(GdStepState gdStepState, GdStepState gdStepState2) {
        this.updateNavigationBar(gdStepState, gdStepState2);
        this.selectStepComponent(gdStepState2);
    }

    protected void updateNavigationBar(GdStepState gdStepState, GdStepState gdStepState2) {
        GdNavigationBar gdNavigationBar = this.configNavigationBar();
        if (gdNavigationBar == null) {
            return;
        }
        int n = this.getSteps().length;
        for (int i = 0; i < n; ++i) {
            GdStepState gdStepState3 = this.getSteps()[i].state;
            GdStepLogic gdStepLogic = this.getLogic(gdStepState3);
            boolean bl = gdStepLogic.canTransit(gdStepState3);
            boolean bl2 = gdStepState2 == gdStepState3;
            gdNavigationBar.setState(gdStepState3, bl2, bl);
        }
    }

    protected void selectStepComponent(GdStepState gdStepState) {
        GdStepComponentManager gdStepComponentManager = (GdStepComponentManager)GdInstanceFactory.getInstance().getInstance(GdStepComponentManager.class, new Object[0]);
        gdStepComponentManager.select(gdStepState);
    }

    public GdStep[] getSteps() {
        return this.configSteps();
    }
}

