/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import jp.kitec.kwt.Area;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.IChildGeometorys;
import option.gad.client.geom.primitive.GdGeometry;
import option.gad.client.geom.primitive.GdGeometryGraph;
import option.gad.core.inject.GdInstanceFactory;
import option.gad.core.util.Closure;
import option.gad.core.util.CollectionUtil;
import option.gad.core.util.SetNotNullDecorator;
import option.gad.core.util.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdGeomUtil {
    protected GdGeomUtil() {
    }

    public static <T extends Geometory> Collection<Geometory> collectGeometry(Collection<T> collection) {
        SetNotNullDecorator setNotNullDecorator = new SetNotNullDecorator(new LinkedHashSet());
        for (Geometory geometory : collection) {
            setNotNullDecorator.addAll(GdGeomUtil.collectGeometry(geometory));
        }
        return setNotNullDecorator;
    }

    public static Collection<Geometory> collectGeometry(Geometory geometory) {
        SetNotNullDecorator setNotNullDecorator = new SetNotNullDecorator(new LinkedHashSet());
        setNotNullDecorator.add(geometory);
        if (geometory instanceof IChildGeometorys) {
            IChildGeometorys iChildGeometorys = (IChildGeometorys)geometory;
            Vector vector = iChildGeometorys.getChildGeometorys();
            for (Geometory geometory2 : vector) {
                setNotNullDecorator.addAll(GdGeomUtil.collectGeometry(geometory2));
            }
        }
        return setNotNullDecorator;
    }

    public static void clearGeometry(Geometory geometory) {
        IChildGeometorys iChildGeometorys;
        if (geometory instanceof IChildGeometorys) {
            iChildGeometorys = (IChildGeometorys)geometory;
            Vector vector = iChildGeometorys.getChildGeometorys();
            for (Geometory geometory2 : vector) {
                GdGeomUtil.clearGeometry(geometory2);
            }
        }
        if (geometory instanceof GdGeometryGraph) {
            iChildGeometorys = (GdGeometryGraph)geometory;
            iChildGeometorys.clearChildGeometries();
            iChildGeometorys.clearParentGeometries();
        }
    }

    public static Set<Geometory> collectParentGeometry(Geometory geometory) {
        SetNotNullDecorator setNotNullDecorator = new SetNotNullDecorator(new LinkedHashSet());
        setNotNullDecorator.add(geometory);
        if (geometory instanceof GdGeometryGraph) {
            GdGeometryGraph gdGeometryGraph = (GdGeometryGraph)geometory;
            Collection<Geometory> collection = gdGeometryGraph.getParentGeometries();
            for (Geometory geometory2 : collection) {
                setNotNullDecorator.addAll(GdGeomUtil.collectParentGeometry(geometory2));
            }
        }
        return setNotNullDecorator;
    }

    public static <T extends Geometory, U extends Geometory> T findGeometry(Collection<U> collection, int n) {
        Geometory geometory = null;
        for (Geometory geometory2 : collection) {
            if (geometory2.getID() != n) continue;
            geometory = geometory2;
            break;
        }
        return (T)geometory;
    }

    public static <T, U extends Geometory> T findGeometry(Collection<U> collection, Class<T> clazz) {
        Collection<T> collection2 = GdGeomUtil.collectGeometry(collection, clazz);
        if (collection2.size() != 1) {
            throw new IllegalStateException();
        }
        return collection2.iterator().next();
    }

    public static <T> T findGeometry(Geometory geometory, Class<T> clazz) {
        Collection<T> collection = GdGeomUtil.collectGeometry(geometory, clazz);
        if (collection.size() != 1) {
            throw new IllegalStateException();
        }
        return collection.iterator().next();
    }

    public static Geometory findMinXGeometry(Geometory geometory) {
        return GdGeomUtil.findMinXGeometry(GdGeomUtil.collectGeometry(geometory));
    }

    public static <T extends Geometory> Geometory findMinXGeometry(Collection<T> collection) {
        return GdGeomUtil.findEndGeometry(collection, new Closure<Tuple<Area, Area>, Boolean>(){});
    }

    public static Geometory findMaxXGeometry(Geometory geometory) {
        return GdGeomUtil.findMaxXGeometry(GdGeomUtil.collectGeometry(geometory));
    }

    public static <T extends Geometory> Geometory findMaxXGeometry(Collection<T> collection) {
        return GdGeomUtil.findEndGeometry(collection, new Closure<Tuple<Area, Area>, Boolean>(){});
    }

    public static Geometory findEndGeometry(Geometory geometory, Closure<Tuple<Area, Area>, Boolean> closure) {
        return GdGeomUtil.findEndGeometry(GdGeomUtil.collectGeometry(geometory), closure);
    }

    public static <T extends Geometory> Geometory findEndGeometry(Collection<T> collection, Closure<Tuple<Area, Area>, Boolean> closure) {
        Geometory geometory = null;
        Area area = new Area();
        area.maximize();
        for (Geometory geometory2 : collection) {
            Area area2 = new Area();
            area2.maximize();
            geometory2.updateMinMax(area2);
            if (!((Boolean)closure.execute((Object)new Tuple((Object)area2, (Object)area))).booleanValue()) continue;
            geometory = geometory2;
            area = area2;
        }
        return geometory;
    }

    public static <T extends Geometory> Area calcGeometryArea(T t) {
        Area area = new Area();
        area.maximize();
        area.updateMinMax(t.getArea());
        return area;
    }

    public static <T extends Geometory> Area calcGeometryArea(Collection<T> collection) {
        Area area = new Area();
        area.maximize();
        for (Geometory geometory : collection) {
            geometory.updateMinMax(area);
        }
        return area;
    }

    public static <T, U extends Geometory> Collection<T> collectGeometry(Collection<U> collection, Class<T> clazz) {
        SetNotNullDecorator setNotNullDecorator = new SetNotNullDecorator(new LinkedHashSet());
        for (Geometory geometory : collection) {
            setNotNullDecorator.addAll(GdGeomUtil.collectGeometry(geometory, clazz));
        }
        return setNotNullDecorator;
    }

    public static <T> Collection<T> collectGeometry(Geometory geometory, Class<T> clazz) {
        SetNotNullDecorator setNotNullDecorator = new SetNotNullDecorator(new LinkedHashSet());
        for (Geometory geometory2 : GdGeomUtil.collectGeometry(geometory)) {
            if (!clazz.isInstance(geometory2)) continue;
            setNotNullDecorator.add(geometory2);
        }
        return setNotNullDecorator;
    }

    public static <T extends Geometory> T getNearGeometry(Collection<T> collection, Class<T> clazz, float f, float f2) {
        return GdGeomUtil.getNearGeometry(collection, clazz, f, f2, null);
    }

    public static <T extends Geometory> T getNearGeometry(Collection<T> collection, Class<T> clazz, float f, float f2, Float f3) {
        return GdGeomUtil.getNearGeometry(collection, clazz, f, f2, f3, null);
    }

    public static <T extends Geometory> T getNearGeometry(Collection<T> collection, Class<T> clazz, float f, float f2, Float f3, Closure<T, Boolean> closure) {
        Geometory geometory = null;
        float f4 = Float.POSITIVE_INFINITY;
        for (Geometory geometory2 : collection) {
            if (clazz != null && !clazz.isInstance(geometory2)) continue;
            float f5 = geometory2.getDistanceToPoint(f, f2);
            if (f3 != null && geometory2.getDistanceToPoint(f, f2) > f3.floatValue() || closure != null && !((Boolean)closure.execute((Object)geometory2)).booleanValue() || !(f5 > 0.0f) || !(f4 > f5)) continue;
            geometory = geometory2;
            f4 = f5;
        }
        return (T)geometory;
    }

    public static <T extends Geometory> T getNextGeometry(Collection<T> collection, T t, float f, float f2) {
        return GdGeomUtil.getNextGeometry(collection, t, f, f2, null);
    }

    public static <T extends Geometory> T getNextGeometry(Collection<T> collection, T t, float f, float f2, Closure<T, Boolean> closure) {
        if (t == null) {
            return null;
        }
        Geometory geometory = null;
        float f3 = Float.POSITIVE_INFINITY;
        for (Geometory geometory2 : collection) {
            float f4;
            if (!t.getClass().isInstance(geometory2) || geometory2 == t || closure != null && !((Boolean)closure.execute((Object)geometory2)).booleanValue() || !((f4 = geometory2.getDistanceToPoint(f, f2)) > 0.0f) || !(f3 > f4)) continue;
            geometory = geometory2;
            f3 = f4;
        }
        return (T)geometory;
    }

    public static <T extends Geometory> void sortGeometryByPriorityAsc(Collection<T> collection) {
        CollectionUtil.sort(collection, (Comparator)new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                int n = 0;
                int n2 = 0;
                if (t instanceof GdGeometry) {
                    n = ((GdGeometry)t).getPriority();
                }
                if (t2 instanceof GdGeometry) {
                    n2 = ((GdGeometry)t2).getPriority();
                }
                int n3 = 0;
                if (n < n2) {
                    n3 = -1;
                }
                if (n > n2) {
                    n3 = 1;
                }
                return n3;
            }
        });
    }

    public static <T extends Geometory> void sortGeometryByPriorityDesc(Collection<T> collection) {
        CollectionUtil.sort(collection, (Comparator)new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                int n = 0;
                int n2 = 0;
                if (t instanceof GdGeometry) {
                    n = ((GdGeometry)t).getPriority();
                }
                if (t2 instanceof GdGeometry) {
                    n2 = ((GdGeometry)t2).getPriority();
                }
                int n3 = 0;
                if (n < n2) {
                    n3 = 1;
                }
                if (n > n2) {
                    n3 = -1;
                }
                return n3;
            }
        });
    }

    public static <T extends GPoint2Df> void sortPoints(Collection<T> collection) {
        CollectionUtil.sort(collection, (Comparator)new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                int n = 0;
                if (((GPoint2Df)t).x < ((GPoint2Df)t2).x) {
                    n = -1;
                }
                if (((GPoint2Df)t).x > ((GPoint2Df)t2).x) {
                    n = 1;
                }
                return n;
            }
        });
    }

    public static <T extends Geometory> T clone(Class<T> clazz, Object object) {
        if (clazz == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(object)) {
            return (T)((Geometory)object);
        }
        return (T)((Geometory)GdInstanceFactory.getInstance().getPrototypeInstance(clazz, new Object[0]));
    }

    public static <T extends Geometory> void renumberID(Collection<T> collection) {
        int n = 0;
        for (Geometory geometory : collection) {
            geometory.setID(++n);
        }
    }
}

