/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.startup;

import com.kt.util.CompressData;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import option.gad.client.startup.GdByteRequestAdapter;
import option.gad.core.io.FileIOUtil;
import option.gad.core.util.TimeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryableCastedByteRequestAdapter
implements GdByteRequestAdapter {
    protected static Log mLog = LogFactory.getLog(RetryableCastedByteRequestAdapter.class);
    protected Future<Object> mResultFuture;
    protected String mContextPath;
    protected byte[] mRequest;
    protected URL mCodebase;
    protected byte[] mKeepResource;
    protected int mConnectTimeOut = 60000;
    protected int mReadTimeOut = 60000;
    protected int mRetryTimeOut = 180000;
    protected int mRetryInterval = 10000;
    protected int mRetryCount = 0;

    public byte[] doRequest(String string, byte[] byArray, URL uRL) {
        this.mContextPath = string;
        this.mRequest = byArray;
        this.mCodebase = uRL;
        this.mKeepResource = null;
        byte[] byArray2 = null;
        Exception exception = null;
        long l = System.currentTimeMillis();
        this.mRetryCount = 0;
        while (true) {
            long l2;
            if ((l2 = System.currentTimeMillis()) - l > (long)this.mRetryTimeOut) {
                mLog.error((Object)("resource request failure contextPath[" + this.mContextPath + "] time[" + (l2 - l) + "]ms retry[" + this.mRetryCount + "]"));
                throw new RuntimeException(exception);
            }
            try {
                this.requestThread();
                byArray2 = this.getResult();
            }
            catch (Exception exception2) {
                exception = exception2;
                TimeUtil.sleep((long)this.mRetryInterval);
                ++this.mRetryCount;
                continue;
            }
            break;
        }
        return byArray2;
    }

    protected void requestThread() {
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                return thread;
            }
        };
        ExecutorService executorService = Executors.newCachedThreadPool(threadFactory);
        this.mResultFuture = executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return RetryableCastedByteRequestAdapter.this.request();
            }
        });
    }

    protected byte[] request() {
        byte[] byArray = null;
        ObjectOutputStream objectOutputStream = null;
        InputStream inputStream = null;
        URL uRL = null;
        try {
            uRL = new URL(this.mCodebase, this.mContextPath);
            mLog.debug((Object)("url[" + uRL + "]"));
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(this.mConnectTimeOut);
            uRLConnection.setReadTimeout(this.mReadTimeOut);
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Content-type", "application/octet-stream");
            objectOutputStream = new ObjectOutputStream(uRLConnection.getOutputStream());
            byte[] byArray2 = CompressData.compress((byte[])this.mRequest);
            objectOutputStream.writeObject(byArray2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileIOUtil.write((OutputStream)byteArrayOutputStream, (InputStream)uRLConnection.getInputStream());
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            byArray = byArray3 == null ? null : CompressData.decompress((byte[])byArray3);
        }
        catch (Exception exception) {
            try {
                mLog.debug((Object)("urlconnection failure url[" + uRL + "]"), (Throwable)exception);
                throw new RuntimeException(exception);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(inputStream);
                FileIOUtil.close(objectOutputStream);
                throw throwable;
            }
        }
        FileIOUtil.close(inputStream);
        FileIOUtil.close((OutputStream)objectOutputStream);
        return byArray;
    }

    protected byte[] getResult() {
        byte[] byArray = this.mKeepResource;
        if (byArray == null) {
            this.mKeepResource = byArray = (byte[])this.loadResource();
        }
        return byArray;
    }

    protected <R> R loadResource() {
        long l = System.currentTimeMillis();
        mLog.info((Object)("loading start contextPath[" + this.mContextPath + "] retry[" + this.mRetryCount + "]"));
        if (this.mResultFuture == null) {
            mLog.warn((Object)("loading failure contextPath[" + this.mContextPath + "] retry[" + this.mRetryCount + "]"));
            throw new IllegalStateException("resultFuture is null");
        }
        Object object = null;
        try {
            object = this.mResultFuture.get();
        }
        catch (Exception exception) {
            long l2 = System.currentTimeMillis();
            mLog.warn((Object)("loading failure contextPath[" + this.mContextPath + "] time[" + (l2 - l) + "]ms retry[" + this.mRetryCount + "]"), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        long l3 = System.currentTimeMillis();
        if (object == null) {
            mLog.warn((Object)("loading failure contextPath[" + this.mContextPath + "] time[" + (l3 - l) + "]ms retry[" + this.mRetryCount + "]"));
            throw new IllegalStateException("resource is null");
        }
        mLog.info((Object)("loading completion contextPath[" + this.mContextPath + "] time[" + (l3 - l) + "]ms retry[" + this.mRetryCount + "]"));
        return (R)object;
    }

    public void setConnectTimeout(int n) {
        this.mConnectTimeOut = n;
    }

    public void setReadTimeout(int n) {
        this.mReadTimeOut = n;
    }

    public void setRetryTimeout(int n) {
        this.mRetryTimeOut = n;
    }

    public void setRetryInterval(int n) {
        this.mRetryInterval = n;
    }
}

