/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import option.gad.core.util.Closure;
import option.gad.core.util.ReflectUtil;
import sandbox.gui.basic.JGraphicsBorderButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdImageRadioButton
extends JRadioButton {
    protected GdImageRadioButton owner = this;
    protected String localText;
    protected Image image;
    protected String dispText;
    protected JGraphicsBorderButton graphicsButton;
    protected JRadioButton radioButton;
    protected JLabel label;
    protected List<Closure<GdImageRadioButton, Void>> closureList = new ArrayList<Closure<GdImageRadioButton, Void>>();

    public GdImageRadioButton(String string, Image image, String string2) {
        this.localText = string;
        super.setText(string);
        this.image = image;
        this.dispText = this.convHtml(string2);
        this.initComponents();
        this.init();
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setIcon(new ImageIcon());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add(this.createGraphicButton(this.image), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add(this.createRadio(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add(this.createLabel(this.dispText), gridBagConstraints);
    }

    protected Component createGraphicButton(Image image) {
        JGraphicsBorderButton jGraphicsBorderButton = new JGraphicsBorderButton("imageButton", image);
        jGraphicsBorderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GdImageRadioButton.this.setSelected(true);
            }
        });
        this.graphicsButton = jGraphicsBorderButton;
        return jGraphicsBorderButton;
    }

    protected Component createLabel(String string) {
        JLabel jLabel = new JLabel(){

            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                this.setForeground(bl ? Color.BLACK : Color.LIGHT_GRAY);
            }
        };
        jLabel.setText(string);
        this.label = jLabel;
        return jLabel;
    }

    protected Component createRadio() {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GdImageRadioButton.this.setSelected(true);
            }
        });
        this.radioButton = jRadioButton;
        return jRadioButton;
    }

    protected String convHtml(String string) {
        if (string.indexOf("<html>") >= 0) {
            return string;
        }
        return "<html>" + string.replaceAll("\n", "<br>") + "</html>";
    }

    protected void init() {
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GdImageRadioButton.this.radioButton.setSelected(itemEvent.getStateChange() == 1);
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                GdImageRadioButton.this.fireEvent(GdImageRadioButton.this.owner);
            }
        });
    }

    public void addEventListener(Closure<GdImageRadioButton, Void> closure) {
        this.closureList.add(closure);
    }

    protected void fireEvent(GdImageRadioButton gdImageRadioButton) {
        for (Closure<GdImageRadioButton, Void> closure : this.closureList) {
            closure.execute((Object)gdImageRadioButton);
        }
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.radioButton.setSelected(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.graphicsButton.setEnabled(bl);
        this.radioButton.setEnabled(bl);
        this.label.setEnabled(bl);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        ReflectUtil.setFieldValue((Object)this, (String)"text", (Object)"");
        if (this.isEnabled()) {
            super.paintComponent(graphics);
        }
        ReflectUtil.setFieldValue((Object)this, (String)"text", (Object)this.localText);
    }
}

