/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.geom.primitive;

import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.Serializable;
import java.util.List;
import jp.kitec.kwt.Area;
import nethome.geom.primitive.Geometory;
import nethome.geom.util.ToolMath;
import option.gad.client.dao.SerializeDaoUtil;
import option.gad.client.geom.primitive.GdGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GdGeometryBasic
extends GdGeometry
implements Serializable {
    protected float mX = 0.0f;
    protected float mY = 0.0f;
    protected float mZ = 0.0f;
    protected float mWidth = 0.0f;
    protected float mHeight = 0.0f;
    protected float mDepth = 0.0f;
    protected boolean mRotable;
    protected boolean mFlippable;
    protected boolean mFlipX;
    protected boolean mFlipY;
    protected float mAngle;

    public GdGeometryBasic getCopy(GdGeometryBasic gdGeometryBasic) {
        GdGeometryBasic gdGeometryBasic2 = gdGeometryBasic;
        if (gdGeometryBasic2 == null) {
            return null;
        }
        gdGeometryBasic2.mX = this.mX;
        gdGeometryBasic2.mY = this.mY;
        gdGeometryBasic2.mZ = this.mZ;
        gdGeometryBasic2.mWidth = this.mWidth;
        gdGeometryBasic2.mHeight = this.mHeight;
        gdGeometryBasic2.mDepth = this.mDepth;
        gdGeometryBasic2.mRotable = this.mRotable;
        gdGeometryBasic2.mFlippable = this.mFlippable;
        gdGeometryBasic2.mFlipX = this.mFlipX;
        gdGeometryBasic2.mFlipY = this.mFlipY;
        gdGeometryBasic2.mAngle = this.mAngle;
        for (Geometory geometory : this.getChildGeometries()) {
            GdGeometryBasic gdGeometryBasic3 = (GdGeometryBasic)geometory;
            gdGeometryBasic2.addChildGeometry(gdGeometryBasic3.getCopy(null));
        }
        return gdGeometryBasic2;
    }

    @Override
    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        super.save(objectFolder);
        objectFolder.addChild(SerializeDaoUtil.convertNode("x", Float.valueOf(this.mX)));
        objectFolder.addChild(SerializeDaoUtil.convertNode("y", Float.valueOf(this.mY)));
        objectFolder.addChild(SerializeDaoUtil.convertNode("z", Float.valueOf(this.mZ)));
        objectFolder.addChild(SerializeDaoUtil.convertNode("width", Float.valueOf(this.mWidth)));
        objectFolder.addChild(SerializeDaoUtil.convertNode("height", Float.valueOf(this.mHeight)));
        objectFolder.addChild(SerializeDaoUtil.convertNode("depth", Float.valueOf(this.mDepth)));
        objectFolder.addChild(SerializeDaoUtil.convertNode("rotable", this.mRotable));
        objectFolder.addChild(SerializeDaoUtil.convertNode("flippable", this.mFlippable));
        objectFolder.addChild(SerializeDaoUtil.convertNode("flipX", this.mFlipX));
        objectFolder.addChild(SerializeDaoUtil.convertNode("flipY", this.mFlipY));
        objectFolder.addChild(SerializeDaoUtil.convertNode("angle", Float.valueOf(this.mAngle)));
    }

    @Override
    public void load(ObjectFolder objectFolder, List<Geometory> list) {
        super.load(objectFolder, list);
        ObjectNode objectNode = null;
        objectNode = objectFolder.getNode("x");
        if (objectNode != null) {
            this.mX = SerializeDaoUtil.convertObject(Float.class, objectNode).floatValue();
        }
        if ((objectNode = objectFolder.getNode("y")) != null) {
            this.mY = SerializeDaoUtil.convertObject(Float.class, objectNode).floatValue();
        }
        if ((objectNode = objectFolder.getNode("z")) != null) {
            this.mZ = SerializeDaoUtil.convertObject(Float.class, objectNode).floatValue();
        }
        if ((objectNode = objectFolder.getNode("width")) != null) {
            this.mWidth = SerializeDaoUtil.convertObject(Float.class, objectNode).floatValue();
        }
        if ((objectNode = objectFolder.getNode("height")) != null) {
            this.mHeight = SerializeDaoUtil.convertObject(Float.class, objectNode).floatValue();
        }
        if ((objectNode = objectFolder.getNode("depth")) != null) {
            this.mDepth = SerializeDaoUtil.convertObject(Float.class, objectNode).floatValue();
        }
        if ((objectNode = objectFolder.getNode("rotable")) != null) {
            this.mRotable = SerializeDaoUtil.convertObject(Boolean.class, objectNode);
        }
        if ((objectNode = objectFolder.getNode("flippable")) != null) {
            this.mFlippable = SerializeDaoUtil.convertObject(Boolean.class, objectNode);
        }
        if ((objectNode = objectFolder.getNode("flipX")) != null) {
            this.mFlipX = SerializeDaoUtil.convertObject(Boolean.class, objectNode);
        }
        if ((objectNode = objectFolder.getNode("flipY")) != null) {
            this.mFlipY = SerializeDaoUtil.convertObject(Boolean.class, objectNode);
        }
        if ((objectNode = objectFolder.getNode("angle")) != null) {
            this.mAngle = SerializeDaoUtil.convertObject(Float.class, objectNode).floatValue();
        }
    }

    @Override
    public void updateMinMax(Area area) {
        area.updateMinMax(this.getArea());
    }

    @Override
    public void offset(float f, float f2) {
        this.mX += f;
        this.mY += f2;
    }

    @Override
    public void rotate(float f, float f2, float f3) {
        float[] fArray = new float[2];
        ToolMath.rotation2D((double)f, (double)f2, (double)f3, (double)this.mX, (double)this.mY, (float[])fArray);
        this.mX = (float)(Math.rint(fArray[0] * 1000.0f) / 1000.0);
        this.mY = (float)(Math.rint(fArray[1] * 1000.0f) / 1000.0);
    }

    public void setLocation(float f, float f2) {
        this.mX = f;
        this.mY = f2;
    }

    public void setLocation(float f, float f2, float f3) {
        this.mX = f;
        this.mY = f2;
        this.mZ = f3;
    }

    public void setX(float f) {
        this.mX = f;
    }

    public float getX() {
        return this.mX;
    }

    public void setY(float f) {
        this.mY = f;
    }

    public float getY() {
        return this.mY;
    }

    public void setZ(float f) {
        this.mZ = f;
    }

    public float getZ() {
        return this.mZ;
    }

    public void setWidth(float f) {
        this.mWidth = f;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public void setHeight(float f) {
        this.mHeight = f;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public void setDepth(float f) {
        this.mDepth = f;
    }

    public float getDepth() {
        return this.mDepth;
    }

    @Override
    public Area getArea() {
        Area area = new Area();
        area.maximize();
        area.minX = this.getX() - this.getWidth() / 2.0f;
        area.minY = this.getY() - this.getHeight() / 2.0f;
        area.maxX = this.getX() + this.getWidth() / 2.0f;
        area.maxY = this.getY() + this.getHeight() / 2.0f;
        return area;
    }

    public void setRotable(boolean bl) {
        this.mRotable = bl;
    }

    public boolean isRotable() {
        return this.mRotable;
    }

    public void setFlippable(boolean bl) {
        this.mFlippable = bl;
    }

    public boolean isFlippable() {
        return this.mFlippable;
    }

    public void setFlipX(boolean bl) {
        this.mFlipX = bl;
    }

    public boolean isFlipX() {
        return this.mFlipX;
    }

    public void setFlipY(boolean bl) {
        this.mFlipY = bl;
    }

    public boolean isFlipY() {
        return this.mFlipY;
    }
}

