import { Tuple4d } from './Tuple4d';
import { Tuple3d } from './Tuple3d';
/**
 * A 4 element vector that is represented by double precision floating point
 * x,y,z,w coordinates.
 * @version specification 1.1, implementation $Revision: 1.9 $, $Date: 1999/10/05 07:03:50 $
 * @author Kenji hiranabe
 */
export declare class Vector4d extends Tuple4d {
    /**
     * Sets the x,y,z components of this point to the corresponding
     * components of tuple t1. The w component of this point is set to 1.
     * @param t1 the tuple to be copied
     * @since Java3D 1.2
     */
    set_tuple3(t1: Tuple3d): void;
    /**
     * Returns the squared length of this vector.
     * @return the squared length of this vector
     */
    lengthSquared(): number;
    /**
     * Returns the length of this vector.
     * @return the length of this vector
     */
    length(): number;
    /**
     * Computes the dot product of the this vector and vector v1.
     * @param v1 the other vector
     * @return the dot product of this vector and vector v1
     */
    dot(v1: Vector4d): number;
    /**
     * Sets the value of this vector to the normalization of vector v1.
     * @param v1 the un-normalized vector
     * Normalizes this vector in place.
     */
    normalize(v1?: Vector4d): void;
    /**
     * Returns the (4-space) angle in radians between this vector and
     * the vector parameter; the return value is constrained to the
     * range [0,PI].
     * @param v1  the other vector
     * @return the angle in radians in the range [0,PI]
     */
    angle(v1: Vector4d): number;
}
