import { Tuple3d } from './Tuple3d';
/**
 * A 3 element vector that is represented by double precision floating point
 * x,y,z coordinates. If this value represents a normal, then it should be
 * normalized.
 * @version specification 1.1, implementation $Revision: 1.8 $, $Date: 1999/10/05 07:03:50 $
 * @author Kenji hiranabe
 */
export declare class Vector3d extends Tuple3d {
    /**
     * Sets this vector to be the vector cross product of vectors v1 and v2.
     * @param v1 the first vector
     * @param v2 the second vector
     */
    cross(v1: Vector3d, v2: Vector3d): void;
    /**
     * Sets the value of this vector to the normalization of vector v1.
     * @param v1 the un-normalized vector
     * Normalizes this vector in place.
     */
    normalize(v1?: Vector3d): void;
    /**
     * Computes the dot product of the this vector and vector v1.
     * @param v1 the other vector
     */
    dot(v1: Vector3d): number;
    /**
     * Returns the squared length of this vector.
     * @return the squared length of this vector
     */
    lengthSquared(): number;
    /**
     * Returns the length of this vector.
     * @return the length of this vector
     */
    length(): number;
    /**
     * Returns the angle in radians between this vector and
     * the vector parameter; the return value is constrained to the
     * range [0,PI].
     * @param v1  the other vector
     * @return the angle in radians in the range [0,PI]
     */
    angle(v1: Vector3d): number;
}
