/*
   Copyright (C) 1997,1998,1999
   Kenji Hiranabe, Eiwa System Management, Inc.

   This program is free software.
   Implemented by Kenji Hiranabe(hiranabe@esm.co.jp),
   conforming to the Java(TM) 3D API specification by Sun Microsystems.

   Permission to use, copy, modify, distribute and sell this software
   and its documentation for any purpose is hereby granted without fee,
   provided that the above copyright notice appear in all copies and
   that both that copyright notice and this permission notice appear
   in supporting documentation. Kenji Hiranabe and Eiwa System Management,Inc.
   makes no representations about the suitability of this software for any
   purpose.  It is provided "AS IS" with NO WARRANTY.
*/
"use strict";
import { Tuple2d } from './Tuple2d';
/**
 * A 2 element vector that is represented by single precision
 * floating point x,y coordinates.
 * @version specification 1.1, implementation $Revision: 1.4 $, $Date: 1999/10/05 07:03:50 $
 * @author Kenji hiranabe
 */
export class Vector2d extends Tuple2d {
    /**
     * Computes the dot product of the this vector and vector v1.
     * @param v1 the other vector
     */
    dot(v1) {
        return this.x * v1.x + this.y * v1.y;
    }
    /**
     * Returns the length of this vector.
     * @return the length of this vector
     */
    length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }
    /**
     * Returns the squared length of this vector.
     * @return the squared length of this vector
     */
    lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }
    /**
     * Normalizes this vector in place.d
     *
     * Sets the value of this vector to the normalization of vector v1.
     * @param v1 the un-normalized vector
     */
    normalize(v1) {
        if (v1)
            this.set_tuple(v1);
        let d = this.length();
        this.x /= d;
        this.y /= d;
    }
    /**
     * Returns the angle in radians between this vector and
     * the vector parameter; the return value is constrained to the
     * range [0,PI].
     * @param v1  the other vector
     * @return the angle in radians in the range [0,PI]
     */
    angle(v1) {
        return Math.abs(Math.atan2(this.x * v1.y - this.y * v1.x, this.dot(v1)));
    }
}
//# sourceMappingURL=Vector2d.js.map