import { Tuple2d } from './Tuple2d';
/**
 * A 2 element vector that is represented by single precision
 * floating point x,y coordinates.
 * @version specification 1.1, implementation $Revision: 1.4 $, $Date: 1999/10/05 07:03:50 $
 * @author Kenji hiranabe
 */
export declare class Vector2d extends Tuple2d {
    /**
     * Computes the dot product of the this vector and vector v1.
     * @param v1 the other vector
     */
    dot(v1: Vector2d): number;
    /**
     * Returns the length of this vector.
     * @return the length of this vector
     */
    length(): number;
    /**
     * Returns the squared length of this vector.
     * @return the squared length of this vector
     */
    lengthSquared(): number;
    /**
     * Normalizes this vector in place.d
     *
     * Sets the value of this vector to the normalization of vector v1.
     * @param v1 the un-normalized vector
     */
    normalize(v1?: Vector2d): void;
    /**
     * Returns the angle in radians between this vector and
     * the vector parameter; the return value is constrained to the
     * range [0,PI].
     * @param v1  the other vector
     * @return the angle in radians in the range [0,PI]
     */
    angle(v1: Vector2d): number;
}
