import { Matrix3d } from './Matrix3d';
import { Matrix4d } from './Matrix4d';
import { Tuple4d } from './Tuple4d';
import { AxisAngle4d } from './AxisAngle4d';
/**
 * A 4 element quaternion represented by double precision floating
 * point x,y,z,w coordinates.
 * @version specification 1.1, implementation $Revision: 1.8 $, $Date: 1999/10/05 07:03:50 $
 * @author Kenji hiranabe
 */
export declare class Quat4d extends Tuple4d {
    /**
     * Sets the value of this quaternion to the conjugate of quaternion q1.
     * @param q1 the source vector

     * Negate the value of of each of this quaternion's x,y,z coordinates
     * in place.
     */
    conjugate(q1?: Quat4d): void;
    /**
     * Sets the value of this quaternion to the quaternion product of
     * quaternions q1 and q2 (this = q1 * q2).
     * Note that this is safe for aliasing (e.g. this can be q1 or q2).
     * @param q1 the first quaternion
     * @param q2 the second quaternion

     * Sets the value of this quaternion to the quaternion product of
     * itself and q1 (this = this * q1).
     * @param q1 the other quaternion
     */
    mul(q1: Quat4d, q2?: Quat4d): void;
    /**
     * Multiplies quaternion q1 by the inverse of quaternion q2 and places
     * the value into this quaternion.  The value of both argument quaternions
     * is preservered (this = q1 * q2^-1).
     * @param q1 the left quaternion
     * @param q2 the right quaternion

     * Multiplies this quaternion by the inverse of quaternion q1 and places
     * the value into this quaternion.  The value of the argument quaternion
     * is preserved (this = this * q^-1).
     * @param q1 the other quaternion
     */
    mulInverse(q1: Quat4d, q2?: Quat4d): void;
    private norm();
    /**
     * Sets the value of this quaternion to quaternion inverse of quaternion q1.
     * @param q1 the quaternion to be inverted
     *
     * Sets the value of this quaternion to the quaternion inverse of itself.
     */
    inverse(q1?: Quat4d): void;
    /**
     * Sets the value of this quaternion to the normalized value
     * of quaternion q1.
     * @param q1 the quaternion to be normalized.
     *
     * Normalizes the value of this quaternion in place.
     */
    normalize(q1?: Quat4d): void;
    /**
     * Sets the value of this quaternion to the rotational component of
     * the passed matrix.
     * @param m1 the matrix4d
     */
    set_matrix4(m1: Matrix4d): void;
    /**
     * Sets the value of this quaternion to the rotational component of
     * the passed matrix.
     * @param m1 the matrix3d
     */
    set_matrix3(m1: Matrix3d): void;
    /**
     * Sets the value of this quaternion to the equivalent rotation of teh
     * AxisAngle argument.
     * @param a1 the axis-angle
     */
    set_axisAngle(a1: AxisAngle4d): void;
    /**
     * Performs a great circle interpolation between this quaternion and the
     * quaternion parameter and places the result into this quaternion.
     * @param q1 the other quaternion
     * @param alpha the alpha interpolation parameter
     */
    interpolate(q1: Quat4d, alpha: number): void;
    /**
     * Performs a great circle interpolation between quaternion q1 and
     * quaternion q2 and places the result into this quaternion.
     * @param q1 the first quaternion
     * @param q2 the second quaternion
     * @param alpha the alpha interpolation parameter
     */
    interpolate(q1: Quat4d, q2: Quat4d, alpha: number): void;
    private setFromMat(m00, m01, m02, m10, m11, m12, m20, m21, m22);
}
