import { Tuple3d } from './Tuple3d';
import { Tuple4d } from './Tuple4d';
/**
 * A 4 element point that is represented by double precision
 * floating point x,y,z,w coordinates.
 * @version specification 1.1, implementation $Revision: 1.10 $, $Date: 1999/10/05 07:03:50 $
 * @author Kenji hiranabe
 */
export declare class Point4d extends Tuple4d {
    /**
     * Sets the x,y,z components of this point to the corresponding
     * components of tuple t1. The w component of this point is set to 1.
     * @param t1 the tuple to be copied
     * @since Java3D 1.2
     */
    set_tuple3(t1: Tuple3d): void;
    /**
     * Computes the square of the distance between this point and point p1.
     * @param p1 the other point
     * @return the square of distance between this point and p1
     */
    distanceSquared(p1: Point4d): number;
    /**
     * Returns the distance between this point and point p1.
     * @param p1 the other point
     * @return the distance between this point and point p1.
     */
    distance(p1: Point4d): number;
    /**
     * Computes the L-1 (Manhattan) distance between this point and point p1.
     * The L-1 distance is equal to abs(x1-x2) + abs(y1-y2)
     * + abs(z1-z2) + abs(w1-w2).
     * @param p1 the other point
     * @return L-1 distance
     */
    distanceL1(p1: Point4d): number;
    /**
     * Computes the L-infinite distance between this point and point p1.
     * The L-infinite distance is equal to MAX[abs(x1-x2), abs(y1-y2), abs(z1-z2), abs(w1-w2)].
     * @param p1 the other point
     * @return L-infinite distance
     */
    distanceLinf(p1: Point4d): number;
    /**
     * Multiplies each of the x,y,z components of the Point4d parameter by 1/w,
     * places the projected values into this point, and places a 1 as the w
     * parameter of this point.
     * @param p1 the source Point4d, which is not modified
     */
    project(p1: Point4d): void;
}
