import { Tuple3d } from './Tuple3d';
import { Point4d } from './Point4d';
/**
 * A 3 element point that is represented by double precision
 * floating point x,y,z coordinates.
 * @version specification 1.1, implementation $Revision: 1.8 $, $Date: 1999/10/05 07:03:50 $
 * @author Kenji hiranabe
 */
export declare class Point3d extends Tuple3d {
    /**
     * Computes the square of the distance between this point and point p1.
     * @param p1 the other point
     * @return the square of distance between these two points as a float
     */
    distanceSquared(p1: Point3d): number;
    /**
     * Returns the distance between this point and point p1.
     * @param p1 the other point
     * @return the distance between these two points as a float
     */
    distance(p1: Point3d): number;
    /**
     * Computes the L-1 (Manhattan) distance between this point and point p1.
     * The L-1 distance is equal to abs(x1-x2) + abs(y1-y2).
     * @param p1 the other point
     */
    distanceL1(p1: Point3d): number;
    /**
     * Computes the L-infinite distance between this point and point p1.
     * The L-infinite distance is equal to MAX[abs(x1-x2), abs(y1-y2)].
     * @param p1 the other point
     */
    distanceLinf(p1: Point3d): number;
    /**
     * Multiplies each of the x,y,z components of the Point4f parameter
     * by 1/w and places the projected values into this point.
     * @param p1 the source Point4d, which is not modified
     */
    project(p1: Point4d): void;
}
