/*
   Copyright (C) 1997,1998,1999
   Kenji Hiranabe, Eiwa System Management, Inc.

   This program is free software.
   Implemented by Kenji Hiranabe(hiranabe@esm.co.jp),
   conforming to the Java(TM) 3D API specification by Sun Microsystems.

   Permission to use, copy, modify, distribute and sell this software
   and its documentation for any purpose is hereby granted without fee,
   provided that the above copyright notice appear in all copies and
   that both that copyright notice and this permission notice appear
   in supporting documentation. Kenji Hiranabe and Eiwa System Management,Inc.
   makes no representations about the suitability of this software for any
   purpose.  It is provided "AS IS" with NO WARRANTY.
*/
"use strict";
import { Tuple2d } from './Tuple2d';
/**
 * A 2 element point that is represented by double precision
 * doubleing point x,y coordinates.
 * @version specification 1.1, implementation $Revision: 1.5 $, $Date: 1999/10/05 07:03:50 $
 * @author Kenji hiranabe
 */
export class Point2d extends Tuple2d {
    /**
     * Computes the square of the distance between this point and point p1.
     * @param p1 the other point
     */
    distanceSquared(p1) {
        let dx = this.x - p1.x;
        let dy = this.y - p1.y;
        return dx * dx + dy * dy;
    }
    /**
     * Computes the distance between this point and point p1.
     * @param p1 the other point
     */
    distance(p1) {
        return Math.sqrt(this.distanceSquared(p1));
    }
    /**
     * Computes the L-1 (Manhattan) distance between this point and point p1.
     * The L-1 distance is equal to abs(x1-x2) + abs(y1-y2).
     * @param p1 the other point
     */
    distanceL1(p1) {
        return Math.abs(this.x - p1.x) + Math.abs(this.y - p1.y);
    }
    /**
     * Computes the L-infinite distance between this point and point p1.
     * The L-infinite distance is equal to MAX[abs(x1-x2), abs(y1-y2)].
     * @param p1 the other point
     */
    distanceLinf(p1) {
        return Math.max(Math.abs(this.x - p1.x), Math.abs(this.y - p1.y));
    }
}
//# sourceMappingURL=Point2d.js.map