import { Tuple2d } from './Tuple2d';
/**
 * A 2 element point that is represented by double precision
 * doubleing point x,y coordinates.
 * @version specification 1.1, implementation $Revision: 1.5 $, $Date: 1999/10/05 07:03:50 $
 * @author Kenji hiranabe
 */
export declare class Point2d extends Tuple2d {
    /**
     * Computes the square of the distance between this point and point p1.
     * @param p1 the other point
     */
    distanceSquared(p1: Point2d): number;
    /**
     * Computes the distance between this point and point p1.
     * @param p1 the other point
     */
    distance(p1: Point2d): number;
    /**
     * Computes the L-1 (Manhattan) distance between this point and point p1.
     * The L-1 distance is equal to abs(x1-x2) + abs(y1-y2).
     * @param p1 the other point
     */
    distanceL1(p1: Point2d): number;
    /**
     * Computes the L-infinite distance between this point and point p1.
     * The L-infinite distance is equal to MAX[abs(x1-x2), abs(y1-y2)].
     * @param p1 the other point
     */
    distanceLinf(p1: Point2d): number;
}
