(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var AxisAngle4d = (function () {
    function AxisAngle4d(p, y, z, angle) {
        _classCallCheck(this, AxisAngle4d);

        if (Array.isArray(p)) {
            this.set_array(p);
        } else if (typeof p === "object") {
            if (typeof y === "number") this.set_axis_angle(p, y);else this.set_axisAngle(p);
        } else if (typeof p === "number") {
            this.x = p;
            this.y = y;
            this.z = z;
            this.angle = angle;
        } else {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 1.0;
            this.angle = 0.0;
        }
    }

    

    AxisAngle4d.prototype.set_axis_angle = function set_axis_angle(axis, angle) {
        this.x = axis.x;
        this.y = axis.y;
        this.z = axis.z;
        this.angle = angle;
    };

    AxisAngle4d.prototype.set_xyz_angle = function set_xyz_angle(x, y, z, angle) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.angle = angle;
    };

    AxisAngle4d.prototype.set_array = function set_array(a) {
        this.x = a[0];
        this.y = a[1];
        this.z = a[2];
        this.angle = a[3];
    };

    AxisAngle4d.prototype.set_axisAngle = function set_axisAngle(a1) {
        this.x = a1.x;
        this.y = a1.y;
        this.z = a1.z;
        this.angle = a1.angle;
    };

    AxisAngle4d.prototype.get_array = function get_array(a) {
        a[0] = this.x;
        a[1] = this.y;
        a[2] = this.z;
        a[3] = this.angle;
    };

    AxisAngle4d.prototype.set_matrix4 = function set_matrix4(m1) {
        this.setFromMat(m1.m00, m1.m01, m1.m02, m1.m10, m1.m11, m1.m12, m1.m20, m1.m21, m1.m22);
    };

    AxisAngle4d.prototype.set_matrix3 = function set_matrix3(m1) {
        this.setFromMat(m1.m00, m1.m01, m1.m02, m1.m10, m1.m11, m1.m12, m1.m20, m1.m21, m1.m22);
    };

    AxisAngle4d.prototype.set_quat = function set_quat(q1) {
        this.setFromQuat(q1.x, q1.y, q1.z, q1.w);
    };

    AxisAngle4d.prototype.setFromMat = function setFromMat(m00, m01, m02, m10, m11, m12, m20, m21, m22) {
        var cos = (m00 + m11 + m22 - 1.0) * 0.5;
        this.x = m21 - m12;
        this.y = m02 - m20;
        this.z = m10 - m01;
        var sin = 0.5 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.angle = Math.atan2(sin, cos);
    };

    AxisAngle4d.prototype.setFromQuat = function setFromQuat(x, y, z, w) {
        var sin_a2 = Math.sqrt(x * x + y * y + z * z);
        this.angle = 2.0 * Math.atan2(sin_a2, w);
        this.x = x;
        this.y = y;
        this.z = z;
    };

    AxisAngle4d.prototype.toString = function toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.angle + ")";
    };

    AxisAngle4d.prototype.equals = function equals(a1) {
        return a1 && this.x === a1.x && this.y === a1.y && this.z === a1.z && this.angle === a1.angle;
    };

    AxisAngle4d.prototype.epsilonEquals = function epsilonEquals(a1, epsilon) {
        return Math.abs(a1.x - this.x) <= epsilon && Math.abs(a1.y - this.y) <= epsilon && Math.abs(a1.z - this.z) <= epsilon && Math.abs(a1.angle - this.angle) <= epsilon;
    };

    return AxisAngle4d;
})();

exports.AxisAngle4d = AxisAngle4d;

},{}],2:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _GVector = require('./GVector');

var _util = require('./util');

var GMatrix = (function () {
    function GMatrix(p1, nCol, matrix) {
        _classCallCheck(this, GMatrix);

        if (typeof p1 === "number") {
            var nRow = p1;
            if (nRow < 0) throw new Error(nRow + " < 0");
            if (nCol < 0) throw new Error(nCol + " < 0");
            this.nRow = nRow;
            this.nCol = nCol;
            this.elementData = new Array(nRow * nCol);
            if (matrix) {
                this.set_array(matrix);
            } else {
                this.setIdentity();
            }
        } else {
            var _matrix = p1;
            this.nRow = _matrix.nRow;
            this.nCol = _matrix.nCol;
            var newSize = this.nRow * nCol;
            this.elementData = new Array(newSize);
            _util.arraycopy(_matrix.elementData, 0, this.elementData, 0, newSize);
        }
    }

    

    GMatrix.prototype.mul = function mul(m1, m2) {
        if (!m2) {
            m2 = m1;
            m1 = this;
        }
        if (this.nRow !== m1.nRow) throw new Error("nRow:" + this.nRow + " != m1.nRow:" + m1.nRow);
        if (this.nCol !== m2.nCol) throw new Error("nCol:" + this.nCol + " != m2.nCol:" + m2.nCol);
        if (m1.nCol !== m2.nRow) throw new Error("m1.nCol:" + m1.nCol + " != m2.nRow:" + m2.nRow);
        var newData = new Array(this.nCol * this.nRow);
        for (var i = 0; i < this.nRow; i++) {
            for (var j = 0; j < this.nCol; j++) {
                var sum = 0.0;
                for (var k = 0; k < m1.nCol; k++) {
                    sum += m1.elementData[i * m1.nCol + k] * m2.elementData[k * m2.nCol + j];
                }newData[i * this.nCol + j] = sum;
            }
        }
        this.elementData = newData;
    };

    GMatrix.prototype.mul_vector_vector = function mul_vector_vector(v1, v2) {
        if (this.nRow < v1.getSize()) throw new Error("nRow:" + this.nRow + " < v1.getSize():" + v1.getSize());
        if (this.nCol < v2.getSize()) throw new Error("nCol:" + this.nCol + " < v2.getSize():" + v2.getSize());
        for (var i = 0; i < this.nRow; i++) {
            for (var j = 0; j < this.nCol; j++) {
                this.elementData[i * this.nCol + j] = v1.getElement(i) * v2.getElement(j);
            }
        }
    };

    GMatrix.prototype.add = function add(m1, m2) {
        if (m2) {
            if (this.nRow !== m1.nRow || this.nCol !== m1.nCol) throw new Error("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + m1.nRow + "x" + m1.nCol + ").");
            if (this.nRow !== m2.nRow || this.nCol !== m2.nCol) throw new Error("this:(" + this.nRow + "x" + this.nCol + ") != m2:(" + m2.nRow + "x" + m2.nCol + ").");
            for (var i = 0; i < this.nRow * this.nCol; i++) {
                this.elementData[i] = m1.elementData[i] + m2.elementData[i];
            }
        } else {
            if (this.nRow !== m1.nRow || this.nCol !== m1.nCol) throw new Error("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + m1.nRow + "x" + m1.nCol + ").");
            for (var i = 0; i < this.nRow * this.nCol; i++) {
                this.elementData[i] += m1.elementData[i];
            }
        }
    };

    GMatrix.prototype.sub = function sub(m1, m2) {
        if (m2) {
            if (this.nRow !== m1.nRow || this.nCol !== m1.nCol) throw new Error("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + m1.nRow + "x" + m1.nCol + ").");
            if (this.nRow !== m2.nRow || this.nCol !== m2.nCol) throw new Error("this:(" + this.nRow + "x" + this.nCol + ") != m2:(" + m2.nRow + "x" + m2.nCol + ").");
            for (var i = 0; i < this.nRow * this.nCol; i++) {
                this.elementData[i] = m1.elementData[i] - m2.elementData[i];
            }
        } else {
            if (this.nRow !== m1.nRow || this.nCol !== m1.nCol) throw new Error("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + m1.nRow + "x" + m1.nCol + ").");
            for (var i = 0; i < this.nRow * this.nCol; i++) {
                this.elementData[i] -= m1.elementData[i];
            }
        }
    };

    GMatrix.prototype.negate = function negate(m1) {
        if (m1) this.set(m1);
        for (var i = 0; i < this.nRow * this.nCol; i++) {
            this.elementData[i] = -this.elementData[i];
        }
    };

    GMatrix.prototype.setIdentity = function setIdentity() {
        this.setZero();
        var min = this.nRow < this.nCol ? this.nRow : this.nCol;
        for (var i = 0; i < min; i++) {
            this.elementData[i * this.nCol + i] = 1.0;
        }
    };

    GMatrix.prototype.setZero = function setZero() {
        for (var i = 0; i < this.nRow * this.nCol; i++) {
            this.elementData[i] = 0.0;
        }
    };

    GMatrix.prototype.identityMinus = function identityMinus() {
        this.negate();
        var min = this.nRow < this.nCol ? this.nRow : this.nCol;
        for (var i = 0; i < min; i++) {
            this.elementData[i * this.nCol + i] += 1.0;
        }
    };

    GMatrix.prototype.invert = function invert(m1) {
        if (m1) this.set(m1);
        if (this.nRow !== this.nCol) throw new Error("not a square matrix");
        var n = this.nRow;
        var LU = new GMatrix(n, n);
        var permutation = new _GVector.GVector(n);
        var column = new _GVector.GVector(n);
        var unit = new _GVector.GVector(n);
        this.LUD(LU, permutation);
        for (var j = 0; j < n; j++) {
            unit.zero();
            unit.setElement(j, 1.0);
            column.LUDBackSolve(LU, unit, permutation);
            this.setColumn(j, column);
        }
    };

    GMatrix.prototype.copySubMatrix = function copySubMatrix(rowSource, colSource, numRow, numCol, rowDest, colDest, target) {
        if (rowSource < 0 || colSource < 0 || rowDest < 0 || colDest < 0) throw new Error("rowSource,colSource,rowDest,colDest < 0.");else if (this.nRow < numRow + rowSource || this.nCol < numCol + colSource) throw new Error("Source GMatrix too small.");else if (target.nRow < numRow + rowDest || target.nCol < numCol + colDest) throw new Error("Target GMatrix too small.");
        for (var i = 0; i < numRow; i++) {
            for (var j = 0; j < numCol; j++) {
                target.elementData[(i + rowDest) * this.nCol + (j + colDest)] = this.elementData[(i + rowSource) * this.nCol + (j + colSource)];
            }
        }
    };

    GMatrix.prototype.setSize = function setSize(nRow, nCol) {
        if (nRow < 0 || nCol < 0) throw new Error("nRow or nCol < 0");
        var oldnRow = this.nRow;
        var oldnCol = this.nCol;
        var oldSize = this.nRow * this.nCol;
        this.nRow = nRow;
        this.nCol = nCol;
        var newSize = nRow * nCol;
        var oldData = this.elementData;
        if (oldnCol === nCol) {
            if (nRow <= oldnRow) return;
            this.elementData = new Array(newSize);
            _util.arraycopy(oldData, 0, this.elementData, 0, oldSize);
        } else {
            this.elementData = new Array(newSize);
            this.setZero();
            for (var i = 0; i < oldnRow; i++) {
                _util.arraycopy(oldData, i * oldnCol, this.elementData, i * nCol, oldnCol);
            }
        }
    };

    GMatrix.prototype.set_array = function set_array(matrix) {
        var size = this.nRow * this.nCol;
        _util.arraycopy(matrix, 0, this.elementData, 0, size);
    };

    GMatrix.prototype.set_matrix3 = function set_matrix3(m1) {
        this.elementData[0] = m1.m00;
        this.elementData[1] = m1.m01;
        this.elementData[2] = m1.m02;
        this.elementData[this.nCol] = m1.m10;
        this.elementData[this.nCol + 1] = m1.m11;
        this.elementData[this.nCol + 2] = m1.m12;
        this.elementData[2 * this.nCol] = m1.m20;
        this.elementData[2 * this.nCol + 1] = m1.m21;
        this.elementData[2 * this.nCol + 2] = m1.m22;
    };

    GMatrix.prototype.set_matrix4 = function set_matrix4(m1) {
        this.elementData[0] = m1.m00;
        this.elementData[1] = m1.m01;
        this.elementData[2] = m1.m02;
        this.elementData[3] = m1.m03;
        this.elementData[this.nCol] = m1.m10;
        this.elementData[this.nCol + 1] = m1.m11;
        this.elementData[this.nCol + 2] = m1.m12;
        this.elementData[this.nCol + 3] = m1.m13;
        this.elementData[2 * this.nCol] = m1.m20;
        this.elementData[2 * this.nCol + 1] = m1.m21;
        this.elementData[2 * this.nCol + 2] = m1.m22;
        this.elementData[2 * this.nCol + 3] = m1.m23;
        this.elementData[3 * this.nCol] = m1.m30;
        this.elementData[3 * this.nCol + 1] = m1.m31;
        this.elementData[3 * this.nCol + 2] = m1.m32;
        this.elementData[3 * this.nCol + 3] = m1.m33;
    };

    GMatrix.prototype.set = function set(m1) {
        if (m1.nRow < this.nRow || m1.nCol < this.nCol) throw new Error("m1 smaller than this matrix");
        _util.arraycopy(m1.elementData, 0, this.elementData, 0, this.nRow * this.nCol);
    };

    GMatrix.prototype.getNumRow = function getNumRow() {
        return this.nRow;
    };

    GMatrix.prototype.getNumCol = function getNumCol() {
        return this.nCol;
    };

    GMatrix.prototype.getElement = function getElement(row, column) {
        if (this.nRow <= row) throw new Error("row:" + row + " > matrix's nRow:" + this.nRow);
        if (row < 0) throw new Error("row:" + row + " < 0");
        if (this.nCol <= column) throw new Error("column:" + column + " > matrix's nCol:" + this.nCol);
        if (column < 0) throw new Error("column:" + column + " < 0");
        return this.elementData[row * this.nCol + column];
    };

    GMatrix.prototype.setElement = function setElement(row, column, value) {
        if (this.nRow <= row) throw new Error("row:" + row + " > matrix's nRow:" + this.nRow);
        if (row < 0) throw new Error("row:" + row + " < 0");
        if (this.nCol <= column) throw new Error("column:" + column + " > matrix's nCol:" + this.nCol);
        if (column < 0) throw new Error("column:" + column + " < 0");
        this.elementData[row * this.nCol + column] = value;
    };

    GMatrix.prototype.getRow_array = function getRow_array(row, array) {
        if (this.nRow <= row) throw new Error("row:" + row + " > matrix's nRow:" + this.nRow);
        if (row < 0) throw new Error("row:" + row + " < 0");
        if (array.length < this.nCol) throw new Error("array length:" + array.length + " smaller than matrix's nCol:" + this.nCol);
        _util.arraycopy(this.elementData, row * this.nCol, array, 0, this.nCol);
    };

    GMatrix.prototype.getRow = function getRow(row, vector) {
        if (this.nRow <= row) throw new Error("row:" + row + " > matrix's nRow:" + this.nRow);
        if (row < 0) throw new Error("row:" + row + " < 0");
        if (vector.getSize() < this.nCol) throw new Error("vector size:" + vector.getSize() + " smaller than matrix's nCol:" + this.nCol);
        for (var i = 0; i < this.nCol; i++) {
            vector.setElement(i, this.elementData[row * this.nCol + i]);
        }
    };

    GMatrix.prototype.getColumn_array = function getColumn_array(col, array) {
        if (this.nCol <= col) throw new Error("col:" + col + " > matrix's nCol:" + this.nCol);
        if (col < 0) throw new Error("col:" + col + " < 0");
        if (array.length < this.nRow) throw new Error("array.length:" + array.length + " < matrix's nRow=" + this.nRow);
        for (var i = 0; i < this.nRow; i++) {
            array[i] = this.elementData[i * this.nCol + col];
        }
    };

    GMatrix.prototype.getColumn = function getColumn(col, vector) {
        if (this.nCol <= col) throw new Error("col:" + col + " > matrix's nCol:" + this.nCol);
        if (col < 0) throw new Error("col:" + col + " < 0");
        if (vector.getSize() < this.nRow) throw new Error("vector size:" + vector.getSize() + " < matrix's nRow:" + this.nRow);
        for (var i = 0; i < this.nRow; i++) {
            vector.setElement(i, this.elementData[i * this.nCol + col]);
        }
    };

    GMatrix.prototype.get_matrix3 = function get_matrix3(m1) {
        m1.m00 = this.elementData[0];
        m1.m01 = this.elementData[1];
        m1.m02 = this.elementData[2];
        m1.m10 = this.elementData[this.nCol];
        m1.m11 = this.elementData[this.nCol + 1];
        m1.m12 = this.elementData[this.nCol + 2];
        m1.m20 = this.elementData[2 * this.nCol];
        m1.m21 = this.elementData[2 * this.nCol + 1];
        m1.m22 = this.elementData[2 * this.nCol + 2];
    };

    GMatrix.prototype.get_matrix4 = function get_matrix4(m1) {
        m1.m00 = this.elementData[0];
        m1.m01 = this.elementData[1];
        m1.m02 = this.elementData[2];
        m1.m03 = this.elementData[3];
        m1.m10 = this.elementData[this.nCol];
        m1.m11 = this.elementData[this.nCol + 1];
        m1.m12 = this.elementData[this.nCol + 2];
        m1.m13 = this.elementData[this.nCol + 3];
        m1.m20 = this.elementData[2 * this.nCol];
        m1.m21 = this.elementData[2 * this.nCol + 1];
        m1.m22 = this.elementData[2 * this.nCol + 2];
        m1.m23 = this.elementData[2 * this.nCol + 3];
        m1.m30 = this.elementData[3 * this.nCol];
        m1.m31 = this.elementData[3 * this.nCol + 1];
        m1.m32 = this.elementData[3 * this.nCol + 2];
        m1.m33 = this.elementData[3 * this.nCol + 3];
    };

    GMatrix.prototype.get = function get(m1) {
        if (m1.nRow < this.nRow || m1.nCol < this.nCol) throw new Error("m1 matrix is smaller than this matrix.");
        if (m1.nCol === this.nCol) {
            _util.arraycopy(this.elementData, 0, m1.elementData, 0, this.nRow * this.nCol);
        } else {
            for (var i = 0; i < this.nRow; i++) {
                _util.arraycopy(this.elementData, i * this.nCol, m1.elementData, i * m1.nCol, this.nCol);
            }
        }
    };

    GMatrix.prototype.setRow_array = function setRow_array(row, array) {
        if (this.nRow <= row) throw new Error("row:" + row + " > matrix's nRow:" + this.nRow);
        if (row < 0) throw new Error("row:" + row + " < 0");
        if (array.length < this.nCol) throw new Error("array length:" + array.length + " < matrix's nCol=" + this.nCol);
        _util.arraycopy(array, 0, this.elementData, row * this.nCol, this.nCol);
    };

    GMatrix.prototype.setRow = function setRow(row, vector) {
        if (this.nRow <= row) throw new Error("row:" + row + " > matrix's nRow:" + this.nRow);
        if (row < 0) throw new Error("row:" + row + " < 0");
        var vecSize = vector.getSize();
        if (vecSize < this.nCol) throw new Error("vector's size:" + vecSize + " < matrix's nCol=" + this.nCol);
        for (var i = 0; i < this.nCol; i++) {
            this.elementData[row * this.nCol + i] = vector.getElement(i);
        }
    };

    GMatrix.prototype.setColumn_array = function setColumn_array(col, array) {
        if (this.nCol <= col) throw new Error("col:" + col + " > matrix's nCol=" + this.nCol);
        if (col < 0) throw new Error("col:" + col + " < 0");
        if (array.length < this.nRow) throw new Error("array length:" + array.length + " < matrix's nRow:" + this.nRow);
        for (var i = 0; i < this.nRow; i++) {
            this.elementData[i * this.nCol + col] = array[i];
        }
    };

    GMatrix.prototype.setColumn = function setColumn(col, vector) {
        if (this.nCol <= col) throw new Error("col:" + col + " > matrix's nCol=" + this.nCol);
        if (col < 0) throw new Error("col:" + col + " < 0");
        var vecSize = vector.getSize();
        if (vecSize < this.nRow) throw new Error("vector size:" + vecSize + " < matrix's nRow=" + this.nRow);
        for (var i = 0; i < this.nRow; i++) {
            this.elementData[i * this.nCol + col] = vector.getElement(i);
        }
    };

    GMatrix.prototype.mulTransposeBoth = function mulTransposeBoth(m1, m2) {
        this.mul(m2, m1);
        this.transpose();
    };

    GMatrix.prototype.mulTransposeRight = function mulTransposeRight(m1, m2) {
        if (m1.nCol !== m2.nCol || this.nRow !== m1.nRow || this.nCol !== m2.nRow) throw new Error("matrices mismatch");
        for (var i = 0; i < this.nRow; i++) {
            for (var j = 0; j < this.nCol; j++) {
                var sum = 0.0;
                for (var k = 0; k < m1.nCol; k++) {
                    sum += m1.elementData[i * m1.nCol + k] * m2.elementData[j * m2.nCol + k];
                }this.elementData[i * this.nCol + j] = sum;
            }
        }
    };

    GMatrix.prototype.mulTransposeLeft = function mulTransposeLeft(m1, m2) {
        this.transpose(m1);
        this.mul(m2);
    };

    GMatrix.prototype.transpose = function transpose(m1) {
        if (m1) this.set(m1);
        for (var i = 0; i < this.nRow; i++) {
            for (var j = i + 1; j < this.nCol; j++) {
                var tmp = this.elementData[i * this.nCol + j];
                this.elementData[i * this.nCol + j] = this.elementData[j * this.nCol + i];
                this.elementData[j * this.nCol + i] = tmp;
            }
        }
    };

    GMatrix.prototype.toString = function toString() {
        var nl = "\n";
        var out = "[";
        out += nl;
        for (var i = 0; i < this.nRow; i++) {
            out += "  [";
            for (var j = 0; j < this.nCol; j++) {
                if (0 < j) out += "\t";
                out += this.elementData[i * this.nCol + j];
            }
            if (i + 1 < this.nRow) {
                out += "]";
                out += nl;
            } else {
                out += "] ]";
            }
        }
        return out.toString();
    };

    GMatrix.prototype.equals = function equals(m1) {
        if (!m1) return false;
        if (m1.nRow !== this.nRow) return false;
        if (m1.nCol !== this.nCol) return false;
        for (var i = 0; i < this.nRow; i++) {
            for (var j = 0; j < this.nCol; j++) {
                if (this.elementData[i * this.nCol + j] !== m1.elementData[i * this.nCol + j]) return false;
            }
        }return true;
    };

    GMatrix.prototype.epsilonEquals = function epsilonEquals(m1, epsilon) {
        if (m1.nRow !== this.nRow) return false;
        if (m1.nCol !== this.nCol) return false;
        for (var i = 0; i < this.nRow; i++) {
            for (var j = 0; j < this.nCol; j++) {
                if (epsilon < Math.abs(this.elementData[i * this.nCol + j] - m1.elementData[i * this.nCol + j])) return false;
            }
        }return true;
    };

    GMatrix.prototype.trace = function trace() {
        var min = this.nRow < this.nCol ? this.nRow : this.nCol;
        var trace = 0.0;
        for (var i = 0; i < min; i++) {
            trace += this.elementData[i * this.nCol + i];
        }return trace;
    };

    GMatrix.prototype.setScale = function setScale(scale) {
        this.setZero();
        var min = this.nRow < this.nCol ? this.nRow : this.nCol;
        for (var i = 0; i < min; i++) {
            this.elementData[i * this.nCol + i] = scale;
        }
    };

    GMatrix.prototype.setDiag = function setDiag(i, value) {
        this.elementData[i * this.nCol + i] = value;
    };

    GMatrix.prototype.getDiag = function getDiag(i) {
        return this.elementData[i * this.nCol + i];
    };

    GMatrix.prototype.dpythag = function dpythag(a, b) {
        var absa = Math.abs(a);
        var absb = Math.abs(b);
        if (absa > absb) {
            if (absa === 0.0) return 0.0;
            var term = absb / absa;
            if (Math.abs(term) <= Number.MIN_VALUE) return absa;
            return absa * Math.sqrt(1.0 + term * term);
        } else {
            if (absb === 0.0) return 0.0;
            var term = absa / absb;
            if (Math.abs(term) <= Number.MIN_VALUE) return absb;
            return absb * Math.sqrt(1.0 + term * term);
        }
    };

    GMatrix.prototype.SVD = function SVD(u, w, v) {
        if (u.nRow !== this.nRow || u.nCol !== this.nRow) throw new Error("The U Matrix invalid size");
        if (v.nRow !== this.nCol || v.nCol !== this.nCol) throw new Error("The V Matrix invalid size");
        if (w.nCol !== this.nCol || w.nRow !== this.nRow) throw new Error("The W Matrix invalid size");
        var m = this.nRow;
        var n = this.nCol;
        var imax = m > n ? m : n;
        var A = u.elementData;
        var V = v.elementData;
        var i = undefined;
        var its = undefined;
        var j = undefined;
        var jj = undefined;
        var k = undefined;
        var l = 0;
        var nm = 0;
        var anorm = undefined;
        var c = undefined;
        var f = undefined;
        var g = undefined;
        var h = undefined;
        var s = undefined;
        var scale = undefined;
        var x = undefined;
        var y = undefined;
        var z = undefined;
        var rv1 = new Array(n);
        this.get(u);
        for (i = m; i < imax; i++) for (j = 0; j < imax; j++) A[i * m + j] = 0.0;
        for (j = n; j < imax; j++) for (i = 0; i < imax; i++) A[i * m + j] = 0.0;
        w.setZero();
        g = scale = anorm = 0.0;
        for (i = 0; i < n; i++) {
            l = i + 1;
            rv1[i] = scale * g;
            g = s = scale = 0.0;
            if (i < m) {
                for (k = i; k < m; k++) scale += Math.abs(A[k * m + i]);
                if (scale !== 0.0) {
                    for (k = i; k < m; k++) {
                        A[k * m + i] /= scale;
                        s += A[k * m + i] * A[k * m + i];
                    }
                    f = A[i * m + i];
                    g = f < 0.0 ? Math.sqrt(s) : -Math.sqrt(s);
                    h = f * g - s;
                    A[i * m + i] = f - g;
                    for (j = l; j < n; j++) {
                        for (s = 0.0, k = i; k < m; k++) s += A[k * m + i] * A[k * m + j];
                        f = s / h;
                        for (k = i; k < m; k++) A[k * m + j] += f * A[k * m + i];
                    }
                    for (k = i; k < m; k++) A[k * m + i] *= scale;
                }
            }
            w.setDiag(i, scale * g);
            g = s = scale = 0.0;
            if (i < m && i !== n - 1) {
                for (k = l; k < n; k++) scale += Math.abs(A[i * m + k]);
                if (scale !== 0.0) {
                    for (k = l; k < n; k++) {
                        A[i * m + k] /= scale;
                        s += A[i * m + k] * A[i * m + k];
                    }
                    f = A[i * m + l];
                    g = f < 0.0 ? Math.sqrt(s) : -Math.sqrt(s);
                    h = f * g - s;
                    A[i * m + l] = f - g;
                    for (k = l; k < n; k++) rv1[k] = A[i * m + k] / h;
                    for (j = l; j < m; j++) {
                        for (s = 0.0, k = l; k < n; k++) s += A[j * m + k] * A[i * m + k];
                        for (k = l; k < n; k++) A[j * m + k] += s * rv1[k];
                    }
                    for (k = l; k < n; k++) A[i * m + k] *= scale;
                }
            }
            var a1 = Math.abs(w.getDiag(i)) + Math.abs(rv1[i]);
            if (a1 > anorm) anorm = a1;
        }
        for (i = n - 1; i >= 0; i--) {
            if (i < n - 1) {
                if (g !== 0.0) {
                    for (j = l; j < n; j++) V[j * n + i] = A[i * m + j] / A[i * m + l] / g;
                    for (j = l; j < n; j++) {
                        for (s = 0.0, k = l; k < n; k++) s += A[i * m + k] * V[k * n + j];
                        for (k = l; k < n; k++) V[k * n + j] += s * V[k * n + i];
                    }
                }
                for (j = l; j < n; j++) V[i * n + j] = V[j * n + i] = 0.0;
            }
            V[i * n + i] = 1.0;
            g = rv1[i];
            l = i;
        }
        var imin = m < n ? m : n;
        for (i = imin - 1; i >= 0; i--) {
            l = i + 1;
            g = w.getDiag(i);
            for (j = l; j < n; j++) A[i * m + j] = 0.0;
            if (g !== 0.0) {
                g = 1.0 / g;
                for (j = l; j < n; j++) {
                    for (s = 0.0, k = l; k < m; k++) s += A[k * m + i] * A[k * m + j];
                    f = s / A[i * m + i] * g;
                    for (k = i; k < m; k++) A[k * m + j] += f * A[k * m + i];
                }
                for (j = i; j < m; j++) A[j * m + i] *= g;
            } else for (j = i; j < m; j++) A[j * m + i] = 0.0;
            ++A[i * m + i];
        }
        for (k = n - 1; k >= 0; k--) {
            for (its = 1; its <= 30; its++) {
                var flag = true;
                for (l = k; l >= 0; l--) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm === anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w.getDiag(nm)) + anorm === anorm) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (i = l; i <= k; i++) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm === anorm) break;
                        g = w.getDiag(i);
                        h = this.dpythag(f, g);
                        w.setDiag(i, h);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (j = 0; j < m; j++) {
                            y = A[j * m + nm];
                            z = A[j * m + i];
                            A[j * m + nm] = y * c + z * s;
                            A[j * m + i] = z * c - y * s;
                        }
                    }
                }
                z = w.getDiag(k);
                if (l === k) {
                    if (z < 0.0) {
                        w.setDiag(k, -z);
                        for (j = 0; j < n; j++) V[j * n + k] = -V[j * n + k];
                    }
                    break;
                }
                if (its === 30) {
                    return 0;
                }
                x = w.getDiag(l);
                nm = k - 1;
                y = w.getDiag(nm);
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = this.dpythag(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + (f >= 0.0 ? Math.abs(g) : -Math.abs(g))) - h)) / x;
                c = s = 1.0;
                for (j = l; j <= nm; j++) {
                    i = j + 1;
                    g = rv1[i];
                    y = w.getDiag(i);
                    h = s * g;
                    g = c * g;
                    z = this.dpythag(f, h);
                    rv1[j] = z;
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < n; jj++) {
                        x = V[jj * n + j];
                        z = V[jj * n + i];
                        V[jj * n + j] = x * c + z * s;
                        V[jj * n + i] = z * c - x * s;
                    }
                    z = this.dpythag(f, h);
                    w.setDiag(j, z);
                    if (z !== 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < m; jj++) {
                        y = A[jj * m + j];
                        z = A[jj * m + i];
                        A[jj * m + j] = y * c + z * s;
                        A[jj * m + i] = z * c - y * s;
                    }
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w.setDiag(k, x);
            }
        }
        var rank = 0;
        for (i = 0; i < n; i++) if (w.getDiag(i) > 0.0) rank++;
        return rank;
    };

    GMatrix.prototype.swapRows = function swapRows(i, j) {
        for (var k = 0; k < this.nCol; k++) {
            var tmp = this.elementData[i * this.nCol + k];
            this.elementData[i * this.nCol + k] = this.elementData[j * this.nCol + k];
            this.elementData[j * this.nCol + k] = tmp;
        }
    };

    GMatrix.prototype.LUD = function LUD(LU, permutation) {
        if (this.nRow !== this.nCol) throw new Error("not a square matrix");
        var n = this.nRow;
        if (n !== LU.nRow) throw new Error("this.nRow:" + n + " != LU.nRow:" + LU.nRow);
        if (n !== LU.nCol) throw new Error("this.nCol:" + n + " != LU.nCol:" + LU.nCol);
        if (permutation.getSize() < n) throw new Error("permutation.size:" + permutation.getSize() + " < this.nCol:" + n);
        if (this !== LU) LU.set(this);
        var even = 1;
        var a = LU.elementData;
        for (var i = 0; i < n; i++) {
            permutation.setElement(i, i);
        }for (var j = 0; j < n; j++) {
            var big = undefined;
            var dum = undefined;
            var sum = undefined;
            var imax = undefined;
            for (var i = 0; i < j; i++) {
                sum = a[i * n + j];
                for (var k = 0; k < i; k++) {
                    if (a[i * n + k] !== 0.0 && a[k * n + j] !== 0.0) sum -= a[i * n + k] * a[k * n + j];
                }
                a[i * n + j] = sum;
            }
            big = 0.0;
            imax = j;
            for (var i = j; i < n; i++) {
                sum = a[i * n + j];
                for (var k = 0; k < j; k++) {
                    if (a[i * n + k] !== 0.0 && a[k * n + j] !== 0.0) sum -= a[i * n + k] * a[k * n + j];
                }
                a[i * n + j] = sum;
                dum = Math.abs(sum);
                if (dum >= big) {
                    big = dum;
                    imax = i;
                }
            }
            if (j !== imax) {
                LU.swapRows(imax, j);
                var tmp = permutation.getElement(imax);
                permutation.setElement(imax, permutation.getElement(j));
                permutation.setElement(j, tmp);
                even = -even;
            }
            if (j !== n - 1) {
                dum = 1.0 / a[j * n + j];
                for (var i = j + 1; i < n; i++) {
                    a[i * n + j] *= dum;
                }
            }
        }
        return even;
    };

    return GMatrix;
})();

exports.GMatrix = GMatrix;

},{"./GVector":3,"./util":17}],3:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _Tuple2d = require('./Tuple2d');

var _Tuple3d = require('./Tuple3d');

var _Tuple4d = require('./Tuple4d');

var _util = require('./util');

var GVector = (function () {
    function GVector(p1, p2) {
        _classCallCheck(this, GVector);

        var data = null;
        if (typeof p1 === "number") {
            this._setLength(p1);
        } else if (Array.isArray(p1)) {
            if (typeof p2 === "number") {
                this._setLength(p2);
            } else {
                this._setLength(p1.length);
            }
            data = p1;
        } else if (p1 instanceof GVector) {
            this._setLength(p1.elementCount);
            data = p1.elementData;
        } else if (p1 instanceof _Tuple2d.Tuple2d) {
            this._setLength(2);
            this.set_tuple2(p1);
        } else if (p1 instanceof _Tuple3d.Tuple3d) {
            this._setLength(3);
            this.set_tuple3(p1);
        } else if (p1 instanceof _Tuple4d.Tuple4d) {
            this._setLength(4);
            this.set_tuple4(p1);
        }
        if (data) {
            _util.arraycopy(data, 0, this.elementData, 0, this.elementCount);
        }
    }

    

    GVector.prototype._setLength = function _setLength(length) {
        this.elementCount = length;
        this.elementData = new Array(length);
    };

    GVector.prototype.norm = function norm() {
        return Math.sqrt(this.normSquared());
    };

    GVector.prototype.normSquared = function normSquared() {
        var s = 0.0;
        for (var i = 0; i < this.elementCount; i++) {
            s += this.elementData[i] * this.elementData[i];
        }
        return s;
    };

    GVector.prototype.normalize = function normalize(v1) {
        if (v1) this.set(v1);
        var len = this.norm();
        for (var i = 0; i < this.elementCount; i++) {
            this.elementData[i] /= len;
        }
    };

    GVector.prototype.scale = function scale(s, v1) {
        if (v1) this.set(v1);
        for (var i = 0; i < this.elementCount; i++) {
            this.elementData[i] *= s;
        }
    };

    GVector.prototype.scaleAdd = function scaleAdd(s, v1, v2) {
        var v1data = v1.elementData;
        var v2data = v2.elementData;
        if (this.elementCount !== v1.elementCount) throw new Error("this.size:" + this.elementCount + " != v1's size:" + v1.elementCount);
        if (this.elementCount !== v2.elementCount) throw new Error("this.size:" + this.elementCount + " != v2's size:" + v2.elementCount);
        for (var i = 0; i < this.elementCount; i++) {
            this.elementData[i] = s * v1data[i] + v2data[i];
        }
    };

    GVector.prototype.add = function add(vector1, vector2) {
        if (vector2) {
            this.set(vector1);
            vector1 = vector2;
        }
        var v1data = vector1.elementData;
        if (this.elementCount !== vector1.elementCount) throw new Error("this.size:" + this.elementCount + " != v2's size:" + vector1.elementCount);
        for (var i = 0; i < this.elementCount; i++) {
            this.elementData[i] += v1data[i];
        }
    };

    GVector.prototype.sub = function sub(vector1, vector2) {
        if (vector2) {
            this.set(vector1);
            vector1 = vector2;
        }
        var v1data = vector1.elementData;
        if (this.elementCount !== vector1.elementCount) throw new Error("this.size:" + this.elementCount + " != vector's size:" + vector1.elementCount);
        for (var i = 0; i < this.elementCount; i++) {
            this.elementData[i] -= v1data[i];
        }
    };

    GVector.prototype.mul_matrix_vector = function mul_matrix_vector(m1, v1) {
        var v1data = v1.elementData;
        var v1size = v1.elementCount;
        var nCol = m1.getNumCol();
        var nRow = m1.getNumRow();
        if (v1size !== nCol) throw new Error("v1.size:" + v1size + " != m1.nCol:" + nCol);
        if (this.elementCount !== nRow) throw new Error("this.size:" + this.elementCount + " != m1.nRow:" + nRow);
        for (var i = 0; i < this.elementCount; i++) {
            var sum = 0.0;
            for (var j = 0; j < nCol; j++) {
                sum += m1.getElement(i, j) * v1data[j];
            }
            this.elementData[i] = sum;
        }
    };

    GVector.prototype.mul_vector_matrix = function mul_vector_matrix(v1, m1) {
        var v1data = v1.elementData;
        var v1size = v1.elementCount;
        var nCol = m1.getNumCol();
        var nRow = m1.getNumRow();
        if (v1size !== nRow) throw new Error("v1.size:" + v1size + " != m1.nRow:" + nRow);
        if (this.elementCount !== nCol) throw new Error("this.size:" + this.elementCount + " != m1.nCol:" + nCol);
        for (var i = 0; i < this.elementCount; i++) {
            var sum = 0.0;
            for (var j = 0; j < nRow; j++) {
                sum += m1.getElement(j, i) * v1data[j];
            }
            this.elementData[i] = sum;
        }
    };

    GVector.prototype.negate = function negate() {
        for (var i = 0; i < this.elementCount; i++) {
            this.elementData[i] = -this.elementData[i];
        }
    };

    GVector.prototype.zero = function zero() {
        for (var i = 0; i < this.elementCount; i++) {
            this.elementData[i] = 0.0;
        }
    };

    GVector.prototype.setSize = function setSize(newSize) {
        if (newSize < 0) throw new Error("newSize:" + newSize + " < 0");
        if (this.elementCount < newSize) {
            var oldData = this.elementData;
            this.elementData = new Array(newSize);
            for (var i = 0; i < this.elementCount; i++) {
                _util.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
            }
        }
        this.elementCount = newSize;
    };

    GVector.prototype.set_array = function set_array(vector) {
        _util.arraycopy(vector, 0, this.elementData, 0, this.elementCount);
    };

    GVector.prototype.set = function set(vector) {
        _util.arraycopy(vector.elementData, 0, this.elementData, 0, this.elementCount);
    };

    GVector.prototype.set_tuple2 = function set_tuple2(tuple) {
        this.elementData[0] = tuple.x;
        this.elementData[1] = tuple.y;
    };

    GVector.prototype.set_tuple3 = function set_tuple3(tuple) {
        this.elementData[0] = tuple.x;
        this.elementData[1] = tuple.y;
        this.elementData[2] = tuple.z;
    };

    GVector.prototype.set_tuple4 = function set_tuple4(tuple) {
        this.elementData[0] = tuple.x;
        this.elementData[1] = tuple.y;
        this.elementData[2] = tuple.z;
        this.elementData[3] = tuple.w;
    };

    GVector.prototype.getSize = function getSize() {
        return this.elementCount;
    };

    GVector.prototype.getElement = function getElement(index) {
        if (index < 0 || index > this.elementCount) throw new Error("index:" + index + "must be in [0, " + (this.elementCount - 1) + "]");
        return this.elementData[index];
    };

    GVector.prototype.setElement = function setElement(index, value) {
        if (index < 0 || index > this.elementCount) throw new Error("index:" + index + " must be in [0, " + (this.elementCount - 1) + "]");
        this.elementData[index] = value;
    };

    GVector.prototype.toString = function toString() {
        var buf = "";
        buf += "(";
        for (var i = 0; i < this.elementCount - 1; i++) {
            buf += this.elementData[i];
            buf += ",";
        }
        buf += this.elementData[this.elementCount - 1];
        buf += ")";
        return buf;
    };

    GVector.prototype.equals = function equals(vector1) {
        if (!vector1) return false;
        if (this.elementCount !== vector1.elementCount) return false;
        var v1data = vector1.elementData;
        for (var i = 0; i < this.elementCount; i++) {
            if (this.elementData[i] !== v1data[i]) return false;
        }
        return true;
    };

    GVector.prototype.epsilonEquals = function epsilonEquals(v1, epsilon) {
        if (this.elementCount !== v1.elementCount) return false;
        var v1data = v1.elementData;
        for (var i = 0; i < this.elementCount; i++) {
            if (Math.abs(this.elementData[i] - v1data[i]) > epsilon) return false;
        }
        return true;
    };

    GVector.prototype.dot = function dot(v1) {
        var v1data = v1.elementData;
        if (this.elementCount !== v1.elementCount) throw new Error("this.size:" + this.elementCount + " != v1.size:" + v1.elementCount);
        var sum = 0.0;
        for (var i = 0; i < this.elementCount; ++i) {
            sum += this.elementData[i] * v1data[i];
        }return sum;
    };

    GVector.prototype.SVDBackSolve = function SVDBackSolve(U, W, V, b) {
        if (this.elementCount !== U.getNumRow() || this.elementCount !== U.getNumCol()) throw new Error("this.size:" + this.elementCount + " != U.nRow,nCol:" + U.getNumRow() + "," + U.getNumCol());
        if (this.elementCount !== W.getNumRow()) throw new Error("this.size:" + this.elementCount + " != W.nRow:" + W.getNumRow());
        if (b.elementCount !== W.getNumCol()) throw new Error("b.size:" + b.elementCount + " != W.nCol:" + W.getNumCol());
        if (b.elementCount !== V.getNumRow() || b.elementCount !== V.getNumCol()) throw new Error("b.size:" + this.elementCount + " != V.nRow,nCol:" + V.getNumRow() + "," + V.getNumCol());
        var m = U.getNumRow();
        var n = V.getNumRow();
        var tmp = new Array(n);
        for (var j = 0; j < n; j++) {
            var s = 0.0;
            var wj = W.getElement(j, j);
            if (wj !== 0.0) {
                for (var i = 0; i < m; i++) {
                    s += U.getElement(i, j) * b.elementData[i];
                }s /= wj;
            }
            tmp[j] = s;
        }
        for (var j = 0; j < n; j++) {
            var s = 0.0;
            for (var jj = 0; jj < n; jj++) {
                s += V.getElement(j, jj) * tmp[jj];
            }this.elementData[j] = s;
        }
    };

    GVector.prototype.LUDBackSolve = function LUDBackSolve(LU, b, permutation) {
        if (this.elementCount !== b.elementCount) throw new Error("this.size:" + this.elementCount + " != b.size:" + b.elementCount);
        if (this.elementCount !== LU.getNumRow()) throw new Error("this.size:" + this.elementCount + " != LU.nRow:" + LU.getNumRow());
        if (this.elementCount !== LU.getNumCol()) throw new Error("this.size:" + this.elementCount + " != LU.nCol:" + LU.getNumCol());
        var n = this.elementCount;
        var indx = permutation.elementData;
        var x = this.elementData;
        var bdata = b.elementData;
        for (var i = 0; i < n; i++) {
            x[i] = bdata[indx[i]];
        }
        var ii = -1;
        for (var i = 0; i < n; i++) {
            var sum = x[i];
            if (0 <= ii) {
                for (var j = ii; j <= i - 1; j++) {
                    sum -= LU.getElement(i, j) * x[j];
                }
            } else if (sum !== 0.0) {
                ii = i;
            }
            x[i] = sum;
        }
        for (var i = n - 1; i >= 0; i--) {
            var sum = x[i];
            for (var j = i + 1; j < n; j++) {
                sum -= LU.getElement(i, j) * x[j];
            }x[i] = sum / LU.getElement(i, i);
        }
    };

    GVector.prototype.angle = function angle(v1) {
        return Math.acos(this.dot(v1) / this.norm() / v1.norm());
    };

    GVector.prototype.interpolate = function interpolate(v1, p2, alpha) {
        if (typeof p2 === "number") {
            alpha = p2;
        } else {
            this.set(v1);
            v1 = p2;
        }
        var v1data = v1.elementData;
        if (this.elementCount !== v1.elementCount) throw new Error("this.size:" + this.elementCount + " != v1.size:" + v1.elementCount);
        var beta = 1.0 - alpha;
        for (var i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = beta * this.elementData[i] + alpha * v1data[i];
        }
    };

    return GVector;
})();

exports.GVector = GVector;

},{"./Tuple2d":10,"./Tuple3d":11,"./Tuple4d":12,"./util":17}],4:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Matrix3d = (function () {
    function Matrix3d(p1, m01, m02, m10, m11, m12, m20, m21, m22) {
        _classCallCheck(this, Matrix3d);

        if (arguments.length === 0) {
            this.setZero();
        } else {
            if (p1 instanceof Matrix3d) {
                this.set_matrix(p1);
            } else if (Array.isArray(p1)) {
                var v = p1;
                this.set_array(v);
            } else if (typeof p1 === "number") {
                this.setValues(p1, m01, m02, m10, m11, m12, m20, m21, m22);
            }
        }
    }

    

    Matrix3d.prototype.toString = function toString() {
        var nl = "\n";
        return "[" + nl + "  [" + this.m00 + "\t" + this.m01 + "\t" + this.m02 + "]" + nl + "  [" + this.m10 + "\t" + this.m11 + "\t" + this.m12 + "]" + nl + "  [" + this.m20 + "\t" + this.m21 + "\t" + this.m22 + "] ]";
    };

    Matrix3d.prototype.setIdentity = function setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    };

    Matrix3d.prototype.setScale = function setScale(scale) {
        this.SVD(this);
        this.m00 *= scale;
        this.m11 *= scale;
        this.m22 *= scale;
    };

    Matrix3d.prototype.setElement = function setElement(row, column, value) {
        if (row === 0) {
            if (column === 0) this.m00 = value;else if (column === 1) this.m01 = value;else if (column === 2) this.m02 = value;else throw new Error("col must be 0 to 2 and is " + column);
        } else if (row === 1) {
            if (column === 0) this.m10 = value;else if (column === 1) this.m11 = value;else if (column === 2) this.m12 = value;else throw new Error("col must be 0 to 2 and is " + column);
        } else if (row === 2) {
            if (column === 0) this.m20 = value;else if (column === 1) this.m21 = value;else if (column === 2) this.m22 = value;else throw new Error("col must be 0 to 2 and is " + column);
        } else throw new Error("row must be 0 to 2 and is " + row);
    };

    Matrix3d.prototype.getElement = function getElement(row, column) {
        if (row === 0) {
            if (column === 0) return this.m00;else if (column === 1) return this.m01;else if (column === 2) return this.m02;else throw new Error("col must be 0 to 2 and is " + column);
        } else if (row === 1) {
            if (column === 0) return this.m10;else if (column === 1) return this.m11;else if (column === 2) return this.m12;else throw new Error("col must be 0 to 2 and is " + column);
        } else if (row === 2) {
            if (column === 0) return this.m20;else if (column === 1) return this.m21;else if (column === 2) return this.m22;else throw new Error("col must be 0 to 2 and is " + column);
        } else throw new Error("row must be 0 to 2 and is " + row);
    };

    Matrix3d.prototype.setRow_xyz = function setRow_xyz(row, x, y, z) {
        if (row === 0) {
            this.m00 = x;
            this.m01 = y;
            this.m02 = z;
        } else if (row === 1) {
            this.m10 = x;
            this.m11 = y;
            this.m12 = z;
        } else if (row === 2) {
            this.m20 = x;
            this.m21 = y;
            this.m22 = z;
        } else {
            throw new Error("row must be 0 to 2 and is " + row);
        }
    };

    Matrix3d.prototype.setRow_vector = function setRow_vector(row, v) {
        if (row === 0) {
            this.m00 = v.x;
            this.m01 = v.y;
            this.m02 = v.z;
        } else if (row === 1) {
            this.m10 = v.x;
            this.m11 = v.y;
            this.m12 = v.z;
        } else if (row === 2) {
            this.m20 = v.x;
            this.m21 = v.y;
            this.m22 = v.z;
        } else {
            throw new Error("row must be 0 to 2 and is " + row);
        }
    };

    Matrix3d.prototype.setRow_array = function setRow_array(row, v) {
        if (row === 0) {
            this.m00 = v[0];
            this.m01 = v[1];
            this.m02 = v[2];
        } else if (row === 1) {
            this.m10 = v[0];
            this.m11 = v[1];
            this.m12 = v[2];
        } else if (row === 2) {
            this.m20 = v[0];
            this.m21 = v[1];
            this.m22 = v[2];
        } else {
            throw new Error("row must be 0 to 2 and is " + row);
        }
    };

    Matrix3d.prototype.getRow_array = function getRow_array(row, v) {
        if (row === 0) {
            v[0] = this.m00;
            v[1] = this.m01;
            v[2] = this.m02;
        } else if (row === 1) {
            v[0] = this.m10;
            v[1] = this.m11;
            v[2] = this.m12;
        } else if (row === 2) {
            v[0] = this.m20;
            v[1] = this.m21;
            v[2] = this.m22;
        } else {
            throw new Error("row must be 0 to 2 and is " + row);
        }
    };

    Matrix3d.prototype.getRow_vector = function getRow_vector(row, v) {
        if (row === 0) {
            v.x = this.m00;
            v.y = this.m01;
            v.z = this.m02;
        } else if (row === 1) {
            v.x = this.m10;
            v.y = this.m11;
            v.z = this.m12;
        } else if (row === 2) {
            v.x = this.m20;
            v.y = this.m21;
            v.z = this.m22;
        } else {
            throw new Error("row must be 0 to 2 and is " + row);
        }
    };

    Matrix3d.prototype.setColumn_xyz = function setColumn_xyz(column, x, y, z) {
        if (column === 0) {
            this.m00 = x;
            this.m10 = y;
            this.m20 = z;
        } else if (column === 1) {
            this.m01 = x;
            this.m11 = y;
            this.m21 = z;
        } else if (column === 2) {
            this.m02 = x;
            this.m12 = y;
            this.m22 = z;
        } else {
            throw new Error("col must be 0 to 2 and is " + column);
        }
    };

    Matrix3d.prototype.setColumn_vector = function setColumn_vector(column, v) {
        if (column === 0) {
            this.m00 = v.x;
            this.m10 = v.y;
            this.m20 = v.z;
        } else if (column === 1) {
            this.m01 = v.x;
            this.m11 = v.y;
            this.m21 = v.z;
        } else if (column === 2) {
            this.m02 = v.x;
            this.m12 = v.y;
            this.m22 = v.z;
        } else {
            throw new Error("col must be 0 to 2 and is " + column);
        }
    };

    Matrix3d.prototype.setColumn_array = function setColumn_array(column, v) {
        if (column === 0) {
            this.m00 = v[0];
            this.m10 = v[1];
            this.m20 = v[2];
        } else if (column === 1) {
            this.m01 = v[0];
            this.m11 = v[1];
            this.m21 = v[2];
        } else if (column === 2) {
            this.m02 = v[0];
            this.m12 = v[1];
            this.m22 = v[2];
        } else {
            throw new Error("col must be 0 to 2 and is " + column);
        }
    };

    Matrix3d.prototype.getColumn = function getColumn(column, v) {
        if (column === 0) {
            v.x = this.m00;
            v.y = this.m10;
            v.z = this.m20;
        } else if (column === 1) {
            v.x = this.m01;
            v.y = this.m11;
            v.z = this.m21;
        } else if (column === 2) {
            v.x = this.m02;
            v.y = this.m12;
            v.z = this.m22;
        } else {
            throw new Error("column must be 0 to 2 and is " + column);
        }
    };

    Matrix3d.prototype.getColumn_array = function getColumn_array(column, v) {
        if (column === 0) {
            v[0] = this.m00;
            v[1] = this.m10;
            v[2] = this.m20;
        } else if (column === 1) {
            v[0] = this.m01;
            v[1] = this.m11;
            v[2] = this.m21;
        } else if (column === 2) {
            v[0] = this.m02;
            v[1] = this.m12;
            v[2] = this.m22;
        } else {
            throw new Error("column must be 0 to 2 and is " + column);
        }
    };

    Matrix3d.prototype.getScale = function getScale() {
        return this.SVD(null);
    };

    Matrix3d.prototype.add_scalar = function add_scalar(scalar, m1) {
        if (m1) this.set_matrix(m1);
        this.m00 += scalar;
        this.m01 += scalar;
        this.m02 += scalar;
        this.m10 += scalar;
        this.m11 += scalar;
        this.m12 += scalar;
        this.m20 += scalar;
        this.m21 += scalar;
        this.m22 += scalar;
    };

    Matrix3d.prototype.add = function add(m1, m2) {
        if (m2) {
            this.setValues(m1.m00 + m2.m00, m1.m01 + m2.m01, m1.m02 + m2.m02, m1.m10 + m2.m10, m1.m11 + m2.m11, m1.m12 + m2.m12, m1.m20 + m2.m20, m1.m21 + m2.m21, m1.m22 + m2.m22);
        } else {
            this.m00 += m1.m00;
            this.m01 += m1.m01;
            this.m02 += m1.m02;
            this.m10 += m1.m10;
            this.m11 += m1.m11;
            this.m12 += m1.m12;
            this.m20 += m1.m20;
            this.m21 += m1.m21;
            this.m22 += m1.m22;
        }
    };

    Matrix3d.prototype.sub = function sub(m1, m2) {
        if (m2) {
            this.setValues(m1.m00 - m2.m00, m1.m01 - m2.m01, m1.m02 - m2.m02, m1.m10 - m2.m10, m1.m11 - m2.m11, m1.m12 - m2.m12, m1.m20 - m2.m20, m1.m21 - m2.m21, m1.m22 - m2.m22);
        } else {
            this.m00 -= m1.m00;
            this.m01 -= m1.m01;
            this.m02 -= m1.m02;
            this.m10 -= m1.m10;
            this.m11 -= m1.m11;
            this.m12 -= m1.m12;
            this.m20 -= m1.m20;
            this.m21 -= m1.m21;
            this.m22 -= m1.m22;
        }
    };

    Matrix3d.prototype.transpose = function transpose(m1) {
        if (m1) this.set_matrix(m1);
        var tmp = this.m01;
        this.m01 = this.m10;
        this.m10 = tmp;
        tmp = this.m02;
        this.m02 = this.m20;
        this.m20 = tmp;
        tmp = this.m12;
        this.m12 = this.m21;
        this.m21 = tmp;
    };

    Matrix3d.prototype.set_quat = function set_quat(q1) {
        this.setFromQuat(q1.x, q1.y, q1.z, q1.w);
    };

    Matrix3d.prototype.set_axisAngle = function set_axisAngle(a1) {
        this.setFromAxisAngle(a1.x, a1.y, a1.z, a1.angle);
    };

    Matrix3d.prototype.set_matrix = function set_matrix(m1) {
        this.m00 = m1.m00;
        this.m01 = m1.m01;
        this.m02 = m1.m02;
        this.m10 = m1.m10;
        this.m11 = m1.m11;
        this.m12 = m1.m12;
        this.m20 = m1.m20;
        this.m21 = m1.m21;
        this.m22 = m1.m22;
    };

    Matrix3d.prototype.set_array = function set_array(m) {
        this.m00 = m[0];
        this.m01 = m[1];
        this.m02 = m[2];
        this.m10 = m[3];
        this.m11 = m[4];
        this.m12 = m[5];
        this.m20 = m[6];
        this.m21 = m[7];
        this.m22 = m[8];
    };

    Matrix3d.prototype.invert = function invert(m1) {
        if (m1) this.set_matrix(m1);
        var s = this.determinant();
        if (s === 0.0) return;
        s = 1 / s;
        this.setValues(this.m11 * this.m22 - this.m12 * this.m21, this.m02 * this.m21 - this.m01 * this.m22, this.m01 * this.m12 - this.m02 * this.m11, this.m12 * this.m20 - this.m10 * this.m22, this.m00 * this.m22 - this.m02 * this.m20, this.m02 * this.m10 - this.m00 * this.m12, this.m10 * this.m21 - this.m11 * this.m20, this.m01 * this.m20 - this.m00 * this.m21, this.m00 * this.m11 - this.m01 * this.m10);
        this.mul_scalar(s);
    };

    Matrix3d.prototype.determinant = function determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m21 * this.m12) - this.m01 * (this.m10 * this.m22 - this.m20 * this.m12) + this.m02 * (this.m10 * this.m21 - this.m20 * this.m11);
    };

    Matrix3d.prototype.set_scale = function set_scale(scale) {
        this.m00 = scale;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = scale;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = scale;
    };

    Matrix3d.prototype.rotX = function rotX(angle) {
        var c = Math.cos(angle);
        var s = Math.sin(angle);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = c;
        this.m12 = -s;
        this.m20 = 0.0;
        this.m21 = s;
        this.m22 = c;
    };

    Matrix3d.prototype.rotY = function rotY(angle) {
        var c = Math.cos(angle);
        var s = Math.sin(angle);
        this.m00 = c;
        this.m01 = 0.0;
        this.m02 = s;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = -s;
        this.m21 = 0.0;
        this.m22 = c;
    };

    Matrix3d.prototype.rotZ = function rotZ(angle) {
        var c = Math.cos(angle);
        var s = Math.sin(angle);
        this.m00 = c;
        this.m01 = -s;
        this.m02 = 0.0;
        this.m10 = s;
        this.m11 = c;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    };

    Matrix3d.prototype.mul_scalar = function mul_scalar(scalar, m1) {
        if (m1) this.set_matrix(m1);
        this.m00 *= scalar;
        this.m01 *= scalar;
        this.m02 *= scalar;
        this.m10 *= scalar;
        this.m11 *= scalar;
        this.m12 *= scalar;
        this.m20 *= scalar;
        this.m21 *= scalar;
        this.m22 *= scalar;
    };

    Matrix3d.prototype.mul_matrix = function mul_matrix(m1, m2) {
        if (typeof m2 === "undefined") {
            m2 = m1;
            m1 = this;
        }
        this.setValues(m1.m00 * m2.m00 + m1.m01 * m2.m10 + m1.m02 * m2.m20, m1.m00 * m2.m01 + m1.m01 * m2.m11 + m1.m02 * m2.m21, m1.m00 * m2.m02 + m1.m01 * m2.m12 + m1.m02 * m2.m22, m1.m10 * m2.m00 + m1.m11 * m2.m10 + m1.m12 * m2.m20, m1.m10 * m2.m01 + m1.m11 * m2.m11 + m1.m12 * m2.m21, m1.m10 * m2.m02 + m1.m11 * m2.m12 + m1.m12 * m2.m22, m1.m20 * m2.m00 + m1.m21 * m2.m10 + m1.m22 * m2.m20, m1.m20 * m2.m01 + m1.m21 * m2.m11 + m1.m22 * m2.m21, m1.m20 * m2.m02 + m1.m21 * m2.m12 + m1.m22 * m2.m22);
    };

    Matrix3d.prototype.mulNormalize = function mulNormalize(m1, m2) {
        if (m2) {
            this.mul_matrix(m1, m2);
            this.SVD(this);
        } else {
            this.mul_matrix(m1);
            this.SVD(this);
        }
    };

    Matrix3d.prototype.mulTransposeBoth = function mulTransposeBoth(m1, m2) {
        this.mul_matrix(m2, m1);
        this.transpose();
    };

    Matrix3d.prototype.mulTransposeRight = function mulTransposeRight(m1, m2) {
        this.setValues(m1.m00 * m2.m00 + m1.m01 * m2.m01 + m1.m02 * m2.m02, m1.m00 * m2.m10 + m1.m01 * m2.m11 + m1.m02 * m2.m12, m1.m00 * m2.m20 + m1.m01 * m2.m21 + m1.m02 * m2.m22, m1.m10 * m2.m00 + m1.m11 * m2.m01 + m1.m12 * m2.m02, m1.m10 * m2.m10 + m1.m11 * m2.m11 + m1.m12 * m2.m12, m1.m10 * m2.m20 + m1.m11 * m2.m21 + m1.m12 * m2.m22, m1.m20 * m2.m00 + m1.m21 * m2.m01 + m1.m22 * m2.m02, m1.m20 * m2.m10 + m1.m21 * m2.m11 + m1.m22 * m2.m12, m1.m20 * m2.m20 + m1.m21 * m2.m21 + m1.m22 * m2.m22);
    };

    Matrix3d.prototype.mulTransposeLeft = function mulTransposeLeft(m1, m2) {
        this.setValues(m1.m00 * m2.m00 + m1.m10 * m2.m10 + m1.m20 * m2.m20, m1.m00 * m2.m01 + m1.m10 * m2.m11 + m1.m20 * m2.m21, m1.m00 * m2.m02 + m1.m10 * m2.m12 + m1.m20 * m2.m22, m1.m01 * m2.m00 + m1.m11 * m2.m10 + m1.m21 * m2.m20, m1.m01 * m2.m01 + m1.m11 * m2.m11 + m1.m21 * m2.m21, m1.m01 * m2.m02 + m1.m11 * m2.m12 + m1.m21 * m2.m22, m1.m02 * m2.m00 + m1.m12 * m2.m10 + m1.m22 * m2.m20, m1.m02 * m2.m01 + m1.m12 * m2.m11 + m1.m22 * m2.m21, m1.m02 * m2.m02 + m1.m12 * m2.m12 + m1.m22 * m2.m22);
    };

    Matrix3d.prototype.normalize = function normalize(m1) {
        if (m1) this.set_matrix(m1);
        this.SVD(this);
    };

    Matrix3d.prototype.normalizeCP = function normalizeCP(m1) {
        if (m1) this.set_matrix(m1);
        var s = Math.pow(Math.abs(this.determinant()), -1.0 / 3.0);
        this.mul_scalar(s);
    };

    Matrix3d.prototype.equals = function equals(m1) {
        return m1 && this.m00 === m1.m00 && this.m01 === m1.m01 && this.m02 === m1.m02 && this.m10 === m1.m10 && this.m11 === m1.m11 && this.m12 === m1.m12 && this.m20 === m1.m20 && this.m21 === m1.m21 && this.m22 === m1.m22;
    };

    Matrix3d.prototype.epsilonEquals = function epsilonEquals(m1, epsilon) {
        return Math.abs(this.m00 - m1.m00) <= epsilon && Math.abs(this.m01 - m1.m01) <= epsilon && Math.abs(this.m02 - m1.m02) <= epsilon && Math.abs(this.m10 - m1.m10) <= epsilon && Math.abs(this.m11 - m1.m11) <= epsilon && Math.abs(this.m12 - m1.m12) <= epsilon && Math.abs(this.m20 - m1.m20) <= epsilon && Math.abs(this.m21 - m1.m21) <= epsilon && Math.abs(this.m22 - m1.m22) <= epsilon;
    };

    Matrix3d.prototype.setZero = function setZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
    };

    Matrix3d.prototype.negate = function negate(m1) {
        if (m1) this.set_matrix(m1);
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
    };

    Matrix3d.prototype.transform = function transform(t, result) {
        if (!result) result = t;
        result.set_xyz(this.m00 * t.x + this.m01 * t.y + this.m02 * t.z, this.m10 * t.x + this.m11 * t.y + this.m12 * t.z, this.m20 * t.x + this.m21 * t.y + this.m22 * t.z);
    };

    Matrix3d.prototype.setValues = function setValues(m00, m01, m02, m10, m11, m12, m20, m21, m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    };

    Matrix3d.prototype.SVD = function SVD(rot) {
        var s = Math.sqrt((this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) / 3.0);
        if (rot) {
            var n = 1 / Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
            rot.m00 = this.m00 * n;
            rot.m10 = this.m10 * n;
            rot.m20 = this.m20 * n;
            n = 1 / Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
            rot.m01 = this.m01 * n;
            rot.m11 = this.m11 * n;
            rot.m21 = this.m21 * n;
            n = 1 / Math.sqrt(this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22);
            rot.m02 = this.m02 * n;
            rot.m12 = this.m12 * n;
            rot.m22 = this.m22 * n;
        }
        return s;
    };

    Matrix3d.prototype.setFromQuat = function setFromQuat(x, y, z, w) {
        var n = x * x + y * y + z * z + w * w;
        var s = n > 0.0 ? 2.0 / n : 0.0;
        var xs = x * s;
        var ys = y * s;
        var zs = z * s;
        var wx = w * xs;
        var wy = w * ys;
        var wz = w * zs;
        var xx = x * xs;
        var xy = x * ys;
        var xz = x * zs;
        var yy = y * ys;
        var yz = y * zs;
        var zz = z * zs;
        this.m00 = 1.0 - (yy + zz);
        this.m01 = xy - wz;
        this.m02 = xz + wy;
        this.m10 = xy + wz;
        this.m11 = 1.0 - (xx + zz);
        this.m12 = yz - wx;
        this.m20 = xz - wy;
        this.m21 = yz + wx;
        this.m22 = 1.0 - (xx + yy);
    };

    Matrix3d.prototype.setFromAxisAngle = function setFromAxisAngle(x, y, z, angle) {
        var n = Math.sqrt(x * x + y * y + z * z);
        n = 1 / n;
        x *= n;
        y *= n;
        z *= n;
        var c = Math.cos(angle);
        var s = Math.sin(angle);
        var omc = 1.0 - c;
        this.m00 = c + x * x * omc;
        this.m11 = c + y * y * omc;
        this.m22 = c + z * z * omc;
        var tmp1 = x * y * omc;
        var tmp2 = z * s;
        this.m01 = tmp1 - tmp2;
        this.m10 = tmp1 + tmp2;
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.m02 = tmp1 + tmp2;
        this.m20 = tmp1 - tmp2;
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.m12 = tmp1 - tmp2;
        this.m21 = tmp1 + tmp2;
    };

    return Matrix3d;
})();

exports.Matrix3d = Matrix3d;

},{}],5:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _Matrix3d = require('./Matrix3d');

var _Quat4d = require('./Quat4d');

var Matrix4d = (function () {
    function Matrix4d(p1, p2, p3, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
        _classCallCheck(this, Matrix4d);

        if (arguments.length === 0) {
            this.setZero();
        } else if (p1 instanceof _Matrix3d.Matrix3d) {
            this.set_rotaionTranslationScale(p1, p2, p3);
        } else if (p1 instanceof Matrix4d) {
            this.set_matrix4(p1);
        } else if (p1 instanceof _Quat4d.Quat4d) {
            this.set_quat(p1, p2, p3);
        } else if (Array.isArray(p1)) {
            this.set_array(p1);
        } else if (arguments.length === 16) {
            this.set(p1, p2, p3, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
        }
    }

    

    Matrix4d.prototype.toString = function toString() {
        var nl = "\n";
        return "[" + nl + "  [" + this.m00 + "\t" + this.m01 + "\t" + this.m02 + "\t" + this.m03 + "]" + nl + "  [" + this.m10 + "\t" + this.m11 + "\t" + this.m12 + "\t" + this.m13 + "]" + nl + "  [" + this.m20 + "\t" + this.m21 + "\t" + this.m22 + "\t" + this.m23 + "]" + nl + "  [" + this.m30 + "\t" + this.m31 + "\t" + this.m32 + "\t" + this.m33 + "] ]";
    };

    Matrix4d.prototype.setIdentity = function setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    };

    Matrix4d.prototype.setElement = function setElement(row, column, value) {
        if (row === 0) {
            if (column === 0) this.m00 = value;else if (column === 1) this.m01 = value;else if (column === 2) this.m02 = value;else if (column === 3) this.m03 = value;else throw new Error("column must be 0 to 3 and is " + column);
        } else if (row === 1) {
            if (column === 0) this.m10 = value;else if (column === 1) this.m11 = value;else if (column === 2) this.m12 = value;else if (column === 3) this.m13 = value;else throw new Error("column must be 0 to 3 and is " + column);
        } else if (row === 2) {
            if (column === 0) this.m20 = value;else if (column === 1) this.m21 = value;else if (column === 2) this.m22 = value;else if (column === 3) this.m23 = value;else throw new Error("column must be 0 to 3 and is " + column);
        } else if (row === 3) {
            if (column === 0) this.m30 = value;else if (column === 1) this.m31 = value;else if (column === 2) this.m32 = value;else if (column === 3) this.m33 = value;else throw new Error("column must be 0 to 3 and is " + column);
        } else throw new Error("row must be 0 to 2 and is " + row);
    };

    Matrix4d.prototype.getElement = function getElement(row, column) {
        if (row === 0) {
            if (column === 0) return this.m00;else if (column === 1) return this.m01;else if (column === 2) return this.m02;else if (column === 3) return this.m03;else throw new Error("column must be 0 to 3 and is " + column);
        } else if (row === 1) {
            if (column === 0) return this.m10;else if (column === 1) return this.m11;else if (column === 2) return this.m12;else if (column === 3) return this.m13;else throw new Error("column must be 0 to 3 and is " + column);
        } else if (row === 2) {
            if (column === 0) return this.m20;else if (column === 1) return this.m21;else if (column === 2) return this.m22;else if (column === 3) return this.m23;else throw new Error("column must be 0 to 3 and is " + column);
        } else if (row === 3) {
            if (column === 0) return this.m30;else if (column === 1) return this.m31;else if (column === 2) return this.m32;else if (column === 3) return this.m33;else throw new Error("column must be 0 to 3 and is " + column);
        } else throw new Error("row must be 0 to 3 and is " + row);
    };

    Matrix4d.prototype.get_matrix3 = function get_matrix3(m1) {
        this.SVD(m1, null);
    };

    Matrix4d.prototype.get_matrix3_vector = function get_matrix3_vector(m1, t1) {
        this.get_translation(t1);
        return this.SVD(m1, null);
    };

    Matrix4d.prototype.get_quat = function get_quat(q1) {
        q1.set_matrix4(this);
        q1.normalize();
    };

    Matrix4d.prototype.get_translation = function get_translation(trans) {
        trans.x = this.m03;
        trans.y = this.m13;
        trans.z = this.m23;
    };

    Matrix4d.prototype.getRotationScale = function getRotationScale(m1) {
        m1.m00 = this.m00;
        m1.m01 = this.m01;
        m1.m02 = this.m02;
        m1.m10 = this.m10;
        m1.m11 = this.m11;
        m1.m12 = this.m12;
        m1.m20 = this.m20;
        m1.m21 = this.m21;
        m1.m22 = this.m22;
    };

    Matrix4d.prototype.getScale = function getScale() {
        return this._SVD(null);
    };

    Matrix4d.prototype.setRotationScale = function setRotationScale(m1) {
        this.m00 = m1.m00;
        this.m01 = m1.m01;
        this.m02 = m1.m02;
        this.m10 = m1.m10;
        this.m11 = m1.m11;
        this.m12 = m1.m12;
        this.m20 = m1.m20;
        this.m21 = m1.m21;
        this.m22 = m1.m22;
    };

    Matrix4d.prototype.setScale = function setScale(scale) {
        this.SVD(null, this);
        this.mulRotationScale(scale);
    };

    Matrix4d.prototype.setRow_xyzw = function setRow_xyzw(row, x, y, z, w) {
        if (row === 0) {
            this.m00 = x;
            this.m01 = y;
            this.m02 = z;
            this.m03 = w;
        } else if (row === 1) {
            this.m10 = x;
            this.m11 = y;
            this.m12 = z;
            this.m13 = w;
        } else if (row === 2) {
            this.m20 = x;
            this.m21 = y;
            this.m22 = z;
            this.m23 = w;
        } else if (row === 3) {
            this.m30 = x;
            this.m31 = y;
            this.m32 = z;
            this.m33 = w;
        } else {
            throw new Error("row must be 0 to 3 and is " + row);
        }
    };

    Matrix4d.prototype.setRow_vector = function setRow_vector(row, v) {
        if (row === 0) {
            this.m00 = v.x;
            this.m01 = v.y;
            this.m02 = v.z;
            this.m03 = v.w;
        } else if (row === 1) {
            this.m10 = v.x;
            this.m11 = v.y;
            this.m12 = v.z;
            this.m13 = v.w;
        } else if (row === 2) {
            this.m20 = v.x;
            this.m21 = v.y;
            this.m22 = v.z;
            this.m23 = v.w;
        } else if (row === 3) {
            this.m30 = v.x;
            this.m31 = v.y;
            this.m32 = v.z;
            this.m33 = v.w;
        } else {
            throw new Error("row must be 0 to 3 and is " + row);
        }
    };

    Matrix4d.prototype.setRow_array = function setRow_array(row, v) {
        if (row === 0) {
            this.m00 = v[0];
            this.m01 = v[1];
            this.m02 = v[2];
            this.m03 = v[3];
        } else if (row === 1) {
            this.m10 = v[0];
            this.m11 = v[1];
            this.m12 = v[2];
            this.m13 = v[3];
        } else if (row === 2) {
            this.m20 = v[0];
            this.m21 = v[1];
            this.m22 = v[2];
            this.m23 = v[3];
        } else if (row === 3) {
            this.m30 = v[0];
            this.m31 = v[1];
            this.m32 = v[2];
            this.m33 = v[3];
        } else {
            throw new Error("row must be 0 to 3 and is " + row);
        }
    };

    Matrix4d.prototype.getRow_vector = function getRow_vector(row, v) {
        if (row === 0) {
            v.x = this.m00;
            v.y = this.m01;
            v.z = this.m02;
            v.w = this.m03;
        } else if (row === 1) {
            v.x = this.m10;
            v.y = this.m11;
            v.z = this.m12;
            v.w = this.m13;
        } else if (row === 2) {
            v.x = this.m20;
            v.y = this.m21;
            v.z = this.m22;
            v.w = this.m23;
        } else if (row === 3) {
            v.x = this.m30;
            v.y = this.m31;
            v.z = this.m32;
            v.w = this.m33;
        } else {
            throw new Error("row must be 0 to 3 and is " + row);
        }
    };

    Matrix4d.prototype.getRow_array = function getRow_array(row, v) {
        if (row === 0) {
            v[0] = this.m00;
            v[1] = this.m01;
            v[2] = this.m02;
            v[3] = this.m03;
        } else if (row === 1) {
            v[0] = this.m10;
            v[1] = this.m11;
            v[2] = this.m12;
            v[3] = this.m13;
        } else if (row === 2) {
            v[0] = this.m20;
            v[1] = this.m21;
            v[2] = this.m22;
            v[3] = this.m23;
        } else if (row === 3) {
            v[0] = this.m30;
            v[1] = this.m31;
            v[2] = this.m32;
            v[3] = this.m33;
        } else {
            throw new Error("row must be 0 to 3 and is " + row);
        }
    };

    Matrix4d.prototype.setColumn_xyzw = function setColumn_xyzw(column, x, y, z, w) {
        if (column === 0) {
            this.m00 = x;
            this.m10 = y;
            this.m20 = z;
            this.m30 = w;
        } else if (column === 1) {
            this.m01 = x;
            this.m11 = y;
            this.m21 = z;
            this.m31 = w;
        } else if (column === 2) {
            this.m02 = x;
            this.m12 = y;
            this.m22 = z;
            this.m32 = w;
        } else if (column === 3) {
            this.m03 = x;
            this.m13 = y;
            this.m23 = z;
            this.m33 = w;
        } else {
            throw new Error("column must be 0 to 3 and is " + column);
        }
    };

    Matrix4d.prototype.setColumn_vector = function setColumn_vector(column, v) {
        if (column === 0) {
            this.m00 = v.x;
            this.m10 = v.y;
            this.m20 = v.z;
            this.m30 = v.w;
        } else if (column === 1) {
            this.m01 = v.x;
            this.m11 = v.y;
            this.m21 = v.z;
            this.m31 = v.w;
        } else if (column === 2) {
            this.m02 = v.x;
            this.m12 = v.y;
            this.m22 = v.z;
            this.m32 = v.w;
        } else if (column === 3) {
            this.m03 = v.x;
            this.m13 = v.y;
            this.m23 = v.z;
            this.m33 = v.w;
        } else {
            throw new Error("column must be 0 to 3 and is " + column);
        }
    };

    Matrix4d.prototype.setColumn_array = function setColumn_array(column, v) {
        if (column === 0) {
            this.m00 = v[0];
            this.m10 = v[1];
            this.m20 = v[2];
            this.m30 = v[3];
        } else if (column === 1) {
            this.m01 = v[0];
            this.m11 = v[1];
            this.m21 = v[2];
            this.m31 = v[3];
        } else if (column === 2) {
            this.m02 = v[0];
            this.m12 = v[1];
            this.m22 = v[2];
            this.m32 = v[3];
        } else if (column === 3) {
            this.m03 = v[0];
            this.m13 = v[1];
            this.m23 = v[2];
            this.m33 = v[3];
        } else {
            throw new Error("column must be 0 to 3 and is " + column);
        }
    };

    Matrix4d.prototype.getColumn_vector = function getColumn_vector(column, v) {
        if (column === 0) {
            v.x = this.m00;
            v.y = this.m10;
            v.z = this.m20;
            v.w = this.m30;
        } else if (column === 1) {
            v.x = this.m01;
            v.y = this.m11;
            v.z = this.m21;
            v.w = this.m31;
        } else if (column === 2) {
            v.x = this.m02;
            v.y = this.m12;
            v.z = this.m22;
            v.w = this.m32;
        } else if (column === 3) {
            v.x = this.m03;
            v.y = this.m13;
            v.z = this.m23;
            v.w = this.m33;
        } else {
            throw new Error("column must be 0 to 3 and is " + column);
        }
    };

    Matrix4d.prototype.getColumn_array = function getColumn_array(column, v) {
        if (column === 0) {
            v[0] = this.m00;
            v[1] = this.m10;
            v[2] = this.m20;
            v[3] = this.m30;
        } else if (column === 1) {
            v[0] = this.m01;
            v[1] = this.m11;
            v[2] = this.m21;
            v[3] = this.m31;
        } else if (column === 2) {
            v[0] = this.m02;
            v[1] = this.m12;
            v[2] = this.m22;
            v[3] = this.m32;
        } else if (column === 3) {
            v[0] = this.m03;
            v[1] = this.m13;
            v[2] = this.m23;
            v[3] = this.m33;
        } else {
            throw new Error("column must be 0 to 3 and is " + column);
        }
    };

    Matrix4d.prototype.add_scalar = function add_scalar(scalar, m1) {
        if (m1) this.set_matrix4(m1);
        this.m00 += scalar;
        this.m01 += scalar;
        this.m02 += scalar;
        this.m03 += scalar;
        this.m10 += scalar;
        this.m11 += scalar;
        this.m12 += scalar;
        this.m13 += scalar;
        this.m20 += scalar;
        this.m21 += scalar;
        this.m22 += scalar;
        this.m23 += scalar;
        this.m30 += scalar;
        this.m31 += scalar;
        this.m32 += scalar;
        this.m33 += scalar;
    };

    Matrix4d.prototype.add_matrix = function add_matrix(m1, m2) {
        if (m2) {
            this.set(m1.m00 + m2.m00, m1.m01 + m2.m01, m1.m02 + m2.m02, m1.m03 + m2.m03, m1.m10 + m2.m10, m1.m11 + m2.m11, m1.m12 + m2.m12, m1.m13 + m2.m13, m1.m20 + m2.m20, m1.m21 + m2.m21, m1.m22 + m2.m22, m1.m23 + m2.m23, m1.m30 + m2.m30, m1.m31 + m2.m31, m1.m32 + m2.m32, m1.m33 + m2.m33);
        } else {
            this.m00 += m1.m00;
            this.m01 += m1.m01;
            this.m02 += m1.m02;
            this.m03 += m1.m03;
            this.m10 += m1.m10;
            this.m11 += m1.m11;
            this.m12 += m1.m12;
            this.m13 += m1.m13;
            this.m20 += m1.m20;
            this.m21 += m1.m21;
            this.m22 += m1.m22;
            this.m23 += m1.m23;
            this.m30 += m1.m30;
            this.m31 += m1.m31;
            this.m32 += m1.m32;
            this.m33 += m1.m33;
        }
    };

    Matrix4d.prototype.sub = function sub(m1, m2) {
        if (m2) {
            this.set(m1.m00 - m2.m00, m1.m01 - m2.m01, m1.m02 - m2.m02, m1.m03 - m2.m03, m1.m10 - m2.m10, m1.m11 - m2.m11, m1.m12 - m2.m12, m1.m13 - m2.m13, m1.m20 - m2.m20, m1.m21 - m2.m21, m1.m22 - m2.m22, m1.m23 - m2.m23, m1.m30 - m2.m30, m1.m31 - m2.m31, m1.m32 - m2.m32, m1.m33 - m2.m33);
        } else {
            this.m00 -= m1.m00;
            this.m01 -= m1.m01;
            this.m02 -= m1.m02;
            this.m03 -= m1.m03;
            this.m10 -= m1.m10;
            this.m11 -= m1.m11;
            this.m12 -= m1.m12;
            this.m13 -= m1.m13;
            this.m20 -= m1.m20;
            this.m21 -= m1.m21;
            this.m22 -= m1.m22;
            this.m23 -= m1.m23;
            this.m30 -= m1.m30;
            this.m31 -= m1.m31;
            this.m32 -= m1.m32;
            this.m33 -= m1.m33;
        }
    };

    Matrix4d.prototype.transpose = function transpose(m1) {
        if (m1) this.set_matrix4(m1);
        var tmp = this.m01;
        this.m01 = this.m10;
        this.m10 = tmp;
        tmp = this.m02;
        this.m02 = this.m20;
        this.m20 = tmp;
        tmp = this.m03;
        this.m03 = this.m30;
        this.m30 = tmp;
        tmp = this.m12;
        this.m12 = this.m21;
        this.m21 = tmp;
        tmp = this.m13;
        this.m13 = this.m31;
        this.m31 = tmp;
        tmp = this.m23;
        this.m23 = this.m32;
        this.m32 = tmp;
    };

    Matrix4d.prototype.set_array = function set_array(m) {
        this.m00 = m[0];
        this.m01 = m[1];
        this.m02 = m[2];
        this.m03 = m[3];
        this.m10 = m[4];
        this.m11 = m[5];
        this.m12 = m[6];
        this.m13 = m[7];
        this.m20 = m[8];
        this.m21 = m[9];
        this.m22 = m[10];
        this.m23 = m[11];
        this.m30 = m[12];
        this.m31 = m[13];
        this.m32 = m[14];
        this.m33 = m[15];
    };

    Matrix4d.prototype.set_matrix3 = function set_matrix3(m1) {
        this.m00 = m1.m00;
        this.m01 = m1.m01;
        this.m02 = m1.m02;
        this.m03 = 0.0;
        this.m10 = m1.m10;
        this.m11 = m1.m11;
        this.m12 = m1.m12;
        this.m13 = 0.0;
        this.m20 = m1.m20;
        this.m21 = m1.m21;
        this.m22 = m1.m22;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    };

    Matrix4d.prototype.set_axisAngle = function set_axisAngle(a1) {
        this.setFromAxisAngle(a1.x, a1.y, a1.z, a1.angle);
    };

    Matrix4d.prototype.set_quat = function set_quat(q1, t1, s) {
        this.setFromQuat(q1.x, q1.y, q1.z, q1.w);
        if (arguments.length === 3) {
            this.mulRotationScale(s);
            this.m03 = t1.x;
            this.m13 = t1.y;
            this.m23 = t1.z;
        }
    };

    Matrix4d.prototype.set_matrix4 = function set_matrix4(m1) {
        this.m00 = m1.m00;
        this.m01 = m1.m01;
        this.m02 = m1.m02;
        this.m03 = m1.m03;
        this.m10 = m1.m10;
        this.m11 = m1.m11;
        this.m12 = m1.m12;
        this.m13 = m1.m13;
        this.m20 = m1.m20;
        this.m21 = m1.m21;
        this.m22 = m1.m22;
        this.m23 = m1.m23;
        this.m30 = m1.m30;
        this.m31 = m1.m31;
        this.m32 = m1.m32;
        this.m33 = m1.m33;
    };

    Matrix4d.prototype.invert = function invert(m1) {
        if (m1) this.set_matrix4(m1);
        var s = this.determinant();
        if (s === 0.0) return;
        s = 1 / s;
        this.set(this.m11 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m12 * (this.m23 * this.m31 - this.m21 * this.m33) + this.m13 * (this.m21 * this.m32 - this.m22 * this.m31), this.m21 * (this.m02 * this.m33 - this.m03 * this.m32) + this.m22 * (this.m03 * this.m31 - this.m01 * this.m33) + this.m23 * (this.m01 * this.m32 - this.m02 * this.m31), this.m31 * (this.m02 * this.m13 - this.m03 * this.m12) + this.m32 * (this.m03 * this.m11 - this.m01 * this.m13) + this.m33 * (this.m01 * this.m12 - this.m02 * this.m11), this.m01 * (this.m13 * this.m22 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m13 * this.m21) + this.m03 * (this.m12 * this.m21 - this.m11 * this.m22), this.m12 * (this.m20 * this.m33 - this.m23 * this.m30) + this.m13 * (this.m22 * this.m30 - this.m20 * this.m32) + this.m10 * (this.m23 * this.m32 - this.m22 * this.m33), this.m22 * (this.m00 * this.m33 - this.m03 * this.m30) + this.m23 * (this.m02 * this.m30 - this.m00 * this.m32) + this.m20 * (this.m03 * this.m32 - this.m02 * this.m33), this.m32 * (this.m00 * this.m13 - this.m03 * this.m10) + this.m33 * (this.m02 * this.m10 - this.m00 * this.m12) + this.m30 * (this.m03 * this.m12 - this.m02 * this.m13), this.m02 * (this.m13 * this.m20 - this.m10 * this.m23) + this.m03 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m00 * (this.m12 * this.m23 - this.m13 * this.m22), this.m13 * (this.m20 * this.m31 - this.m21 * this.m30) + this.m10 * (this.m21 * this.m33 - this.m23 * this.m31) + this.m11 * (this.m23 * this.m30 - this.m20 * this.m33), this.m23 * (this.m00 * this.m31 - this.m01 * this.m30) + this.m20 * (this.m01 * this.m33 - this.m03 * this.m31) + this.m21 * (this.m03 * this.m30 - this.m00 * this.m33), this.m33 * (this.m00 * this.m11 - this.m01 * this.m10) + this.m30 * (this.m01 * this.m13 - this.m03 * this.m11) + this.m31 * (this.m03 * this.m10 - this.m00 * this.m13), this.m03 * (this.m11 * this.m20 - this.m10 * this.m21) + this.m00 * (this.m13 * this.m21 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m13 * this.m20), this.m10 * (this.m22 * this.m31 - this.m21 * this.m32) + this.m11 * (this.m20 * this.m32 - this.m22 * this.m30) + this.m12 * (this.m21 * this.m30 - this.m20 * this.m31), this.m20 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m21 * (this.m00 * this.m32 - this.m02 * this.m30) + this.m22 * (this.m01 * this.m30 - this.m00 * this.m31), this.m30 * (this.m02 * this.m11 - this.m01 * this.m12) + this.m31 * (this.m00 * this.m12 - this.m02 * this.m10) + this.m32 * (this.m01 * this.m10 - this.m00 * this.m11), this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20));
        this.mul_scalar(s);
    };

    Matrix4d.prototype.determinant = function determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * (this.m22 * this.m33 - this.m23 * this.m32) - (this.m00 * this.m12 - this.m02 * this.m10) * (this.m21 * this.m33 - this.m23 * this.m31) + (this.m00 * this.m13 - this.m03 * this.m10) * (this.m21 * this.m32 - this.m22 * this.m31) + (this.m01 * this.m12 - this.m02 * this.m11) * (this.m20 * this.m33 - this.m23 * this.m30) - (this.m01 * this.m13 - this.m03 * this.m11) * (this.m20 * this.m32 - this.m22 * this.m30) + (this.m02 * this.m13 - this.m03 * this.m12) * (this.m20 * this.m31 - this.m21 * this.m30);
    };

    Matrix4d.prototype.set_scale = function set_scale(scale) {
        this.m00 = scale;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = scale;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = scale;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    };

    Matrix4d.prototype.set_translation = function set_translation(v1) {
        this.setIdentity();
        this.setTranslation(v1);
    };

    Matrix4d.prototype.set_scaleTranslation = function set_scaleTranslation(scale, v1) {
        this.set_scale(scale);
        this.setTranslation(v1);
    };

    Matrix4d.prototype.set_translationScale = function set_translationScale(v1, scale) {
        this.m00 = scale;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = scale * v1.x;
        this.m10 = 0.0;
        this.m11 = scale;
        this.m12 = 0.0;
        this.m13 = scale * v1.y;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = scale;
        this.m23 = scale * v1.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    };

    Matrix4d.prototype.set_rotaionTranslationScale = function set_rotaionTranslationScale(m1, t1, scale) {
        this.setRotationScale(m1);
        this.mulRotationScale(scale);
        this.setTranslation(t1);
        this.m33 = 1.0;
    };

    Matrix4d.prototype.setTranslation = function setTranslation(trans) {
        this.m03 = trans.x;
        this.m13 = trans.y;
        this.m23 = trans.z;
    };

    Matrix4d.prototype.rotX = function rotX(angle) {
        var c = Math.cos(angle);
        var s = Math.sin(angle);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = c;
        this.m12 = -s;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = s;
        this.m22 = c;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    };

    Matrix4d.prototype.rotY = function rotY(angle) {
        var c = Math.cos(angle);
        var s = Math.sin(angle);
        this.m00 = c;
        this.m01 = 0.0;
        this.m02 = s;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = -s;
        this.m21 = 0.0;
        this.m22 = c;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    };

    Matrix4d.prototype.rotZ = function rotZ(angle) {
        var c = Math.cos(angle);
        var s = Math.sin(angle);
        this.m00 = c;
        this.m01 = -s;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = s;
        this.m11 = c;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    };

    Matrix4d.prototype.mul_scalar = function mul_scalar(scalar, m1) {
        if (m1) this.set_matrix4(m1);
        this.m00 *= scalar;
        this.m01 *= scalar;
        this.m02 *= scalar;
        this.m03 *= scalar;
        this.m10 *= scalar;
        this.m11 *= scalar;
        this.m12 *= scalar;
        this.m13 *= scalar;
        this.m20 *= scalar;
        this.m21 *= scalar;
        this.m22 *= scalar;
        this.m23 *= scalar;
        this.m30 *= scalar;
        this.m31 *= scalar;
        this.m32 *= scalar;
        this.m33 *= scalar;
    };

    Matrix4d.prototype.mul_matrix = function mul_matrix(m1, m2) {
        if (!m2) {
            m2 = m1;
            m1 = this;
        }
        this.set(m1.m00 * m2.m00 + m1.m01 * m2.m10 + m1.m02 * m2.m20 + m1.m03 * m2.m30, m1.m00 * m2.m01 + m1.m01 * m2.m11 + m1.m02 * m2.m21 + m1.m03 * m2.m31, m1.m00 * m2.m02 + m1.m01 * m2.m12 + m1.m02 * m2.m22 + m1.m03 * m2.m32, m1.m00 * m2.m03 + m1.m01 * m2.m13 + m1.m02 * m2.m23 + m1.m03 * m2.m33, m1.m10 * m2.m00 + m1.m11 * m2.m10 + m1.m12 * m2.m20 + m1.m13 * m2.m30, m1.m10 * m2.m01 + m1.m11 * m2.m11 + m1.m12 * m2.m21 + m1.m13 * m2.m31, m1.m10 * m2.m02 + m1.m11 * m2.m12 + m1.m12 * m2.m22 + m1.m13 * m2.m32, m1.m10 * m2.m03 + m1.m11 * m2.m13 + m1.m12 * m2.m23 + m1.m13 * m2.m33, m1.m20 * m2.m00 + m1.m21 * m2.m10 + m1.m22 * m2.m20 + m1.m23 * m2.m30, m1.m20 * m2.m01 + m1.m21 * m2.m11 + m1.m22 * m2.m21 + m1.m23 * m2.m31, m1.m20 * m2.m02 + m1.m21 * m2.m12 + m1.m22 * m2.m22 + m1.m23 * m2.m32, m1.m20 * m2.m03 + m1.m21 * m2.m13 + m1.m22 * m2.m23 + m1.m23 * m2.m33, m1.m30 * m2.m00 + m1.m31 * m2.m10 + m1.m32 * m2.m20 + m1.m33 * m2.m30, m1.m30 * m2.m01 + m1.m31 * m2.m11 + m1.m32 * m2.m21 + m1.m33 * m2.m31, m1.m30 * m2.m02 + m1.m31 * m2.m12 + m1.m32 * m2.m22 + m1.m33 * m2.m32, m1.m30 * m2.m03 + m1.m31 * m2.m13 + m1.m32 * m2.m23 + m1.m33 * m2.m33);
    };

    Matrix4d.prototype.mulTransposeBoth = function mulTransposeBoth(m1, m2) {
        this.mul_matrix(m2, m1);
        this.transpose();
    };

    Matrix4d.prototype.mulTransposeRight = function mulTransposeRight(m1, m2) {
        this.set(m1.m00 * m2.m00 + m1.m01 * m2.m01 + m1.m02 * m2.m02 + m1.m03 * m2.m03, m1.m00 * m2.m10 + m1.m01 * m2.m11 + m1.m02 * m2.m12 + m1.m03 * m2.m13, m1.m00 * m2.m20 + m1.m01 * m2.m21 + m1.m02 * m2.m22 + m1.m03 * m2.m23, m1.m00 * m2.m30 + m1.m01 * m2.m31 + m1.m02 * m2.m32 + m1.m03 * m2.m33, m1.m10 * m2.m00 + m1.m11 * m2.m01 + m1.m12 * m2.m02 + m1.m13 * m2.m03, m1.m10 * m2.m10 + m1.m11 * m2.m11 + m1.m12 * m2.m12 + m1.m13 * m2.m13, m1.m10 * m2.m20 + m1.m11 * m2.m21 + m1.m12 * m2.m22 + m1.m13 * m2.m23, m1.m10 * m2.m30 + m1.m11 * m2.m31 + m1.m12 * m2.m32 + m1.m13 * m2.m33, m1.m20 * m2.m00 + m1.m21 * m2.m01 + m1.m22 * m2.m02 + m1.m23 * m2.m03, m1.m20 * m2.m10 + m1.m21 * m2.m11 + m1.m22 * m2.m12 + m1.m23 * m2.m13, m1.m20 * m2.m20 + m1.m21 * m2.m21 + m1.m22 * m2.m22 + m1.m23 * m2.m23, m1.m20 * m2.m30 + m1.m21 * m2.m31 + m1.m22 * m2.m32 + m1.m23 * m2.m33, m1.m30 * m2.m00 + m1.m31 * m2.m01 + m1.m32 * m2.m02 + m1.m33 * m2.m03, m1.m30 * m2.m10 + m1.m31 * m2.m11 + m1.m32 * m2.m12 + m1.m33 * m2.m13, m1.m30 * m2.m20 + m1.m31 * m2.m21 + m1.m32 * m2.m22 + m1.m33 * m2.m23, m1.m30 * m2.m30 + m1.m31 * m2.m31 + m1.m32 * m2.m32 + m1.m33 * m2.m33);
    };

    Matrix4d.prototype.mulTransposeLeft = function mulTransposeLeft(m1, m2) {
        this.set(m1.m00 * m2.m00 + m1.m10 * m2.m10 + m1.m20 * m2.m20 + m1.m30 * m2.m30, m1.m00 * m2.m01 + m1.m10 * m2.m11 + m1.m20 * m2.m21 + m1.m30 * m2.m31, m1.m00 * m2.m02 + m1.m10 * m2.m12 + m1.m20 * m2.m22 + m1.m30 * m2.m32, m1.m00 * m2.m03 + m1.m10 * m2.m13 + m1.m20 * m2.m23 + m1.m30 * m2.m33, m1.m01 * m2.m00 + m1.m11 * m2.m10 + m1.m21 * m2.m20 + m1.m31 * m2.m30, m1.m01 * m2.m01 + m1.m11 * m2.m11 + m1.m21 * m2.m21 + m1.m31 * m2.m31, m1.m01 * m2.m02 + m1.m11 * m2.m12 + m1.m21 * m2.m22 + m1.m31 * m2.m32, m1.m01 * m2.m03 + m1.m11 * m2.m13 + m1.m21 * m2.m23 + m1.m31 * m2.m33, m1.m02 * m2.m00 + m1.m12 * m2.m10 + m1.m22 * m2.m20 + m1.m32 * m2.m30, m1.m02 * m2.m01 + m1.m12 * m2.m11 + m1.m22 * m2.m21 + m1.m32 * m2.m31, m1.m02 * m2.m02 + m1.m12 * m2.m12 + m1.m22 * m2.m22 + m1.m32 * m2.m32, m1.m02 * m2.m03 + m1.m12 * m2.m13 + m1.m22 * m2.m23 + m1.m32 * m2.m33, m1.m03 * m2.m00 + m1.m13 * m2.m10 + m1.m23 * m2.m20 + m1.m33 * m2.m30, m1.m03 * m2.m01 + m1.m13 * m2.m11 + m1.m23 * m2.m21 + m1.m33 * m2.m31, m1.m03 * m2.m02 + m1.m13 * m2.m12 + m1.m23 * m2.m22 + m1.m33 * m2.m32, m1.m03 * m2.m03 + m1.m13 * m2.m13 + m1.m23 * m2.m23 + m1.m33 * m2.m33);
    };

    Matrix4d.prototype.equals = function equals(m1) {
        return m1 && this.m00 === m1.m00 && this.m01 === m1.m01 && this.m02 === m1.m02 && this.m03 === m1.m03 && this.m10 === m1.m10 && this.m11 === m1.m11 && this.m12 === m1.m12 && this.m13 === m1.m13 && this.m20 === m1.m20 && this.m21 === m1.m21 && this.m22 === m1.m22 && this.m23 === m1.m23 && this.m30 === m1.m30 && this.m31 === m1.m31 && this.m32 === m1.m32 && this.m33 === m1.m33;
    };

    Matrix4d.prototype.epsilonEquals = function epsilonEquals(m1, epsilon) {
        return Math.abs(this.m00 - m1.m00) <= epsilon && Math.abs(this.m01 - m1.m01) <= epsilon && Math.abs(this.m02 - m1.m02) <= epsilon && Math.abs(this.m03 - m1.m03) <= epsilon && Math.abs(this.m10 - m1.m10) <= epsilon && Math.abs(this.m11 - m1.m11) <= epsilon && Math.abs(this.m12 - m1.m12) <= epsilon && Math.abs(this.m13 - m1.m13) <= epsilon && Math.abs(this.m20 - m1.m20) <= epsilon && Math.abs(this.m21 - m1.m21) <= epsilon && Math.abs(this.m22 - m1.m22) <= epsilon && Math.abs(this.m23 - m1.m23) <= epsilon && Math.abs(this.m30 - m1.m30) <= epsilon && Math.abs(this.m31 - m1.m31) <= epsilon && Math.abs(this.m32 - m1.m32) <= epsilon && Math.abs(this.m33 - m1.m33) <= epsilon;
    };

    Matrix4d.prototype.transform = function transform(vec, vecOut) {
        vecOut = vecOut || vec;
        vecOut.set_xyzw(this.m00 * vec.x + this.m01 * vec.y + this.m02 * vec.z + this.m03 * vec.w, this.m10 * vec.x + this.m11 * vec.y + this.m12 * vec.z + this.m13 * vec.w, this.m20 * vec.x + this.m21 * vec.y + this.m22 * vec.z + this.m23 * vec.w, this.m30 * vec.x + this.m31 * vec.y + this.m32 * vec.z + this.m33 * vec.w);
    };

    Matrix4d.prototype.transformPoint = function transformPoint(point, pointOut) {
        pointOut = pointOut || point;
        pointOut.set_xyz(this.m00 * point.x + this.m01 * point.y + this.m02 * point.z + this.m03, this.m10 * point.x + this.m11 * point.y + this.m12 * point.z + this.m13, this.m20 * point.x + this.m21 * point.y + this.m22 * point.z + this.m23);
    };

    Matrix4d.prototype.transformVector = function transformVector(normal, normalOut) {
        normalOut = normalOut || normal;
        normalOut.set_xyz(this.m00 * normal.x + this.m01 * normal.y + this.m02 * normal.z, this.m10 * normal.x + this.m11 * normal.y + this.m12 * normal.z, this.m20 * normal.x + this.m21 * normal.y + this.m22 * normal.z);
    };

    Matrix4d.prototype.setRotation_matrix = function setRotation_matrix(m1) {
        var scale = this.SVD(null, null);
        this.setRotationScale(m1);
        this.mulRotationScale(scale);
    };

    Matrix4d.prototype.setRotation_quat = function setRotation_quat(q1) {
        var scale = this.SVD(null, null);
        var tx = this.m03;
        var ty = this.m13;
        var tz = this.m23;
        var w0 = this.m30;
        var w1 = this.m31;
        var w2 = this.m32;
        var w3 = this.m33;
        this.set_quat(q1);
        this.mulRotationScale(scale);
        this.m03 = tx;
        this.m13 = ty;
        this.m23 = tz;
        this.m30 = w0;
        this.m31 = w1;
        this.m32 = w2;
        this.m33 = w3;
    };

    Matrix4d.prototype.setRotation_axisAngle = function setRotation_axisAngle(a1) {
        var scale = this.SVD(null, null);
        var tx = this.m03;
        var ty = this.m13;
        var tz = this.m23;
        var w0 = this.m30;
        var w1 = this.m31;
        var w2 = this.m32;
        var w3 = this.m33;
        this.set_axisAngle(a1);
        this.mulRotationScale(scale);
        this.m03 = tx;
        this.m13 = ty;
        this.m23 = tz;
        this.m30 = w0;
        this.m31 = w1;
        this.m32 = w2;
        this.m33 = w3;
    };

    Matrix4d.prototype.setZero = function setZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 0.0;
    };

    Matrix4d.prototype.negate = function negate(m1) {
        if (m1) this.set_matrix4(m1);
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
    };

    Matrix4d.prototype.set = function set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    };

    Matrix4d.prototype.SVD = function SVD(rot3, rot4) {
        var s = Math.sqrt((this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) / 3.0);
        if (rot3) {
            this.getRotationScale(rot3);
            var n = 1 / Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
            rot3.m00 *= n;
            rot3.m10 *= n;
            rot3.m20 *= n;
            n = 1 / Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
            rot3.m01 *= n;
            rot3.m11 *= n;
            rot3.m21 *= n;
            n = 1 / Math.sqrt(this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22);
            rot3.m02 *= n;
            rot3.m12 *= n;
            rot3.m22 *= n;
        }
        if (rot4) {
            if (rot4) rot4.setRotationScale_4(this);
            var n = 1 / Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
            rot4.m00 *= n;
            rot4.m10 *= n;
            rot4.m20 *= n;
            n = 1 / Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
            rot4.m01 *= n;
            rot4.m11 *= n;
            rot4.m21 *= n;
            n = 1 / Math.sqrt(this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22);
            rot4.m02 *= n;
            rot4.m12 *= n;
            rot4.m22 *= n;
        }
        return s;
    };

    Matrix4d.prototype._SVD = function _SVD(rot) {
        var s = Math.sqrt((this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) / 3.0);
        var t = s === 0.0 ? 0.0 : 1.0 / s;
        if (rot) {
            this.getRotationScale(rot);
            rot.mul_scalar(t);
        }
        return s;
    };

    Matrix4d.prototype.mulRotationScale = function mulRotationScale(scale) {
        this.m00 *= scale;
        this.m01 *= scale;
        this.m02 *= scale;
        this.m10 *= scale;
        this.m11 *= scale;
        this.m12 *= scale;
        this.m20 *= scale;
        this.m21 *= scale;
        this.m22 *= scale;
    };

    Matrix4d.prototype.setRotationScale_4 = function setRotationScale_4(m1) {
        this.m00 = m1.m00;
        this.m01 = m1.m01;
        this.m02 = m1.m02;
        this.m10 = m1.m10;
        this.m11 = m1.m11;
        this.m12 = m1.m12;
        this.m20 = m1.m20;
        this.m21 = m1.m21;
        this.m22 = m1.m22;
    };

    Matrix4d.prototype.setFromQuat = function setFromQuat(x, y, z, w) {
        var n = x * x + y * y + z * z + w * w;
        var s = n > 0.0 ? 2.0 / n : 0.0;
        var xs = x * s;
        var ys = y * s;
        var zs = z * s;
        var wx = w * xs;
        var wy = w * ys;
        var wz = w * zs;
        var xx = x * xs;
        var xy = x * ys;
        var xz = x * zs;
        var yy = y * ys;
        var yz = y * zs;
        var zz = z * zs;
        this.setIdentity();
        this.m00 = 1.0 - (yy + zz);
        this.m01 = xy - wz;
        this.m02 = xz + wy;
        this.m10 = xy + wz;
        this.m11 = 1.0 - (xx + zz);
        this.m12 = yz - wx;
        this.m20 = xz - wy;
        this.m21 = yz + wx;
        this.m22 = 1.0 - (xx + yy);
    };

    Matrix4d.prototype.setFromAxisAngle = function setFromAxisAngle(x, y, z, angle) {
        var n = Math.sqrt(x * x + y * y + z * z);
        n = 1 / n;
        x *= n;
        y *= n;
        z *= n;
        var c = Math.cos(angle);
        var s = Math.sin(angle);
        var omc = 1.0 - c;
        this.m00 = c + x * x * omc;
        this.m11 = c + y * y * omc;
        this.m22 = c + z * z * omc;
        var tmp1 = x * y * omc;
        var tmp2 = z * s;
        this.m01 = tmp1 - tmp2;
        this.m10 = tmp1 + tmp2;
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.m02 = tmp1 + tmp2;
        this.m20 = tmp1 - tmp2;
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.m12 = tmp1 - tmp2;
        this.m21 = tmp1 + tmp2;
    };

    return Matrix4d;
})();

exports.Matrix4d = Matrix4d;

},{"./Matrix3d":4,"./Quat4d":9}],6:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _Tuple2d2 = require('./Tuple2d');

var Point2d = (function (_Tuple2d) {
    _inherits(Point2d, _Tuple2d);

    function Point2d() {
        _classCallCheck(this, Point2d);

        _Tuple2d.apply(this, arguments);
    }

    

    Point2d.prototype.distanceSquared = function distanceSquared(p1) {
        var dx = this.x - p1.x;
        var dy = this.y - p1.y;
        return dx * dx + dy * dy;
    };

    Point2d.prototype.distance = function distance(p1) {
        return Math.sqrt(this.distanceSquared(p1));
    };

    Point2d.prototype.distanceL1 = function distanceL1(p1) {
        return Math.abs(this.x - p1.x) + Math.abs(this.y - p1.y);
    };

    Point2d.prototype.distanceLinf = function distanceLinf(p1) {
        return Math.max(Math.abs(this.x - p1.x), Math.abs(this.y - p1.y));
    };

    return Point2d;
})(_Tuple2d2.Tuple2d);

exports.Point2d = Point2d;

},{"./Tuple2d":10}],7:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _Tuple3d2 = require('./Tuple3d');

var Point3d = (function (_Tuple3d) {
    _inherits(Point3d, _Tuple3d);

    function Point3d() {
        _classCallCheck(this, Point3d);

        _Tuple3d.apply(this, arguments);
    }

    

    Point3d.prototype.distanceSquared = function distanceSquared(p1) {
        var dx = this.x - p1.x;
        var dy = this.y - p1.y;
        var dz = this.z - p1.z;
        return dx * dx + dy * dy + dz * dz;
    };

    Point3d.prototype.distance = function distance(p1) {
        return Math.sqrt(this.distanceSquared(p1));
    };

    Point3d.prototype.distanceL1 = function distanceL1(p1) {
        return Math.abs(this.x - p1.x) + Math.abs(this.y - p1.y) + Math.abs(this.z - p1.z);
    };

    Point3d.prototype.distanceLinf = function distanceLinf(p1) {
        return Math.max(Math.max(Math.abs(this.x - p1.x), Math.abs(this.y - p1.y)), Math.abs(this.z - p1.z));
    };

    Point3d.prototype.project = function project(p1) {
        this.x = p1.x / p1.w;
        this.y = p1.y / p1.w;
        this.z = p1.z / p1.w;
    };

    return Point3d;
})(_Tuple3d2.Tuple3d);

exports.Point3d = Point3d;

},{"./Tuple3d":11}],8:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _Tuple4d2 = require('./Tuple4d');

var Point4d = (function (_Tuple4d) {
    _inherits(Point4d, _Tuple4d);

    function Point4d() {
        _classCallCheck(this, Point4d);

        _Tuple4d.apply(this, arguments);
    }

    

    Point4d.prototype.set_tuple3 = function set_tuple3(t1) {
        this.set_xyzw(t1.x, t1.y, t1.z, 1);
    };

    Point4d.prototype.distanceSquared = function distanceSquared(p1) {
        var dx = this.x - p1.x;
        var dy = this.y - p1.y;
        var dz = this.z - p1.z;
        var dw = this.w - p1.w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    };

    Point4d.prototype.distance = function distance(p1) {
        return Math.sqrt(this.distanceSquared(p1));
    };

    Point4d.prototype.distanceL1 = function distanceL1(p1) {
        return Math.abs(this.x - p1.x) + Math.abs(this.y - p1.y) + Math.abs(this.z - p1.z) + Math.abs(this.w - p1.w);
    };

    Point4d.prototype.distanceLinf = function distanceLinf(p1) {
        return Math.max(Math.max(Math.abs(this.x - p1.x), Math.abs(this.y - p1.y)), Math.max(Math.abs(this.z - p1.z), Math.abs(this.w - p1.w)));
    };

    Point4d.prototype.project = function project(p1) {
        this.x = p1.x / p1.w;
        this.y = p1.y / p1.w;
        this.z = p1.z / p1.w;
        this.w = 1.0;
    };

    return Point4d;
})(_Tuple4d2.Tuple4d);

exports.Point4d = Point4d;

},{"./Tuple4d":12}],9:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _Tuple4d2 = require('./Tuple4d');

var Quat4d = (function (_Tuple4d) {
    _inherits(Quat4d, _Tuple4d);

    function Quat4d() {
        _classCallCheck(this, Quat4d);

        _Tuple4d.apply(this, arguments);
    }

    

    Quat4d.prototype.conjugate = function conjugate(q1) {
        if (q1) {
            this.x = -q1.x;
            this.y = -q1.y;
            this.z = -q1.z;
            this.w = q1.w;
        } else {
            this.x = -this.x;
            this.y = -this.y;
            this.z = -this.z;
        }
    };

    Quat4d.prototype.mul = function mul(q1, q2) {
        if (q2) {
            this.set_xyzw(q1.x * q2.w + q1.w * q2.x + q1.y * q2.z - q1.z * q2.y, q1.y * q2.w + q1.w * q2.y + q1.z * q2.x - q1.x * q2.z, q1.z * q2.w + q1.w * q2.z + q1.x * q2.y - q1.y * q2.x, q1.w * q2.w - q1.x * q2.x - q1.y * q2.y - q1.z * q2.z);
        } else {
            this.set_xyzw(this.x * q1.w + this.w * q1.x + this.y * q1.z - this.z * q1.y, this.y * q1.w + this.w * q1.y + this.z * q1.x - this.x * q1.z, this.z * q1.w + this.w * q1.z + this.x * q1.y - this.y * q1.x, this.w * q1.w - this.x * q1.x - this.y * q1.y - this.z * q1.z);
        }
    };

    Quat4d.prototype.mulInverse = function mulInverse(q1, q2) {
        var n = this.norm();
        n = n === 0.0 ? n : 1 / n;
        if (q2) {
            this.set_xyzw((q1.x * q2.w - q1.w * q2.x - q1.y * q2.z + q1.z * q2.y) * n, (q1.y * q2.w - q1.w * q2.y - q1.z * q2.x + q1.x * q2.z) * n, (q1.z * q2.w - q1.w * q2.z - q1.x * q2.y + q1.y * q2.x) * n, (q1.w * q2.w + q1.x * q2.x + q1.y * q2.y + q1.z * q2.z) * n);
        } else {
            this.set_xyzw((this.x * q1.w - this.w * q1.x - this.y * q1.z + this.z * q1.y) * n, (this.y * q1.w - this.w * q1.y - this.z * q1.x + this.x * q1.z) * n, (this.z * q1.w - this.w * q1.z - this.x * q1.y + this.y * q1.x) * n, (this.w * q1.w + this.x * q1.x + this.y * q1.y + this.z * q1.z) * n);
        }
    };

    Quat4d.prototype.norm = function norm() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    };

    Quat4d.prototype.inverse = function inverse(q1) {
        if (q1) {
            var n = q1.norm();
            this.x = -q1.x / n;
            this.y = -q1.y / n;
            this.z = -q1.z / n;
            this.w = q1.w / n;
        } else {
            var n = this.norm();
            this.x = -this.x / n;
            this.y = -this.y / n;
            this.z = -this.z / n;
            this.w /= n;
        }
    };

    Quat4d.prototype.normalize = function normalize(q1) {
        if (q1) {
            var n = Math.sqrt(q1.norm());
            this.x = q1.x / n;
            this.y = q1.y / n;
            this.z = q1.z / n;
            this.w = q1.w / n;
        } else {
            var n = Math.sqrt(this.norm());
            this.x /= n;
            this.y /= n;
            this.z /= n;
            this.w /= n;
        }
    };

    Quat4d.prototype.set_matrix4 = function set_matrix4(m1) {
        this.setFromMat(m1.m00, m1.m01, m1.m02, m1.m10, m1.m11, m1.m12, m1.m20, m1.m21, m1.m22);
    };

    Quat4d.prototype.set_matrix3 = function set_matrix3(m1) {
        this.setFromMat(m1.m00, m1.m01, m1.m02, m1.m10, m1.m11, m1.m12, m1.m20, m1.m21, m1.m22);
    };

    Quat4d.prototype.set_axisAngle = function set_axisAngle(a1) {
        this.x = a1.x;
        this.y = a1.y;
        this.z = a1.z;
        var n = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        var s = Math.sin(0.5 * a1.angle) / n;
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w = Math.cos(0.5 * a1.angle);
    };

    Quat4d.prototype.interpolate = function interpolate(q1, p2, alpha) {
        if (p2 instanceof Quat4d) {
            this.set_tuple(q1);
            q1 = p2;
        } else {
            alpha = p2;
        }
        this.normalize();
        var n1 = Math.sqrt(q1.norm());
        var x1 = q1.x / n1;
        var y1 = q1.y / n1;
        var z1 = q1.z / n1;
        var w1 = q1.w / n1;
        var t = this.x * x1 + this.y * y1 + this.z * z1 + this.w * w1;
        if (1.0 <= Math.abs(t)) return;
        t = Math.acos(t);
        var sin_t = Math.sin(t);
        if (sin_t === 0.0) return;
        var s = Math.sin((1.0 - alpha) * t) / sin_t;
        t = Math.sin(alpha * t) / sin_t;
        this.x = s * this.x + t * x1;
        this.y = s * this.y + t * y1;
        this.z = s * this.z + t * z1;
        this.w = s * this.w + t * w1;
    };

    Quat4d.prototype.setFromMat = function setFromMat(m00, m01, m02, m10, m11, m12, m20, m21, m22) {
        var s = undefined;
        var tr = m00 + m11 + m22;
        if (tr >= 0.0) {
            s = Math.sqrt(tr + 1.0);
            this.w = s * 0.5;
            s = 0.5 / s;
            this.x = (m21 - m12) * s;
            this.y = (m02 - m20) * s;
            this.z = (m10 - m01) * s;
        } else {
            var max = Math.max(Math.max(m00, m11), m22);
            if (max === m00) {
                s = Math.sqrt(m00 - (m11 + m22) + 1.0);
                this.x = s * 0.5;
                s = 0.5 / s;
                this.y = (m01 + m10) * s;
                this.z = (m20 + m02) * s;
                this.w = (m21 - m12) * s;
            } else if (max === m11) {
                s = Math.sqrt(m11 - (m22 + m00) + 1.0);
                this.y = s * 0.5;
                s = 0.5 / s;
                this.z = (m12 + m21) * s;
                this.x = (m01 + m10) * s;
                this.w = (m02 - m20) * s;
            } else {
                s = Math.sqrt(m22 - (m00 + m11) + 1.0);
                this.z = s * 0.5;
                s = 0.5 / s;
                this.x = (m20 + m02) * s;
                this.y = (m12 + m21) * s;
                this.w = (m10 - m01) * s;
            }
        }
    };

    return Quat4d;
})(_Tuple4d2.Tuple4d);

exports.Quat4d = Quat4d;

},{"./Tuple4d":12}],10:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Tuple2d = (function () {
    function Tuple2d(a, b) {
        _classCallCheck(this, Tuple2d);

        if (Array.isArray(a)) {
            this.x = a[0] || 0;
            this.y = a[1] || 0;
        } else if (typeof a === "undefined") {
            this.x = 0.0;
            this.y = 0.0;
        } else if (typeof a === "number") {
            this.x = a || 0.0;
            this.y = b || 0.0;
        } else {
            this.x = a.x;
            this.y = a.y;
        }
    }

    

    Tuple2d.prototype.set_xy = function set_xy(x, y) {
        this.x = x;
        this.y = y;
    };

    Tuple2d.prototype.set_array = function set_array(t) {
        this.x = t[0];
        this.y = t[1];
    };

    Tuple2d.prototype.set_tuple = function set_tuple(t1) {
        this.x = t1.x;
        this.y = t1.y;
    };

    Tuple2d.prototype.get = function get(t) {
        t[0] = this.x;
        t[1] = this.y;
    };

    Tuple2d.prototype.add = function add(t1, t2) {
        if (t2) {
            this.x = t1.x + t2.x;
            this.y = t1.y + t2.y;
        } else {
            this.x += t1.x;
            this.y += t1.y;
        }
    };

    Tuple2d.prototype.sub = function sub(t1, t2) {
        if (t2) {
            this.x = t1.x - t2.x;
            this.y = t1.y - t2.y;
        } else {
            this.x -= t1.x;
            this.y -= t1.y;
        }
    };

    Tuple2d.prototype.negate = function negate(t1) {
        if (t1) {
            this.x = -t1.x;
            this.y = -t1.y;
        } else {
            this.x = -this.x;
            this.y = -this.y;
        }
    };

    Tuple2d.prototype.scale = function scale(s, t1) {
        if (t1) {
            this.x = s * t1.x;
            this.y = s * t1.y;
        } else {
            this.x *= s;
            this.y *= s;
        }
    };

    Tuple2d.prototype.scaleAdd = function scaleAdd(s, t1, t2) {
        if (t2) {
            this.x = s * t1.x + t2.x;
            this.y = s * t1.y + t2.y;
        } else {
            this.x = s * this.x + t1.x;
            this.y = s * this.y + t1.y;
        }
    };

    Tuple2d.prototype.equals = function equals(t1) {
        return t1 && this.x === t1.x && this.y === t1.y;
    };

    Tuple2d.prototype.epsilonEquals = function epsilonEquals(t1, epsilon) {
        return Math.abs(t1.x - this.x) <= epsilon && Math.abs(t1.y - this.y) <= epsilon;
    };

    Tuple2d.prototype.toString = function toString() {
        return "(" + this.x + ", " + this.y + ")";
    };

    Tuple2d.prototype.clamp = function clamp(min, max, t) {
        if (t) this.set_tuple(t);
        this.clampMin(min);
        this.clampMax(max);
    };

    Tuple2d.prototype.clampMin = function clampMin(min, t) {
        if (t) this.set_tuple(t);
        if (this.x < min) this.x = min;
        if (this.y < min) this.y = min;
    };

    Tuple2d.prototype.clampMax = function clampMax(max, t) {
        if (t) this.set_tuple(t);
        if (this.x > max) this.x = max;
        if (this.y > max) this.y = max;
    };

    Tuple2d.prototype.absolute = function absolute(t) {
        if (t) this.set_tuple(t);
        if (this.x < 0.0) this.x = -this.x;
        if (this.y < 0.0) this.y = -this.y;
    };

    Tuple2d.prototype.interpolate = function interpolate(t1, p2, alpha) {
        if (typeof p2 === "number") {
            alpha = p2;
            var beta = 1 - alpha;
            this.x = beta * this.x + alpha * t1.x;
            this.y = beta * this.y + alpha * t1.y;
        } else {
            var t2 = p2;
            this.set_tuple(t1);
            this.interpolate(t2, alpha);
        }
    };

    return Tuple2d;
})();

exports.Tuple2d = Tuple2d;

},{}],11:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Tuple3d = (function () {
    function Tuple3d(p1, p2, p3) {
        _classCallCheck(this, Tuple3d);

        if (Array.isArray(p1)) {
            this.x = p1[0] || 0;
            this.y = p1[1] || 0;
            this.z = p1[2] || 0;
        } else if (typeof p1 === "undefined") {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        } else if (typeof p1 === "number") {
            this.x = p1 || 0.0;
            this.y = p2 || 0.0;
            this.z = p3 || 0.0;
        } else {
            this.x = p1.x;
            this.y = p1.y;
            this.z = p1.z;
        }
    }

    

    Tuple3d.prototype.set_xyz = function set_xyz(x, y, z) {
        this.x = x;
        this.y = y;
        this.z = z;
    };

    Tuple3d.prototype.set_array = function set_array(t) {
        this.x = t[0];
        this.y = t[1];
        this.z = t[2];
    };

    Tuple3d.prototype.set_tuple = function set_tuple(t1) {
        this.x = t1.x;
        this.y = t1.y;
        this.z = t1.z;
    };

    Tuple3d.prototype.get_array = function get_array(t) {
        t[0] = this.x;
        t[1] = this.y;
        t[2] = this.z;
    };

    Tuple3d.prototype.get_tuple = function get_tuple(t) {
        t.x = this.x;
        t.y = this.y;
        t.z = this.z;
    };

    Tuple3d.prototype.add = function add(t1, t2) {
        if (t2) {
            this.x = t1.x + t2.x;
            this.y = t1.y + t2.y;
            this.z = t1.z + t2.z;
        } else {
            this.x += t1.x;
            this.y += t1.y;
            this.z += t1.z;
        }
    };

    Tuple3d.prototype.sub = function sub(t1, t2) {
        if (t2) {
            this.x = t1.x - t2.x;
            this.y = t1.y - t2.y;
            this.z = t1.z - t2.z;
        } else {
            this.x -= t1.x;
            this.y -= t1.y;
            this.z -= t1.z;
        }
    };

    Tuple3d.prototype.negate = function negate(t1) {
        if (t1) {
            this.x = -t1.x;
            this.y = -t1.y;
            this.z = -t1.z;
        } else {
            this.x = -this.x;
            this.y = -this.y;
            this.z = -this.z;
        }
    };

    Tuple3d.prototype.scale = function scale(s, t1) {
        if (t1) {
            this.x = s * t1.x;
            this.y = s * t1.y;
            this.z = s * t1.z;
        } else {
            this.x *= s;
            this.y *= s;
            this.z *= s;
        }
    };

    Tuple3d.prototype.scaleAdd = function scaleAdd(s, t1, t2) {
        if (t2) {
            this.x = s * t1.x + t2.x;
            this.y = s * t1.y + t2.y;
            this.z = s * t1.z + t2.z;
        } else {
            this.x = s * this.x + t1.x;
            this.y = s * this.y + t1.y;
            this.z = s * this.z + t1.z;
        }
    };

    Tuple3d.prototype.equals = function equals(t1) {
        return t1 && this.x === t1.x && this.y === t1.y && this.z === t1.z;
    };

    Tuple3d.prototype.epsilonEquals = function epsilonEquals(t1, epsilon) {
        return Math.abs(t1.x - this.x) <= epsilon && Math.abs(t1.y - this.y) <= epsilon && Math.abs(t1.z - this.z) <= epsilon;
    };

    Tuple3d.prototype.toString = function toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    };

    Tuple3d.prototype.absolute = function absolute(t) {
        if (t) this.set_tuple(t);
        if (this.x < 0.0) this.x = -this.x;
        if (this.y < 0.0) this.y = -this.y;
        if (this.z < 0.0) this.z = -this.z;
    };

    Tuple3d.prototype.clamp = function clamp(min, max, t) {
        if (t) this.set_tuple(t);
        this.clampMin(min);
        this.clampMax(max);
    };

    Tuple3d.prototype.clampMin = function clampMin(min, t) {
        if (t) this.set_tuple(t);
        if (this.x < min) this.x = min;
        if (this.y < min) this.y = min;
        if (this.z < min) this.z = min;
    };

    Tuple3d.prototype.clampMax = function clampMax(max, t) {
        if (t) this.set_tuple(t);
        if (this.x > max) this.x = max;
        if (this.y > max) this.y = max;
        if (this.z > max) this.z = max;
    };

    Tuple3d.prototype.interpolate = function interpolate(t1, p2, alpha) {
        if (p2 instanceof Tuple3d) {
            this.set_tuple(t1);
            t1 = p2;
        } else {
            alpha = p2;
        }
        var beta = 1 - alpha;
        this.x = beta * this.x + alpha * t1.x;
        this.y = beta * this.y + alpha * t1.y;
        this.z = beta * this.z + alpha * t1.z;
    };

    return Tuple3d;
})();

exports.Tuple3d = Tuple3d;

},{}],12:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Tuple4d = (function () {
    function Tuple4d(p1, p2, p3, p4) {
        _classCallCheck(this, Tuple4d);

        if (Array.isArray(p1)) {
            this.x = p1[0] || 0;
            this.y = p1[1] || 0;
            this.z = p1[2] || 0;
            this.w = p1[3] || 0;
        } else if (typeof p1 === "undefined") {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            this.w = 0.0;
        } else if (typeof p1 === "number") {
            this.x = p1 || 0.0;
            this.y = p2 || 0.0;
            this.z = p3 || 0.0;
            this.w = p4 || 0.0;
        } else {
            this.x = p1.x;
            this.y = p1.y;
            this.z = p1.z;
            this.w = p1.w;
        }
    }

    

    Tuple4d.prototype.set_xyzw = function set_xyzw(x, y, z, w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    };

    Tuple4d.prototype.set_array = function set_array(t) {
        this.x = t[0];
        this.y = t[1];
        this.z = t[2];
        this.w = t[3];
    };

    Tuple4d.prototype.set_tuple = function set_tuple(t1) {
        this.x = t1.x;
        this.y = t1.y;
        this.z = t1.z;
        this.w = t1.w;
    };

    Tuple4d.prototype.get_array = function get_array(t) {
        t[0] = this.x;
        t[1] = this.y;
        t[2] = this.z;
        t[3] = this.w;
    };

    Tuple4d.prototype.get_tuple = function get_tuple(t) {
        t.x = this.x;
        t.y = this.y;
        t.z = this.z;
        t.w = this.w;
    };

    Tuple4d.prototype.add = function add(t1, t2) {
        if (t2) {
            this.x = t1.x + t2.x;
            this.y = t1.y + t2.y;
            this.z = t1.z + t2.z;
            this.w = t1.w + t2.w;
        } else {
            this.x += t1.x;
            this.y += t1.y;
            this.z += t1.z;
            this.w += t1.w;
        }
    };

    Tuple4d.prototype.sub = function sub(t1, t2) {
        if (t2) {
            this.x = t1.x - t2.x;
            this.y = t1.y - t2.y;
            this.z = t1.z - t2.z;
            this.w = t1.w - t2.w;
        } else {
            this.x -= t1.x;
            this.y -= t1.y;
            this.z -= t1.z;
            this.w -= t1.w;
        }
    };

    Tuple4d.prototype.negate = function negate(t1) {
        if (t1) {
            this.x = -t1.x;
            this.y = -t1.y;
            this.z = -t1.z;
            this.w = -t1.w;
        } else {
            this.x = -this.x;
            this.y = -this.y;
            this.z = -this.z;
            this.w = -this.w;
        }
    };

    Tuple4d.prototype.scale = function scale(s, t1) {
        if (t1) {
            this.x = s * t1.x;
            this.y = s * t1.y;
            this.z = s * t1.z;
            this.w = s * t1.w;
        } else {
            this.x *= s;
            this.y *= s;
            this.z *= s;
            this.w *= s;
        }
    };

    Tuple4d.prototype.scaleAdd = function scaleAdd(s, t1, t2) {
        if (t2) {
            this.x = s * t1.x + t2.x;
            this.y = s * t1.y + t2.y;
            this.z = s * t1.z + t2.z;
            this.w = s * t1.w + t2.w;
        } else {
            this.x = s * this.x + t1.x;
            this.y = s * this.y + t1.y;
            this.z = s * this.z + t1.z;
            this.w = s * this.z + t1.w;
        }
    };

    Tuple4d.prototype.equals = function equals(t1) {
        return t1 && this.x === t1.x && this.y === t1.y && this.z === t1.z && this.w === t1.w;
    };

    Tuple4d.prototype.epsilonEquals = function epsilonEquals(t1, epsilon) {
        return Math.abs(t1.x - this.x) <= epsilon && Math.abs(t1.y - this.y) <= epsilon && Math.abs(t1.z - this.z) <= epsilon && Math.abs(t1.w - this.w) <= epsilon;
    };

    Tuple4d.prototype.toString = function toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    };

    Tuple4d.prototype.clamp = function clamp(min, max, t) {
        if (t) this.set_tuple(t);
        this.clampMin(min);
        this.clampMax(max);
    };

    Tuple4d.prototype.clampMin = function clampMin(min, t) {
        if (t) this.set_tuple(t);
        if (this.x < min) this.x = min;
        if (this.y < min) this.y = min;
        if (this.z < min) this.z = min;
        if (this.w < min) this.w = min;
    };

    Tuple4d.prototype.clampMax = function clampMax(max, t) {
        if (t) this.set_tuple(t);
        if (this.x > max) this.x = max;
        if (this.y > max) this.y = max;
        if (this.z > max) this.z = max;
        if (this.w > max) this.w = max;
    };

    Tuple4d.prototype.absolute = function absolute(t) {
        this.set_tuple(t);
        if (this.x < 0.0) this.x = -this.x;
        if (this.y < 0.0) this.y = -this.y;
        if (this.z < 0.0) this.z = -this.z;
        if (this.w < 0.0) this.w = -this.w;
    };

    Tuple4d.prototype.interpolate = function interpolate(t1, p2, alpha) {
        if (p2 instanceof Tuple4d) {
            this.set_tuple(t1);
            t1 = p2;
        } else {
            alpha = p2;
        }
        var beta = 1 - alpha;
        this.x = beta * this.x + alpha * t1.x;
        this.y = beta * this.y + alpha * t1.y;
        this.z = beta * this.z + alpha * t1.z;
        this.w = beta * this.w + alpha * t1.w;
    };

    return Tuple4d;
})();

exports.Tuple4d = Tuple4d;

},{}],13:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _Tuple2d2 = require('./Tuple2d');

var Vector2d = (function (_Tuple2d) {
    _inherits(Vector2d, _Tuple2d);

    function Vector2d() {
        _classCallCheck(this, Vector2d);

        _Tuple2d.apply(this, arguments);
    }

    

    Vector2d.prototype.dot = function dot(v1) {
        return this.x * v1.x + this.y * v1.y;
    };

    Vector2d.prototype.length = function length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    };

    Vector2d.prototype.lengthSquared = function lengthSquared() {
        return this.x * this.x + this.y * this.y;
    };

    Vector2d.prototype.normalize = function normalize(v1) {
        if (v1) this.set_tuple(v1);
        var d = this.length();
        this.x /= d;
        this.y /= d;
    };

    Vector2d.prototype.angle = function angle(v1) {
        return Math.abs(Math.atan2(this.x * v1.y - this.y * v1.x, this.dot(v1)));
    };

    return Vector2d;
})(_Tuple2d2.Tuple2d);

exports.Vector2d = Vector2d;

},{"./Tuple2d":10}],14:[function(require,module,exports){
"use strict";
exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _Tuple3d2 = require('./Tuple3d');

var Vector3d = (function (_Tuple3d) {
    _inherits(Vector3d, _Tuple3d);

    function Vector3d() {
        _classCallCheck(this, Vector3d);

        _Tuple3d.apply(this, arguments);
    }

    

    Vector3d.prototype.cross = function cross(v1, v2) {
        this.set_xyz(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
    };

    Vector3d.prototype.normalize = function normalize(v1) {
        if (v1) this.set_tuple(v1);
        var d = this.length();
        this.x /= d;
        this.y /= d;
        this.z /= d;
    };

    Vector3d.prototype.dot = function dot(v1) {
        return this.x * v1.x + this.y * v1.y + this.z * v1.z;
    };

    Vector3d.prototype.lengthSquared = function lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    };

    Vector3d.prototype.length = function length() {
        return Math.sqrt(this.lengthSquared());
    };

    Vector3d.prototype.angle = function angle(v1) {
        var xx = this.y * v1.z - this.z * v1.y;
        var yy = this.z * v1.x - this.x * v1.z;
        var zz = this.x * v1.y - this.y * v1.x;
        var cross = Math.sqrt(xx * xx + yy * yy + zz * zz);
        return Math.abs(Math.atan2(cross, this.dot(v1)));
    };

    return Vector3d;
})(_Tuple3d2.Tuple3d);

exports.Vector3d = Vector3d;

},{"./Tuple3d":11}],15:[function(require,module,exports){
'use strict';

exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _Tuple4d2 = require('./Tuple4d');

var Vector4d = (function (_Tuple4d) {
    _inherits(Vector4d, _Tuple4d);

    function Vector4d() {
        _classCallCheck(this, Vector4d);

        _Tuple4d.apply(this, arguments);
    }

    

    Vector4d.prototype.set_tuple3 = function set_tuple3(t1) {
        this.set_xyzw(t1.x, t1.y, t1.z, 0);
    };

    Vector4d.prototype.lengthSquared = function lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    };

    Vector4d.prototype.length = function length() {
        return Math.sqrt(this.lengthSquared());
    };

    Vector4d.prototype.dot = function dot(v1) {
        return this.x * v1.x + this.y * v1.y + this.z * v1.z + this.w * v1.w;
    };

    Vector4d.prototype.normalize = function normalize(v1) {
        if (v1) this.set_tuple(v1);
        var d = this.length();
        this.x /= d;
        this.y /= d;
        this.z /= d;
        this.w /= d;
    };

    Vector4d.prototype.angle = function angle(v1) {
        var d = this.dot(v1);
        var v1Length = v1.length();
        var vLength = this.length();
        return Math.acos(d / v1Length / vLength);
    };

    return Vector4d;
})(_Tuple4d2.Tuple4d);

exports.Vector4d = Vector4d;

},{"./Tuple4d":12}],16:[function(require,module,exports){
'use strict';

exports.__esModule = true;

function _interopExportWildcard(obj, defaults) { var newObj = defaults({}, obj); delete newObj['default']; return newObj; }

function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

var _AxisAngle4d = require('./AxisAngle4d');

_defaults(exports, _interopExportWildcard(_AxisAngle4d, _defaults));

var _GMatrix = require('./GMatrix');

_defaults(exports, _interopExportWildcard(_GMatrix, _defaults));

var _GVector = require('./GVector');

_defaults(exports, _interopExportWildcard(_GVector, _defaults));

var _Matrix3d = require('./Matrix3d');

_defaults(exports, _interopExportWildcard(_Matrix3d, _defaults));

var _Matrix4d = require('./Matrix4d');

_defaults(exports, _interopExportWildcard(_Matrix4d, _defaults));

var _Point2d = require('./Point2d');

_defaults(exports, _interopExportWildcard(_Point2d, _defaults));

var _Point3d = require('./Point3d');

_defaults(exports, _interopExportWildcard(_Point3d, _defaults));

var _Point4d = require('./Point4d');

_defaults(exports, _interopExportWildcard(_Point4d, _defaults));

var _Quat4d = require('./Quat4d');

_defaults(exports, _interopExportWildcard(_Quat4d, _defaults));

var _Tuple2d = require('./Tuple2d');

_defaults(exports, _interopExportWildcard(_Tuple2d, _defaults));

var _Tuple3d = require('./Tuple3d');

_defaults(exports, _interopExportWildcard(_Tuple3d, _defaults));

var _Tuple4d = require('./Tuple4d');

_defaults(exports, _interopExportWildcard(_Tuple4d, _defaults));

var _Vector2d = require('./Vector2d');

_defaults(exports, _interopExportWildcard(_Vector2d, _defaults));

var _Vector3d = require('./Vector3d');

_defaults(exports, _interopExportWildcard(_Vector3d, _defaults));

var _Vector4d = require('./Vector4d');

_defaults(exports, _interopExportWildcard(_Vector4d, _defaults));



},{"./AxisAngle4d":1,"./GMatrix":2,"./GVector":3,"./Matrix3d":4,"./Matrix4d":5,"./Point2d":6,"./Point3d":7,"./Point4d":8,"./Quat4d":9,"./Tuple2d":10,"./Tuple3d":11,"./Tuple4d":12,"./Vector2d":13,"./Vector3d":14,"./Vector4d":15}],17:[function(require,module,exports){
"use strict";
exports.__esModule = true;
exports.arraycopy = arraycopy;

function arraycopy(src, srcPos, dest, destPos, length) {
    for (var i = 0; i < length; i++) {
        dest[i + destPos] = src[i + srcPos];
    }
}



},{}]},{},[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17]);
