//module nethome.ui
/**
 * マスクコマンド
 * @author kawae
**/
var MaskCommand = (function () {
    function MaskCommand(c, mod) {
        this.mCom = c;
        this.mMod = mod;
    }
    MaskCommand.prototype.matchMask = function (mod) {
        return this.mMod === mod;
    };
    MaskCommand.prototype.command = function () {
        return this.mCom;
    };
    return MaskCommand;
})();
exports.MaskCommand = MaskCommand;
exports.SHIFT_MASK = 1 << 0;
exports.CTRL_MASK = 1 << 1;
exports.META_MASK = 1 << 2;
exports.ALT_MASK = 1 << 3;
function getModifiers(ev) {
    var mod = 0;
    if (ev.shiftKey)
        mod |= exports.SHIFT_MASK;
    if (ev.ctrlKey)
        mod |= exports.CTRL_MASK;
    if (ev.metaKey)
        mod |= exports.META_MASK;
    if (ev.altKey)
        mod |= exports.ALT_MASK;
    return mod;
}
exports.getModifiers = getModifiers;
//# sourceMappingURL=MaskCommand.js.map