import { ObjectLibrary } from '../lib/ObjectLibrary';
import { FileSystem } from 'kiteclib';
import { ApplicationCore } from './ApplicationCore';
import { Document } from '../doc/Document';
import { Project } from '../doc/Project';
/**
 * 各種リソースのルート。
 * v4のMainComponent相当。
 * @author matsuzaki
**/
export interface INethomeRuntime {
    getApplication(): ApplicationCore;
    /**
     * ライブラリの取得
     * @param key
     * @return
    **/
    getLibrary(key: string): ObjectLibrary;
    /**
     * ライブラリの登録
     * @param key
     * @param lib
    **/
    registerLibrary(key: string, lib: ObjectLibrary): void;
    /**
     * ファイルシステムの設定
     * @param fs
    **/
    setFileSystem(fs: FileSystem): void;
    /**
     * ファイルシステムの取得
     * @return
    **/
    getFileSystem(): FileSystem;
    /**
     * アクティブなドキュメントの取得
     * @return Document
    **/
    getActiveDocument(): Document;
    /**
     * アクティブなプロジェクトの取得
     * @return
     * @since 2004/12/03
     * @author kawae
     * @version 2004/12/03
    **/
    getActiveProject(): Project;
}
