//module nethome.ui
var DefaultDrawData = (function () {
    function DefaultDrawData() {
        /**
         * シンプル表示フラグ **/
        this.mDrawMode = DefaultDrawData.DRAW_FULL;
        this.mAdditionalDrawGeoms = [];
        this.mOptionalDrawElement = [];
    }
    /**
     * オプショナル描画オブジェクト群の取得**/
    DefaultDrawData.prototype.getOptionalDrawList = function () {
        return this.mOptionalDrawElement;
    };
    /**
     * オプショナル描画オブジェクトの追加**/
    DefaultDrawData.prototype.addOptionalDrawObject = function (o) {
        if (this.mOptionalDrawElement.indexOf(o) >= 0)
            return;
        this.mOptionalDrawElement.push(o);
    };
    /**
     * オプショナル描画オブジェクトの削除**/
    DefaultDrawData.prototype.removeOptionalDrawObject = function (o) {
        var i = this.mOptionalDrawElement.indexOf(o);
        if (i < 0)
            return;
        this.mOptionalDrawElement.splice(i, 1);
    };
    DefaultDrawData.prototype.addAdditionalDrawingGeometry = function (g) {
        if (this.mAdditionalDrawGeoms.indexOf(g) >= 0)
            return;
        this.mAdditionalDrawGeoms.push(g);
    };
    DefaultDrawData.prototype.removeAdditionalDrawingGeometry = function (g) {
        var i = this.mAdditionalDrawGeoms.indexOf(g);
        if (i < 0)
            return;
        this.mAdditionalDrawGeoms.splice(i, 1);
    };
    DefaultDrawData.prototype.removeAllAdditionalDrawingGeometry = function () {
        this.mAdditionalDrawGeoms = [];
    };
    /**
     * @param dispGrid the dispGrid to set**/
    DefaultDrawData.prototype.setDispGrid = function (dispGrid) {
        this.mDispGrid = dispGrid;
    };
    /**
     * @return the dispGrid**/
    DefaultDrawData.prototype.isDispGrid = function () {
        return this.mDispGrid;
    };
    DefaultDrawData.prototype.setDrawMode = function (b) {
        this.mDrawMode = b;
    };
    DefaultDrawData.prototype.getDrawMode = function () {
        return this.mDrawMode;
    };
    DefaultDrawData.DRAW_FULL = 0;
    DefaultDrawData.DRAW_SIMPLE = 1;
    DefaultDrawData.DRAW_LINE = 2;
    return DefaultDrawData;
})();
exports.DefaultDrawData = DefaultDrawData;
//# sourceMappingURL=DefaultDrawData.js.map