var MaskCommand_1 = require('./MaskCommand');
//module nethome.ui
/**
 * @author matsuzaki**/
var CommandManager = (function () {
    /****/
    function CommandManager() {
        this.mMaskCommands = [];
        this.mCommandCollection = [];
        //this.mKeyCommand = new ArrayList<AccelKey>();
    }
    /**
     * アクセラレーションコレクション **/
    //protected mKeyCommand: AccelKey[];
    CommandManager.getInstance = function () {
        return CommandManager.mInstance;
    };
    /**
     * マスクイベントの設定
     * @param m
     * @param i
    **/
    CommandManager.prototype.registerMaskEvent = function (m, i) {
        this.mMaskCommands.push(new MaskCommand_1.MaskCommand(m, i));
    };
    CommandManager.prototype.getMaskCommand = function (mod) {
        var m = MaskCommand_1.getModifiers(mod);
        for (var i = 0, size = this.mMaskCommands.length; i < size; i++) {
            var mc = this.mMaskCommands[i];
            if (mc.matchMask(m))
                return mc.command();
        }
        return null;
    };
    /**
     * ユーザインターフェースのコレクションの取得
     * @return
    **/
    CommandManager.prototype.getCommandCollection = function () {
        return this.mCommandCollection;
    };
    /**
     * 特定のコマンドの取得
     * @param c
     * @return
     * @author kawae
     * @since 2004/10/17
    **/
    CommandManager.prototype.getCommand = function (c) {
        for (var i = 0; i < this.mCommandCollection.length; i++) {
            var com = this.mCommandCollection[i];
            if (com.constructor === c)
                return com;
        }
        return null;
    };
    /**
     * UIの初期化（主にファイルを読み込んだタイミング）**/
    CommandManager.prototype.initUserInterface = function () {
        this.mCommandCollection.forEach(function (cm) {
            return cm.initInterface();
        });
    };
    /**
     * UIの更新（主に操作後のタイミング）**/
    CommandManager.prototype.updateUserInterface = function () {
        this.mCommandCollection.forEach(function (cm) {
            return cm.updateInterface();
        });
    };
    CommandManager.mInstance = new CommandManager();
    return CommandManager;
})();
exports.CommandManager = CommandManager;
//# sourceMappingURL=CommandManager.js.map