import { Command } from './command/Command';
import { MaskCommand, ModifierKeyState } from './MaskCommand';
/**
 * @author matsuzaki**/
export declare class CommandManager {
    /**
     * Command派生コマンド群 **/
    protected mCommandCollection: Command[];
    /**
     * マスクコマンド **/
    protected mMaskCommands: MaskCommand[];
    /**
     * アクセラレーションコレクション **/
    static getInstance(): CommandManager;
    protected static mInstance: CommandManager;
    /****/
    constructor();
    /**
     * マスクイベントの設定
     * @param m
     * @param i
    **/
    registerMaskEvent(m: Command, i: number): void;
    getMaskCommand(mod: ModifierKeyState): Command;
    /**
     * ユーザインターフェースのコレクションの取得
     * @return
    **/
    getCommandCollection(): Command[];
    /**
     * 特定のコマンドの取得
     * @param c
     * @return
     * @author kawae
     * @since 2004/10/17
    **/
    getCommand(c: Function): Object;
    /**
     * UIの初期化（主にファイルを読み込んだタイミング）**/
    initUserInterface(): void;
    /**
     * UIの更新（主に操作後のタイミング）**/
    updateUserInterface(): void;
}
