import { IRichGraphics } from 'kiteclib';
/**
 * データを受け取ってKRichGraphicsに描画する
 * @author matsuzaki
 * @param<DrawDataT>
**/
export interface CanvasDrawer {
    /**
     * 静的なデータの表示。
     * 再作図の指示があるまでキャッシュされる。
     * @param data 表示するデータ
     * @param g グラフィックスコンテキスト
    **/
    draw(data: Object, g: IRichGraphics): void;
    /**
     * 動的なデータの表示。
     * paintのたびに再描画される。
     * @param data 表示するデータ
     * @param g グラフィックスコンテキスト
    **/
    drawDynamic(data: Object, g: IRichGraphics): void;
}
