var CommandManager_1 = require('./CommandManager');
//module nethome.ui
/**
 * 各種イベントをコマンドに振り分ける
 * @author matsuzaki
**/
var CanvasCommandDispatcher = (function () {
    /****/
    function CanvasCommandDispatcher(can) {
        /**
         * アクティブなコマンド **/
        this.mActiveCommand = null;
        /**
         * アクティブなマスクコマンド **/
        this.mActiveMaskCommand = null;
        /**
         * 矢印キーコマンド **/
        this.mArrowCommand = null;
        /**
         * オペレーションが無い場合のコマンド **/
        this.mNullCommand = null;
        this.mCanvas = can;
        exports.bindHandlers(can, this);
    }
    /**
     * 現在アクティブなマスクコマンドの取得
     * @return the activeMaskCommand
    **/
    CanvasCommandDispatcher.prototype.getActiveMaskCommand = function () {
        return this.mActiveMaskCommand;
    };
    /**
     * マスクコマンドをクリア**/
    CanvasCommandDispatcher.prototype.clearMaskCommand = function () {
        this.mActiveMaskCommand = null;
    };
    /**
     * 現在アクティブなコマンドの取得
     * @return
     * @author kawae
    **/
    CanvasCommandDispatcher.prototype.getMouseCommand = function () {
        return this.mActiveCommand;
    };
    /**
     * オペレーションが無い場合のコマンド**/
    CanvasCommandDispatcher.prototype.setNullCommand = function (c) {
        this.mNullCommand = c;
        this.setMouseCommand(c);
    };
    /**
     * 矢印キーコマンドの設定**/
    CanvasCommandDispatcher.prototype.setArrowKeyCommand = function (m) {
        this.mArrowCommand = m;
    };
    /**
     * ビューコントロールコマンドの設定
     * @param c
    **/
    CanvasCommandDispatcher.prototype.setViewControlCommand = function (c) {
        this.mViewControlCommand = c;
    };
    /**
     * ビューコントロールコマンドの取得
     * @return
    **/
    CanvasCommandDispatcher.prototype.getViewControlCommand = function () {
        return this.mViewControlCommand;
    };
    /**
     * ビューコントロールコマンドの更新**/
    CanvasCommandDispatcher.prototype.updateViewControl = function () {
        if (this.mViewControlCommand != null)
            this.mViewControlCommand.updateInterface();
    };
    /**
     * アクティブコマンドの設定
     * @param c
    **/
    CanvasCommandDispatcher.prototype.setMouseCommand = function (c) {
        if (this.mActiveCommand != null)
            this.mActiveCommand.end();
        if (c == null) {
            this.mActiveCommand = this.mNullCommand;
            if (this.mNullCommand != null) {
                this.mNullCommand.updateInterface();
                this.mNullCommand.play();
            }
        }
        else {
            this.mActiveCommand = c;
        }
        if (this.mActiveCommand != null) {
            this.mActiveCommand.canvas = this.mCanvas;
        }
        this.mCanvas.repaint();
    };
    /*
    onbeforecopy(ev: DragEvent): any {
    }
    onbeforecut(ev: DragEvent): any {
    }
    ondrag(ev: DragEvent): any {
    }
    ondragend(ev: DragEvent): any {
    }
    ondragenter(ev: DragEvent): any {
    }
    ondragleave(ev: DragEvent): any {
    }
    ondragover(ev: DragEvent): any {
    }
    ondragstart(ev: DragEvent): any {
    }
    ondrop(ev: DragEvent): any {
    }
    onpaste(ev: DragEvent): any {
    }
    */
    CanvasCommandDispatcher.prototype.onclick = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onclick)
                this.mActiveMaskCommand.onclick(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onclick)
                this.mActiveCommand.onclick(ev);
        }
    };
    CanvasCommandDispatcher.prototype.ondblclick = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.ondblclick)
                this.mActiveMaskCommand.ondblclick(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.ondblclick)
                this.mActiveCommand.ondblclick(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onmousedown = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmousedown)
                this.mActiveMaskCommand.onmousedown(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmousedown)
                this.mActiveCommand.onmousedown(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onmouseenter = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseenter)
                this.mActiveMaskCommand.onmouseenter(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseenter)
                this.mActiveCommand.onmouseenter(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onmouseleave = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseleave)
                this.mActiveMaskCommand.onmouseleave(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseleave)
                this.mActiveCommand.onmouseleave(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onmousemove = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmousemove)
                this.mActiveMaskCommand.onmousemove(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmousemove)
                this.mActiveCommand.onmousemove(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onmouseout = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseout)
                this.mActiveMaskCommand.onmouseout(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseout)
                this.mActiveCommand.onmouseout(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onmouseover = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseover)
                this.mActiveMaskCommand.onmouseover(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseover)
                this.mActiveCommand.onmouseover(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onmouseup = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseup)
                this.mActiveMaskCommand.onmouseup(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseup)
                this.mActiveCommand.onmouseup(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onmousewheel = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmousewheel)
                this.mActiveMaskCommand.onmousewheel(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmousewheel)
                this.mActiveCommand.onmousewheel(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onkeydown = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onkeydown)
                this.mActiveMaskCommand.onkeydown(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onkeydown)
                this.mActiveCommand.onkeydown(ev);
        }
        if (ev.defaultPrevented)
            return;
        var cm = CommandManager_1.CommandManager.getInstance();
        var c = cm.getMaskCommand(ev);
        if (c != this.mActiveMaskCommand) {
            if (this.mActiveMaskCommand)
                this.mActiveMaskCommand.end();
            this.mActiveMaskCommand = c;
            if (this.mActiveMaskCommand) {
                if (this.mActiveCommand)
                    this.mActiveCommand.restoration();
                this.mActiveMaskCommand.canvas = this.mCanvas;
                this.mActiveMaskCommand.play();
            }
        }
    };
    CanvasCommandDispatcher.prototype.onkeypress = function (ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onkeypress)
                this.mActiveMaskCommand.onkeypress(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onkeypress)
                this.mActiveCommand.onkeypress(ev);
        }
    };
    CanvasCommandDispatcher.prototype.onkeyup = function (ev) {
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.end();
            this.mActiveMaskCommand = null;
        }
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onkeyup)
                this.mActiveMaskCommand.onkeyup(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onkeyup)
                this.mActiveCommand.onkeyup(ev);
        }
    };
    return CanvasCommandDispatcher;
})();
exports.CanvasCommandDispatcher = CanvasCommandDispatcher;
exports.bindHandlers = function (canvas, dispatcher) {
    var dom = canvas.domElement;
    //dom.onbeforecopy = dispatcher.onbeforecopy.bind(dispatcher);
    //dom.onbeforecut = dispatcher.onbeforecut.bind(dispatcher);
    //dom.ondrag = dispatcher.ondrag.bind(dispatcher);
    //dom.ondragend = dispatcher.ondragend.bind(dispatcher);
    //dom.ondragenter = dispatcher.ondragenter.bind(dispatcher);
    //dom.ondragleave = dispatcher.ondragleave.bind(dispatcher);
    //dom.ondragover = dispatcher.ondragover.bind(dispatcher);
    //dom.ondragstart = dispatcher.ondragstart.bind(dispatcher);
    //dom.ondrop = dispatcher.ondrop.bind(dispatcher);
    //dom.onpaste = dispatcher.onpaste.bind(dispatcher);
    dom.onclick = dispatcher.onclick.bind(dispatcher);
    dom.ondblclick = dispatcher.ondblclick.bind(dispatcher);
    dom.onmousedown = dispatcher.onmousedown.bind(dispatcher);
    dom.onmouseenter = dispatcher.onmouseenter.bind(dispatcher);
    dom.onmouseleave = dispatcher.onmouseleave.bind(dispatcher);
    dom.onmousemove = dispatcher.onmousemove.bind(dispatcher);
    dom.onmouseout = dispatcher.onmouseout.bind(dispatcher);
    dom.onmouseover = dispatcher.onmouseover.bind(dispatcher);
    dom.onmouseup = dispatcher.onmouseup.bind(dispatcher);
    dom.onmousewheel = dispatcher.onmousewheel.bind(dispatcher);
    dom.onkeydown = dispatcher.onkeydown.bind(dispatcher);
    dom.onkeypress = dispatcher.onkeypress.bind(dispatcher);
    dom.onkeyup = dispatcher.onkeyup.bind(dispatcher);
};
//# sourceMappingURL=CanvasCommandDispatcher.js.map