import { KCursor } from 'kiteclib';
import { KDimension } from 'kiteclib';
import { KViewPort } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { KPoint2d } from 'kiteclib';
import { DocumentListener } from '../doc/DocumentListener';
import { Document } from '../doc/Document';
import { Project } from '../doc/Project';
import { WorkSheet } from '../geom/WorkSheet';
import { DocumentEvent } from '../doc/DocumentEvent';
import { CanvasDrawer } from './CanvasDrawer';
import { Command } from './command/Command';
/**
 * 描画クラス**/
export declare class Canvas2D implements DocumentListener {
    static DRAW_FULL: number;
    static DRAW_SIMPLE: number;
    static DRAW_LINE: number;
    static MOUSE_DEF: KCursor;
    static MOUSE_WAIT: KCursor;
    static MOUSE_MOVE: KCursor;
    static MOUSE_HAND: KCursor;
    /**
     * ドキュメント **/
    private mDoc;
    /**
     * コマンドとイベント処理 **/
    private mCommandDispatcher;
    /**
     * 背景色 **/
    private mBackColor;
    /**
     * バッファグラフィックスコンテキスト
     **/
    private mBufferGraphics;
    /**
     * バッファイメージ
     **/
    private mBufferImage;
    /**
     * バッファグラフィックスコンテキスト
     **/
    private mContext2D;
    /**
     * バッファイメージ
     **/
    domElement: HTMLCanvasElement;
    /**
     * 抽象キャンバス
     **/
    private mAbstCanvas;
    /**
     * グリッド表示フラグ
     **/
    /**
     * ポップアップメニュー
     **/
    /**
     * カレントのマウス位置
     **/
    private mCurrentMouse;
    /**
     * ポップアップの位置
     **/
    /**
     * 再描画の必要有り
     **/
    private mNeedImageUpdate;
    /**
     * 表示クラス
     **/
    private mDrawer;
    /**
     * コンストラクタ
     * @author kawae
     **/
    constructor(canvas: HTMLCanvasElement);
    protected setEventHandler(c: HTMLCanvasElement): void;
    getSize(): KDimension;
    /**
     * 現在アクティブなコマンドの取得
     * @return
     * @author kawae
     **/
    getMouseCommand(): Command;
    setDrawer(d: CanvasDrawer): void;
    getDrawer(): CanvasDrawer;
    /**
     * オペレーションが無い場合のコマンド
     **/
    setNullCommand(c: Command): void;
    /**
     * 矢印キーコマンドの設定
     **/
    setArrowKeyCommand(m: Command): void;
    /**
     * ライブラリの整合性のため、マスクをクリア
     **/
    clearMaskCommand(): void;
    /**
     * ビューコントロールコマンドの設定
     * @param c
     **/
    setViewControlCommand(c: Command): void;
    /**
     * ビューコントロールコマンドの取得
     * @return
     **/
    getViewControlCommand(): Command;
    /**
     * ビューコントロールコマンドの更新
     **/
    updateViewControl(): void;
    /**
     * アクティブコマンドの設定
     * @param c
     **/
    setMouseCommand(c: Command): void;
    getXdotlength(dot: number): number;
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    realToDevX(x: number): number;
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    realToDevY(y: number): number;
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    realToDevXd(x: number): number;
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    realToDevYd(y: number): number;
    /**
     * 画面座標から実座標へ（ｘ）
     * @param x	デバイス座標値
     * @return		実座標値
    **/
    devToRealX(x: number): number;
    /**
     * 画面座標から実座標へ（ｙ）
     * @param y	デバイス座標値
     * @return		実座標値
    **/
    devToRealY(y: number): number;
    /**
     * ドキュメントのセット
     * @param d	ドキュメント
     **/
    setDocument(d: Document): void;
    /**
     * ドキュメントの取得
     **/
    getDocument(): Document;
    /**
     * プロジェクトの取得
     **/
    getProject(): Project;
    setCursor(c: KCursor): void;
    /**
     * コンテキストの現在の表示ステータス
     **/
    /**
     * コンテキストメニューを表示
     * @param x
     * @param y
    **/
    /**
     * コンテキストメニューの取得
     * @return
    **/
    /**
     * ポップアップの位置の取得
     * @return
     * @author kawae
     * @since 2005/03/23
    **/
    /**
     * コンテキストメニューが表示されているかを確認
     * @return　表示:true
     * 　　　　　非表示:false
    **/
    save(of: ObjectFolder): void;
    load(of: ObjectFolder): void;
    /**
     * ビューの更新
     * @author kawae
     * @since 2004/10/02
    **/
    updateView(): void;
    /**
     * ビューポートの取得**/
    getViewPort(): KViewPort;
    /**
     * スケールの設定
     * @param f　対象スケール(%指定。100が標準)
    **/
    setZoomAsScale(f: number): void;
    /**
     * 現在のズームレシオの取得
     * @return	表示％
     **/
    getZoomRatio(): number;
    /**
     * ワークシートの取得
     * @return
    **/
    getWorkSheet(): WorkSheet;
    /**
     * 描画のリセット**/
    resetView(): void;
    /**
     * 前回描画からCanvasサイズが更新されているか確認
     * @return 変更有:true　変更無:false
    **/
    isChangeCanvasSize(): boolean;
    paintComponent(): void;
    /**
     * バッファの内容と、その他状況依存描画オブジェクトの描画。
     **/
    drawPlan(): void;
    /**
     * オフスクリーングラフィックスの作成 オフイメージがnull,又はオフイメージと現在のサイズに 変化があった場合、オフイメージ、オフグラフィックスを 再作成する。
     **/
    protected createOffGraphics(): void;
    /**
     * 再作図を要求する。 再作図フラグを立て、次回描画時に実際の処理。**/
    updateImage(): void;
    /****/
    protected updateImageBuffer(): void;
    /**
     * 強制描画
     * @param g
    **/
    /**
     * カレントのマウス位置の取得**/
    getCurrentMousePos(): KPoint2d;
    /**
     * 現在のマウス座標の設定
     * @param e	マウスイベント
    **/
    updateCurrentMousePos(x: number, y: number, modifiers: number): void;
    documentChanged(e: DocumentEvent): void;
    repaint(): void;
}
