//module nethome.ui
var AbstractNethomeRuntime = (function () {
    function AbstractNethomeRuntime() {
        this.mLibrary = new Map();
    }
    /**
     * ユーザファイルシステムの設定
     **/
    AbstractNethomeRuntime.prototype.setFileSystem = function (fs) {
        this.mFileSystem = fs;
    };
    /**
     * ユーザファイルシステムの取得
     * @return
     **/
    AbstractNethomeRuntime.prototype.getFileSystem = function () {
        return this.mFileSystem;
    };
    /**
     * ライブラリの登録
     * @param key
     * @param lib
     **/
    AbstractNethomeRuntime.prototype.registerLibrary = function (key, lib) {
        if (key != null && lib != null)
            this.mLibrary.set(key, lib);
    };
    /**
     * ライブラリの取得
     * @param key
     * @return
     **/
    AbstractNethomeRuntime.prototype.getLibrary = function (key) {
        return this.mLibrary.get(key);
    };
    return AbstractNethomeRuntime;
})();
exports.AbstractNethomeRuntime = AbstractNethomeRuntime;
//# sourceMappingURL=AbstractNethomeRuntime.js.map