import { FileSystem } from 'kiteclib';
import { ObjectLibrary } from '../lib/ObjectLibrary';
import { INethomeRuntime } from './INethomeRuntime';
import { ApplicationCore } from './ApplicationCore';
import { Document } from '../doc/Document';
import { Project } from '../doc/Project';
export declare abstract class AbstractNethomeRuntime implements INethomeRuntime {
    /**
     * ライブラリ
     **/
    protected mLibrary: Map<string, ObjectLibrary>;
    /**
     * 標準のファイルシステム
     **/
    protected mFileSystem: FileSystem;
    constructor();
    /**
     * ユーザファイルシステムの設定
     **/
    setFileSystem(fs: FileSystem): void;
    /**
     * ユーザファイルシステムの取得
     * @return
     **/
    getFileSystem(): FileSystem;
    /**
     * ライブラリの登録
     * @param key
     * @param lib
     **/
    registerLibrary(key: string, lib: ObjectLibrary): void;
    /**
     * ライブラリの取得
     * @param key
     * @return
     **/
    getLibrary(key: string): ObjectLibrary;
    abstract getActiveDocument(): Document;
    abstract getActiveProject(): Project;
    abstract getApplication(): ApplicationCore;
}
