import { ITextDpi } from './ITextDpi';
import { ITextFormat } from '../../text/ITextFormat';
import { ObjectFolder } from 'kiteclib';
import { KTextElement } from './KTextElement';
/**
 * @author kawae
 * @since 2004/11/13
**/
export declare class KTextLine {
    static GEOMNAME: string;
    /**
     * テキスト要素のコレクション **/
    mTextElements: Array<KTextElement>;
    /**
     * コンストラクタ
     * @author kawae
     * @since 2004/11/14
    **/
    constructor();
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode: ObjectFolder): void;
    /**
     * データの保存
     * @param savenode
    **/
    static readData(of: ObjectFolder, tl: KTextLine): KTextLine;
    /**
     * 内容が同じか確認
     * @param tl
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    isSame(tl: KTextLine): boolean;
    /**
     * 全ての要素にフォーマットを設定
     * @param f
     * @author kawae
     * @since 2004/11/17
    **/
    setFormat(f: ITextFormat): void;
    /**
     * 要素群の取得
     * @return
     * @author kawae
     * @since 2004/11/14
    **/
    getElements(): Array<KTextElement>;
    /**
     * コピーインスタンスの取得
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    getCopy(): KTextLine;
    /**
     * 全てのテキスト要素の削除
     * @author kawae
     * @since 2004/11/15
    **/
    removeAll(): void;
    /**
     * テキストの追加
     * @param s
     * @param tf
     * @author kawae
     * @since 2004/11/17
    **/
    addText(s: string, tf: ITextFormat): void;
    /**
     * テキスト要素の追加
     * @param e
     * @author kawae
     * @since 2004/11/15
    **/
    addTextElement(e: KTextElement): void;
    getDescent(dpi: ITextDpi): number;
    /**
     * 最大幅の取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/16
    **/
    getMaxWidth(hor: boolean, dpi: ITextDpi): number;
    /**
     * 最大高さの取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/16
    **/
    getMaxHeight(hor: boolean, dpi: ITextDpi): number;
}
