import { ObjectFolder } from 'kiteclib';
import { KFont } from 'kiteclib';
import { KColor } from 'kiteclib';
import { ITextFormat } from '../../text/ITextFormat';
import { ITextDpi } from './ITextDpi';
/**
 * テキストの最小単位
 * @author kawae
 * @since 2004/11/13
**/
export declare class KTextElement implements ITextFormat {
    static GEOMNAME: string;
    private mText;
    private mFontname;
    private mFontsize;
    private mIsUnderline;
    private mFontstyle;
    private mTextColor;
    private mBackColor;
    /**
     * コンストラクタ
     * @author kawae
     * @since 2004/11/14
    **/
    constructor();
    /**
     * テキストの設定
     * @param text
     * @author kawae
     * @since 2004/11/13
    **/
    setText(text: string): void;
    getText(): string;
    getBackColor(): KColor;
    getFontName(): string;
    getFontSize(): number;
    getFontStyle(): number;
    getTextColor(): KColor;
    isSameTextFormat(tf: ITextFormat): boolean;
    isUnderLine(): boolean;
    setBackColor(c: KColor): void;
    setFontName(s: string): void;
    setFontSize(f: number): void;
    setFontStyle(style: number): void;
    setFormat(f: ITextFormat): void;
    setTextColor(c: KColor): void;
    setUnderLine(flag: boolean): void;
    /**
     * 保存
     * @param savenode
     * @author kawae
     * @since 2004/11/17
     * @see nethome.text.ITextFormat#save(jp.kitec.lib.util.tree.ObjectFolder)
    **/
    save(savenode: ObjectFolder): void;
    /**
     * 読み込み
     * @param of
     * @param tl
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    static readData(of: ObjectFolder, tl: KTextElement): KTextElement;
    /**
     * フォントの取得
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    getFont(): KFont;
    /**
     * 最大幅の取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/14
     * @version 2006/01/05縦書き対応
    **/
    getMaxWidth(hor: boolean, dpi: ITextDpi): number;
    /**
     * 最大高さの取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/14
     * @version 2006/01/05縦書き対応
    **/
    getMaxHeight(hor: boolean, dpi: ITextDpi): number;
    getCopy(): KTextElement;
}
