import { KLineType } from 'kiteclib';
import { KColor } from 'kiteclib';
import { GPoint2Df } from '../primitive/GPoint2Df';
/**
 * 線の端点マークのインターフェース
 * @author kawae
**/
export interface ILinkMark {
    /**
     * 線の端点の仮想点の取得
     * @return
    **/
    getVirtualNode(): GPoint2Df;
    /**
     * リンクノードの更新
     * @param n1	端点
     * @param n2	端点と反対側の参照点
     * @param lt	リンクの線種
    **/
    setLinkNode(n1: GPoint2Df, n2: GPoint2Df, lt: KLineType): void;
    getFillColor(): KColor;
    getGeomColor(): KColor;
}
