//module nethome.geom.primitive
/**
 * 移動拡大のみのlocalAxis
 * @since 2007/10/12
 * @author kamimura
 * @version 2007/10/12
**/
var LocalAxis2dfs = (function () {
    /**
     * コンストラクタ.
     * @since 2007/10/12
     * @author kamimura
    **/
    function LocalAxis2dfs() {
        this.mKx = this.mKy = 1;
        this.mMx = this.mMy = 0;
    }
    /**
     * @param kx
     * @param ky
     * @param mx
     * @param my
     * @since 2007/10/12
     * @author kamimura
     * @version 2007/10/12
    **/
    LocalAxis2dfs.prototype.setCoordinates = function (kx, ky, mx, my) {
        this.mKx = kx;
        this.mKy = ky;
        this.mMx = mx;
        this.mMy = my;
    };
    /**
     * @param x
     * @param y
     * @since 2007/10/12
     * @author kamimura
     * @version 2007/10/12
    **/
    LocalAxis2dfs.prototype.setMXY = function (x, y) {
        this.mMx = x;
        this.mMy = y;
    };
    LocalAxis2dfs.prototype.getKx = function () {
        return this.mKx;
    };
    LocalAxis2dfs.prototype.getKy = function () {
        return this.mKy;
    };
    LocalAxis2dfs.prototype.getMx = function () {
        return this.mMx;
    };
    LocalAxis2dfs.prototype.getMy = function () {
        return this.mMy;
    };
    LocalAxis2dfs.prototype.getGlobalX = function (x, y) {
        return this.mKx * x + this.mMx;
    };
    LocalAxis2dfs.prototype.getGlobalY = function (x, y) {
        return this.mKy * y + this.mMy;
    };
    LocalAxis2dfs.prototype.getLocalX = function (x, y) {
        return (x - this.mMx) / this.mKx;
    };
    LocalAxis2dfs.prototype.getLocalY = function (x, y) {
        return (y - this.mMy) / this.mKy;
    };
    LocalAxis2dfs.prototype.getGlobalAngl = function (rad) {
        return 0;
    };
    return LocalAxis2dfs;
})();
exports.LocalAxis2dfs = LocalAxis2dfs;
//# sourceMappingURL=LocalAxis2dfs.js.map