/**
 * スケーリング可能な幾何形状
 * @author matsuzaki
**/
export interface IScalableGeometry {
    /**
     * X方向へのスケーリングの許可**/
    isScaleEnX(): boolean;
    /**
     * X方向へのスケーリングの許可**/
    setScaleEnX(s: boolean): void;
    /**
     * Y方向へのスケーリングの許可**/
    isScaleEnY(): boolean;
    /**
     * Y方向へのスケーリングの許可**/
    setScaleEnY(s: boolean): void;
    /**
     * アスペクト比を固定するか
     * @return the keepAspect
    **/
    isKeepAspect(): boolean;
    /**
     * アスペクト比を固定するかどうかを設定
     * @param keepAspect the keepAspect to set
    **/
    setKeepAspect(keepAspect: boolean): void;
    /**
     * スケーリングの基点X**/
    getScaleBaseX(): number;
    /**
     * スケーリングの基点X**/
    setScaleBaseX(d: number): void;
    /**
     * スケーリングの基点Y**/
    getScaleBaseY(): number;
    /**
     * スケーリングの基点Y**/
    setScaleBaseY(d: number): void;
}
