import { KPoint2d } from 'kiteclib';
/**
 * コントロールポイントで編集できる形状です。
 * @author matsuzaki
**/
export interface IControllableGeometry {
    /**
     * コントロールポイントの数を返します。**/
    getControlPointSize(): number;
    /**
     * 指定されたインデックス位置にあるコントロールポイントを返します。
     * @param index インデックス
    **/
    getControlPoint(index: number): Object;
    /**
     * 一番近いコントロールポイントを返します。
     * @return Object	一番近いコントロールポイント
     * @author kawae
     * @since 2003/01/01
    **/
    getNearControlPoint(x: number, y: number): Object;
    /**
     * コントロールポイントの座標を返します。
     * @param cp コントロールポイント
     * @return Point2d	コントロールポイントの座標
    **/
    getControlPointPosition(cp: Object): KPoint2d;
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
     * @author kawae
     * @since 2003/01/01
    **/
    moveControlPoint(cp: Object, x: number, y: number): void;
    /**
     * コントロールポイントのステータスを返します。
     * @param o
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    getControlPointStatus(o: Object): number;
    /**
     * コントロールポイントがこのジオメトリのものかどうかを返します。
     * @param o
     * @return
    **/
    containsControlPoint(o: Object): boolean;
}
