var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
//module nethome.geom.primitive
/**
 * すべての幾何オブジェクトの基底クラス
 * @author kawae
**/
var Geometry = (function () {
    /**
     * コンストラクタ**/
    function Geometry(geomName) {
        if (geomName === void 0) { geomName = null; }
        /**
         * 線種 **/
        this.lineType = null;
        /**
         * 形状色 **/
        this.mGeomColor = null;
        /**
         * 領域 **/
        this.area = new kiteclib_1.KArea();
        /**
         * 領域のコントロールオブジェクト **/
        this.areaControl = null;
        /**
         * X方向へのスケーリングの許可 **/
        this.scaleEnX = false;
        /**
         * Y方向へのスケーリングの許可 **/
        this.scaleEnY = false;
        /**
         * アスペクト比一定のフラグ **/
        this.mKeepAspect = false;
        /**
         * スケーリングの基点X **/
        this.scaleBaseX = 0;
        /**
         * スケーリングの基点Y **/
        this.scaleBaseY = 0;
        this.mGeomName = geomName;
    }
    /**
     * 幾何名の取得
     * @return Returns the mGeomName.
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.getGeomName = function () {
        return this.mGeomName;
    };
    Geometry.prototype.setGeomName = function (name) {
        this.mGeomName = name;
    };
    /**
     * 幾何IDの設定
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.setID = function (id) {
        this.mGid = id;
    };
    /**
     * 幾何IDの取得
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.getID = function () {
        return this.mGid;
    };
    /**
     * エリアの取得
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.getArea = function () {
        return this.area;
    };
    /**
     * 最大・最小領域の更新
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.updateMinMax = function (area) {
    };
    /**
     * エリアコントロールの取得
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.getAreaControl = function () {
        return this.areaControl;
    };
    /**
     * コピーインスタンスの取得
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.copy = function () {
        return null;
    };
    /**
     * コピーインスタンスの取得
     * 引数インスタンスに対し属性をコピーする
     * @param g　コピー属性設定対象オブジェクト
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.copyTo = function (g) {
        if (g == null)
            return null;
        g.lineType = this.lineType;
        g.mGeomColor = this.mGeomColor;
        g.scaleEnX = this.scaleEnX;
        g.scaleEnY = this.scaleEnY;
        g.scaleBaseX = this.scaleBaseX;
        g.scaleBaseY = this.scaleBaseY;
        g.mKeepAspect = this.mKeepAspect;
        g.mGid = this.mGid;
        return g;
    };
    /**
     * 一番近い構成点の取得
     * @param x	対象計測点X座標
     * @param y	対象計測点Y座標
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.getNearNode = function (x, y) {
        return null;
    };
    /**
     * 幾何形状までの距離の取得
     * @param x	距離計測点X座標
     * @param y	距離計測点Y座標
     * @return	幾何形状までの距離。計測不能な場合は負を返す
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.getDistanceToPoint = function (x, y) {
        return -1;
    };
    /**
     * 幾何データ共通属性データの読み込み
     * @param datanode		読み込み対象ノード
     * @param geom			設定対象幾何インスタンス
     * @throws Exception
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.readData = function (datanode, geom, ps) {
        var on;
        if ((on = datanode.getNode("id")) != null)
            geom.mGid = on.getInt();
        if ((on = datanode.getNode("forec")) != null)
            geom.mGeomColor = kiteclib_2.KColor.getColorFromRGBString(on.getString());
    };
    /**
     * 幾何データの保存
     * @param savenode		保存対象ノード
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.save = function (savenode) {
        if (savenode == null)
            return;
        savenode.setName(this.getGeomName());
        savenode.addNode("id", this.getID());
        if (this.mGeomColor != null)
            savenode.addNode("forec", this.mGeomColor.getRed() + "," + this.mGeomColor.getGreen() + "," + this.mGeomColor.getBlue());
    };
    /**
     * 幾何の移動
     * @param x	X方向移動量
     * @param y	Y方向移動量
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.offset = function (x, y) {
    };
    /**
     * 幾何の回転
     * @param xc		回転中心X座標
     * @param yc		回転中心Y座標
     * @param angl	回転角度
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.rotate = function (xc, yc, angl) {
    };
    /**
     * 幾何の回転
     * @param xc		回転中心X座標
     * @param yc		回転中心Y座標
     * @param ofsx
     * @param ofsy
     * @param angl	回転角度
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.rot = function (x, y, ofsx, ofsy) {
    };
    /**
     * X軸方向反転
     * @param x		反転軸X座標
     * @param ofsx
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.flipx = function (x, ofsx) {
    };
    /**
     * Y軸方向反転
     * @param y		反転軸Y座標
     * @param ofsx
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.flipy = function (y, ofsy) {
    };
    /**
     * 領域内に幾何が存在するか確認
     * @param minx	領域左下X座標
     * @param miny	領域左下Y座標
     * @param maxx	領域右上X座標
     * @param maxy	領域右上Y座標
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.isInner = function (minx, miny, maxx, maxy) {
        return false;
    };
    ///**
    // * ポリゴン内に存在するか確認
    // * @param v	ポリゴンのノードリスト
    // * @author kawae
    // * @since 2003/01/01
    //**/
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    return false;
    //}
    /**
     * 形状色の設定
     * @param c	設定する色
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.setGeomColor = function (c) {
        this.mGeomColor = c;
    };
    /**
     * 形状色の取得
     * @return		幾何色
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.getGeomColor = function () {
        return this.mGeomColor;
    };
    /**
     * 描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    //abstract drawGeom(d: IRichGraphics): void;
    /**
     * 指定色で描画
     * @param d	描画インターフェース
     * @param fore	前景色
     * @param back	背景色
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.drawGeom = function (d, fore, back) {
        if (fore === void 0) { fore = null; }
        if (back === void 0) { back = null; }
    };
    /**
     * ローカル座標系での通常描画
     * @param d	描画インターフェース
     * @param la	描画座標
     * @author kawae
     * @since 2004/09/24
    **/
    //drawAbstDevice(d: IRichGraphics, la: LocalAxis2Df): void {
    //}
    /**
     * 最終描画
     * @param d	描画インターフェース
     * @param fore	前景色
     * @param back	背景色
     * @param la	描画座標
     * @author kawae
     * @since 2004/09/24
    **/
    Geometry.prototype.drawAbstDevice = function (d, fore, back, la) {
        if (fore === void 0) { fore = null; }
        if (back === void 0) { back = null; }
        if (la === void 0) { la = null; }
    };
    /**
     * ハイライト描画
     * @param rg	描画インターフェース
     * @param c		幾何描画色
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.drawHighLight = function (rg, c, outline) {
    };
    /**
     * 遷移状態の描画
     * @param rg	描画インターフェース
     * @param lt	描画座標
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.drawTransition = function (rg, col, lt) {
    };
    /**
     * タイトルの描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    //drawTitle(d: IRichGraphics): void {
    //}
    /**
     * 指定色でタイトルを描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.drawTitle = function (d, c) {
        if (c === void 0) { c = null; }
    };
    /**
     * ローカル座標系での描画
     * @param rg	描画インターフェース
     * @param fore	前景色
     * @param back	背景色
     * @param la	描画座標
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.drawAlias = function (rg, fore, back, la) {
    };
    /**
     * 幾何形状の更新
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.updateShape = function () {
    };
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.getNearControlPoint = function (x, y) {
        return null;
    };
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.moveControlPoint = function (cp, x, y) {
    };
    /**
     * コントロールノードのステータスの取得
     * @param o
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    Geometry.prototype.getCtrlNodeStatus = function (o) {
        return Geometry.CTRL_NODE_STATE_DEF;
    };
    /**
     * 通常移動ステータス **/
    Geometry.CTRL_NODE_STATE_DEF = 0;
    /**
     * フリー移動ステータス **/
    Geometry.CTRL_NODE_STATE_FREE = 1;
    return Geometry;
})();
exports.Geometry = Geometry;
//# sourceMappingURL=Geometry.js.map