import { IRichGraphics } from 'kiteclib';
import { IScalableGeometry } from './IScalableGeometry';
import { Geometry } from './Geometry';
/**
 * @author matsuzaki**/
export declare abstract class GScalableGeometry extends Geometry implements IScalableGeometry {
    /**
     * X方向へのスケーリングの許可 **/
    scaleEnX: boolean;
    /**
     * Y方向へのスケーリングの許可 **/
    scaleEnY: boolean;
    /**
     * アスペクト比一定のフラグ **/
    mKeepAspect: boolean;
    /**
     * スケーリングの基点X **/
    scaleBaseX: number;
    /**
     * スケーリングの基点Y **/
    scaleBaseY: number;
    /**
     * コピーインスタンスの取得
     * 引数インスタンスに対し属性をコピーする
     * @param g　コピー属性設定対象オブジェクト
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    copyTo(g: Geometry): Geometry;
    isScaleEnX(): boolean;
    setScaleEnX(scaleEnX: boolean): void;
    isScaleEnY(): boolean;
    setScaleEnY(scaleEnY: boolean): void;
    getScaleBaseX(): number;
    setScaleBaseX(scaleBaseX: number): void;
    getScaleBaseY(): number;
    setScaleBaseY(scaleBaseY: number): void;
    /**
     * アスペクト比を固定するか
     * @return the keepAspect
    **/
    isKeepAspect(): boolean;
    /**
     * アスペクト比を固定するかどうかを設定
     * @param keepAspect the keepAspect to set
    **/
    setKeepAspect(keepAspect: boolean): void;
    abstract drawGeom(p0: IRichGraphics): void;
}
