import { KArea } from 'kiteclib';
import { KColor } from 'kiteclib';
import { IRichGraphics } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { IFillableGeometry } from './IFillableGeometry';
import { Primitive } from './Primitive';
import { LocalAxis2Df } from '../LocalAxis2Df';
import { GPoint2Df } from './GPoint2Df';
import { Geometry } from './Geometry';
export declare class GRect extends Geometry implements Primitive, IFillableGeometry {
    /**
     * 点群 **/
    mPoints: GPoint2Df[];
    /**
     * 線の太さ **/
    mLineWidth: number;
    /**
     * 描画用ポイントバッファ **/
    protected _pbuf: GPoint2Df[];
    /**
     * 塗り潰しフラグ **/
    protected mFill: boolean;
    /**
     * 塗りつぶし色 **/
    protected mFillColor: KColor;
    /**
     * コンストラクタ
     * @param x1	始点X座標3
     * @param y1	始点X座標
     * @param x2	始点X座標
     * @param y2	始点X座標
     * @param c	描画色
    //**/
    constructor(x1?: number, y1?: number, x2?: number, y2?: number, x3?: number, y3?: number, x4?: number, y4?: number, fill?: boolean);
    getP1(): GPoint2Df;
    getP2(): GPoint2Df;
    setRect(x1: number, y1: number, x2: number, y2: number): void;
    getSnapNode(x1: number, y1: number, gx: number, gy: number, min: number[], res: number[], eps: number, limit: number): boolean;
    getSnapLoop(v: GPoint2Df[]): void;
    getCenter(p: GPoint2Df): void;
    getNearNodeOnLine(p1: GPoint2Df, p2: GPoint2Df, eps: number): GPoint2Df;
    getNearLine(x: number, y: number, eps: number, pts: GPoint2Df[]): boolean;
    getRotbasePoint(): GPoint2Df;
    updateMinMax(area: KArea): void;
    copy(): Geometry;
    copyTo(g: Geometry): Geometry;
    getNearNode(x: number, y: number): GPoint2Df;
    getDistanceToPoint(x: number, y: number): number;
    offset(x: number, y: number): void;
    rotate(xc: number, yc: number, angl: number): void;
    isInner(minx: number, miny: number, maxx: number, maxy: number): boolean;
    /**
     * ポリゴン内に存在するか**/
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode: ObjectFolder): void;
    drawGeom(d: IRichGraphics, fore: KColor, back: KColor): void;
    drawAlias(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    drawAbstDevice(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    drawHighLight(d: IRichGraphics, c: KColor, outline: boolean): void;
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
    **/
    getNearControlPoint(x: number, y: number): Object;
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
    **/
    moveControlPoint(cp: Object, x: number, y: number): void;
    flipx(x: number, ofsx: number): void;
    flipy(y: number, ofsy: number): void;
    rot(x: number, y: number, ofsx: number, ofsy: number): void;
    /**
     * 幾何形状の更新**/
    updateShape(): void;
    setFillMode(b: boolean): void;
    isFillMode(): boolean;
    getFillColor(): KColor;
    setFillColor(fillColor: KColor): void;
}
