import { KColor } from 'kiteclib';
import { KArea } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { IRichGraphics } from 'kiteclib';
import { Geometry } from './Geometry';
import { GPoint2Df } from './GPoint2Df';
import { Primitive } from './Primitive';
import { GLine } from './GLine';
import { IFillableGeometry } from './IFillableGeometry';
import { LocalAxis2Df } from '../LocalAxis2Df';
/**
 * <p>タイトル: </p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2002</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
**/
export declare class GPolygon extends Geometry implements Primitive, IFillableGeometry {
    /**
     * 構成点コレクション
     **/
    protected mPoints: GPoint2Df[];
    /**
     * 描画用ポイントバッファ
     **/
    /**
     * 線幅 **/
    mLineWidth: number;
    /**
     * スムースオプション **/
    mSmooth: number;
    /**
     * 塗りつぶしオプション **/
    mFill: boolean;
    mFillColor: KColor;
    /**
     * コンストラクタ**/
    /**
     * コンストラクタ**/
    constructor(p1?: GPoint2Df[], smooth?: number);
    getSnapNode(x1: number, y1: number, gx: number, gy: number, min: number[], res: number[], eps: number, limit: number): boolean;
    getSnapLoop(v: GPoint2Df[]): void;
    getCenter(p: GPoint2Df): void;
    getNearNodeOnLine(p1: GPoint2Df, p2: GPoint2Df, eps: number): GPoint2Df;
    getNearLine(x: number, y: number, eps: number, pts: GPoint2Df[]): boolean;
    getRotbasePoint(): GPoint2Df;
    updateMinMax(area: KArea): void;
    copy(): Geometry;
    copyTo(g: Geometry): Geometry;
    /**
     * 一番近くの構成点を探す
     * @param x
     * @param y
     * @return
    **/
    getNearNode(x: number, y: number): GPoint2Df;
    /**
     * 指定点までの距離距離
     * @param x　指定点X座標
     * @param y　指定点Y座標
     * @return 指定点までの距離
    **/
    getDistanceToPoint(x: number, y: number): number;
    offset(x: number, y: number): void;
    rotate(xc: number, yc: number, angl: number): void;
    /**
     * 矩形の中に全て入っているか判定
     * @param minx　矩形最小X値
     * @param miny　矩形最小Y値
     * @param maxx　矩形最大X値
     * @param maxy　矩形最大Y値
     * @return 矩形内:true
     * 　　　　 矩形外:false
    **/
    isInner(minx: number, miny: number, maxx: number, maxy: number): boolean;
    /**
     * ポリゴンの中に全て入っているか判定
     * @param v　ポリゴン
     * @return 　ポリゴン内:true
     * 　　　　　ポリゴン外:false
    **/
    getPoints(): GPoint2Df[];
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode: ObjectFolder): void;
    drawGeom(dr: IRichGraphics, fore: KColor, back: KColor): void;
    drawAlias(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    drawAbstDevice(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    drawHighLight(d: IRichGraphics, c: KColor, outline: boolean): void;
    /**
     * ポリラインの構成点列をLineとして、一番近いものを取得
     * @param x
     * @param y
     * @return
    **/
    getNearAsLine(x: number, y: number): GLine;
    flipx(x: number, ofsx: number): void;
    flipy(y: number, ofsy: number): void;
    rot(x: number, y: number, ofsx: number, ofsy: number): void;
    /**
     * 塗り潰しモードの設定**/
    setFillMode(flag: boolean): void;
    isFillMode(): boolean;
    /**
     * @return Returns the mFillColor.**/
    getFillColor(): KColor;
    /**
     * @param fillColor The mFillColor to set.**/
    setFillColor(fillColor: KColor): void;
    getPointAt(n: number): GPoint2Df;
}
